/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.utils.eisutils.config;

import de.eisi05.bingo.Main;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public record ItemConfiguration<Z>(ItemStack item) {
    private static final Class<?>[] classes = new Class[]{String.class, Short.class, Long.class, Byte.class, Double.class, Integer.class, Byte[].class, Float.class, Integer[].class, Long[].class, PersistentDataContainer.class, PersistentDataContainer[].class};
    private static final PersistentDataType[] types = new PersistentDataType[]{PersistentDataType.STRING, PersistentDataType.SHORT, PersistentDataType.LONG, PersistentDataType.BYTE, PersistentDataType.DOUBLE, PersistentDataType.INTEGER, PersistentDataType.BYTE_ARRAY, PersistentDataType.FLOAT, PersistentDataType.INTEGER_ARRAY, PersistentDataType.LONG_ARRAY, PersistentDataType.TAG_CONTAINER};

    public ItemConfiguration<Z> setData(String key, Z value) {
        ItemMeta meta = this.item.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        container.set(new NamespacedKey(Main.plugin, key), this.getType(value), value);
        this.item.setItemMeta(meta);
        return this;
    }

    public Z getData(String key) {
        ItemMeta meta = this.item.getItemMeta();
        if (meta == null) {
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (this.hasData(key)) {
            return (Z)container.get(new NamespacedKey(Main.plugin, key), this.getType(new NamespacedKey(Main.plugin, key), container));
        }
        return null;
    }

    public List<String> getKeys() {
        ItemMeta meta = this.item.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        ArrayList<String> list = new ArrayList<String>();
        for (NamespacedKey key : container.getKeys()) {
            if (!key.getNamespace().equalsIgnoreCase(Main.plugin.getName())) continue;
            list.add(key.getKey());
        }
        return list;
    }

    public Z getOrDefault(String key, Z defaultData) {
        ItemMeta meta = this.item.getItemMeta();
        if (meta == null) {
            return defaultData;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (this.hasData(key)) {
            return (Z)container.get(new NamespacedKey(Main.plugin, key), this.getType(new NamespacedKey(Main.plugin, key), container));
        }
        return defaultData;
    }

    public ItemConfiguration<Z> removeData(String key) {
        ItemMeta meta = this.item.getItemMeta();
        if (meta == null) {
            return this;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        container.remove(new NamespacedKey(Main.plugin, key));
        this.item.setItemMeta(meta);
        return this;
    }

    public ItemConfiguration<Z> clearData() {
        ItemMeta meta = this.item.getItemMeta();
        if (meta == null) {
            return this;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        container.getKeys().forEach(arg_0 -> ((PersistentDataContainer)container).remove(arg_0));
        this.item.setItemMeta(meta);
        return this;
    }

    public boolean hasData(String key) {
        ItemMeta meta = this.item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        for (NamespacedKey s : container.getKeys()) {
            if (!s.getKey().equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    public void removeAllData() {
        for (String key : this.getKeys()) {
            this.removeData(key);
        }
    }

    public void updatePlugin() {
        ItemMeta meta = this.item.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        for (NamespacedKey s : container.getKeys()) {
            if (s.getNamespace().equalsIgnoreCase(Main.plugin.getName())) continue;
            NamespacedKey nK = new NamespacedKey(Main.plugin, s.getKey());
            container.set(nK, this.getType(s, container), container.get(s, this.getType(s, container)));
            container.remove(s);
            this.item.setItemMeta(meta);
        }
    }

    private PersistentDataType getType(NamespacedKey namespacedKey, PersistentDataContainer container) {
        for (PersistentDataType type : types) {
            if (!container.has(namespacedKey, type)) continue;
            return type;
        }
        return null;
    }

    private PersistentDataType getType(Z value) {
        for (Class<?> c : classes) {
            if (!c.equals(value.getClass())) continue;
            return types[Arrays.asList(classes).indexOf(c)];
        }
        return null;
    }
}

