/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.commands;

import de.eisi05.bingo.bingo.BingoObject;
import de.eisi05.bingo.bingo.BingoTeam;
import de.eisi05.bingo.commands.AbstractCommand;
import de.eisi05.bingo.game.GameState;
import de.eisi05.bingo.utils.BingoUtils;
import de.eisi05.bingo.utils.eisutils.builder.InventoryBuilder;
import de.eisi05.bingo.utils.eisutils.builder.ScrollInventory;
import dev.jorel.commandapi.executors.CommandArguments;
import java.util.Optional;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.IChatBaseComponent;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;

public non-sealed class BingoCommand
extends AbstractCommand
implements InventoryHolder {
    public BingoCommand() {
        super("bingo", "command.bingo.description", "Opens the bingo board");
        this.withPermission("bingo");
        this.withFullDescription("Opens the bingo board");
        this.executesPlayer((Player player, CommandArguments args) -> {
            if (GameState.currentGameState != GameState.INGAME) {
                BingoUtils.sendMessage((HumanEntity)player, (IChatBaseComponent)IChatBaseComponent.a((String)"game.none", (String)"There is no game running!").a(EnumChatFormat.m), true);
                return;
            }
            Optional<BingoTeam> team = BingoTeam.getTeam(player.getUniqueId());
            if (team.isEmpty()) {
                BingoUtils.sendMessage((HumanEntity)player, (IChatBaseComponent)IChatBaseComponent.a((String)"team.none", (String)"You are not in any team!").a(EnumChatFormat.m), true);
                return;
            }
            player.openInventory(this.getBingoInventory(team.get()));
        });
        this.register();
    }

    private Inventory getBingoInventory(BingoTeam team) {
        int maxInvSize = 54;
        if (BingoObject.getSelectedObjects().size() < maxInvSize) {
            InventoryType type = switch (BingoObject.getSelectedObjects().size()) {
                case 1, 2, 3, 4, 5 -> InventoryType.HOPPER;
                case 9 -> InventoryType.DROPPER;
                default -> InventoryType.CHEST;
            };
            int objects = BingoObject.getSelectedObjects().size();
            int invSize = objects % 9 == 0 ? objects : (objects / 9 + 1) * 9;
            InventoryBuilder inventoryBuilder = type == InventoryType.CHEST ? new InventoryBuilder((InventoryHolder)this, invSize, "Bingo") : new InventoryBuilder((InventoryHolder)this, type, "Bingo");
            inventoryBuilder.addItems(team.getBingoItems());
            return inventoryBuilder.normal().build();
        }
        return new ScrollInventory(this, IChatBaseComponent.b((String)"Bingo"), team.getBingoItems(), true, new ScrollInventory.Hotbar[0]).setArrowBackEvent(event -> event.getWhoClicked().closeInventory()).start();
    }

    @NotNull
    public Inventory getInventory() {
        return null;
    }
}

