/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.utils.eisutils.builder;

import de.eisi05.bingo.Main;
import de.eisi05.bingo.utils.eisutils.builder.ItemBuilder;
import de.eisi05.bingo.utils.eisutils.inventory.Arrow;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftContainer;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftInventoryCustom;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class InventoryBuilder
implements InventoryHolder {
    private final Inventory inventory;
    private final int size;

    public InventoryBuilder(int size, String name) {
        this.inventory = new CraftInventoryCustom((InventoryHolder)this, size, name);
        this.size = size;
    }

    public InventoryBuilder(InventoryHolder holder, int size, String name) {
        this.inventory = new CraftInventoryCustom(holder, size, name);
        this.size = size;
    }

    public InventoryBuilder(InventoryHolder holder, InventoryType type, String name) {
        this.inventory = new CraftInventoryCustom(holder, type, name);
        this.size = type.getDefaultSize();
    }

    public InventoryBuilder(Inventory inventory) {
        this.inventory = inventory;
        this.size = inventory.getSize();
    }

    public InventoryBuilder normal() {
        return this.normal(event -> event.setCancelled(true));
    }

    public InventoryBuilder normal(Consumer<InventoryClickEvent> event) {
        return this.replace(null, new ItemBuilder(ItemBuilder.PlaceHolder()).setClickHandler(event).build());
    }

    public InventoryBuilder fill(int first, int last, ItemStack item) {
        while (first <= last) {
            this.inventory.setItem(first, item);
            ++first;
        }
        return this;
    }

    public InventoryBuilder setItem(int i, ItemStack item) {
        if (i < 0) {
            i = this.inventory.getSize() + i;
        }
        this.inventory.setItem(i, item);
        return this;
    }

    public InventoryBuilder setItem(int i, Material material) {
        return this.setItem(i, new ItemStack(material));
    }

    public InventoryBuilder replace(ItemStack i1, ItemStack i2) {
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            if (this.inventory.getItem(i) == null) {
                if (i1 != null) continue;
                this.setItem(i, i2);
                continue;
            }
            if (!this.inventory.getItem(i).isSimilar(i1)) continue;
            this.setItem(i, i2);
        }
        return this;
    }

    public InventoryBuilder setArrowLeft(IChatBaseComponent name, Consumer<InventoryClickEvent> event) {
        this.inventory.setItem(this.inventory.getSize() - 9, Arrow.left(name).setClickHandler(event).build());
        return this;
    }

    public InventoryBuilder setArrowRight(IChatBaseComponent name, Consumer<InventoryClickEvent> event) {
        this.inventory.setItem(this.inventory.getSize() - 1, Arrow.right(name).setClickHandler(event).build());
        return this;
    }

    public InventoryBuilder addItem(ItemStack item) {
        this.inventory.addItem(new ItemStack[]{item});
        return this;
    }

    public InventoryBuilder addItems(List<ItemStack> items) {
        for (ItemStack item : items) {
            this.addItem(item);
        }
        return this;
    }

    public int getSize() {
        return this.size;
    }

    public Inventory build() {
        return this.inventory;
    }

    public void openAsNMS(HumanEntity player, IChatBaseComponent title) {
        player.openInventory(this.inventory);
        EntityPlayer entityPlayer = (EntityPlayer)((CraftHumanEntity)player).getHandle();
        entityPlayer.g.b((Packet)new PacketPlayOutOpenWindow(entityPlayer.cn.l, CraftContainer.getNotchInventoryType((Inventory)this.inventory), title));
        ((Player)player).updateInventory();
    }

    public void open(HumanEntity player) {
        player.openInventory(this.build());
    }

    public void openAsNMS(HumanEntity player, Animation animation, IChatBaseComponent title) {
        if (this.inventory.getType() != InventoryType.CHEST) {
            this.openAsNMS(player, title);
            return;
        }
        if (animation.count == animation.type.getMaxCount(this.inventory)) {
            return;
        }
        if (animation.original == null) {
            animation.original = (ItemStack[])this.inventory.getContents().clone();
        }
        this.fill(0, this.inventory.getSize() - 1, null);
        for (int i : animation.type.getSlots(animation.count, this.inventory)) {
            this.inventory.setItem(i, animation.original[i]);
        }
        if (animation.sound != null && player instanceof Player) {
            Player player1 = (Player)player;
            if (animation.count != -1) {
                player1.playSound((Entity)player1, animation.sound, 100.0f, 1.0f);
            }
        }
        this.openAsNMS(player, title);
        Bukkit.getScheduler().runTaskLater(Main.plugin, () -> {
            ++animation.count;
            this.openAsNMS(player, animation, title);
        }, (long)animation.speed);
    }

    public void open(HumanEntity player, Animation animation) {
        if (this.inventory.getType() != InventoryType.CHEST) {
            this.open(player);
            return;
        }
        if (animation.count == animation.type.getMaxCount(this.inventory)) {
            return;
        }
        if (animation.original == null) {
            animation.original = (ItemStack[])this.inventory.getContents().clone();
        }
        this.fill(0, this.inventory.getSize() - 1, null);
        for (int i : animation.type.getSlots(animation.count, this.inventory)) {
            this.inventory.setItem(i, animation.original[i]);
        }
        if (animation.sound != null && player instanceof Player) {
            Player player1 = (Player)player;
            if (animation.count != -1) {
                player1.playSound((Entity)player1, animation.sound, 100.0f, 1.0f);
            }
        }
        player.openInventory(this.inventory);
        Bukkit.getScheduler().runTaskLater(Main.plugin, () -> {
            ++animation.count;
            this.open(player, animation);
        }, (long)animation.speed);
    }

    @NotNull
    public Inventory getInventory() {
        return this.build();
    }

    public static class Animation {
        private final AnimationType type;
        private final int speed;
        private int count;
        private Sound sound;
        private ItemStack[] original;

        public Animation(AnimationType type, int speed) {
            this.type = type;
            this.speed = speed;
            this.count = -1;
        }

        public Animation(AnimationType type, int speed, Sound sound) {
            this(type, speed);
            this.sound = sound;
        }
    }

    public static enum AnimationType {
        RIGHT{

            @Override
            List<Integer> getSlots(int count, Inventory inventory) {
                if (count == -1) {
                    return new ArrayList<Integer>();
                }
                List<Integer> slots = this.getSlots(count - 1, inventory);
                for (int i = 0; i < inventory.getSize(); ++i) {
                    if ((i + 10 + count) % 9 != 0) continue;
                    slots.add(i);
                }
                return slots;
            }

            @Override
            int getMaxCount(Inventory inventory) {
                return 9;
            }
        }
        ,
        LEFT{

            @Override
            List<Integer> getSlots(int count, Inventory inventory) {
                if (count == -1) {
                    return new ArrayList<Integer>();
                }
                List<Integer> slots = this.getSlots(count - 1, inventory);
                for (int i = 0; i < inventory.getSize(); ++i) {
                    if ((i + 9 - count) % 9 != 0) continue;
                    slots.add(i);
                }
                return slots;
            }

            @Override
            int getMaxCount(Inventory inventory) {
                return 9;
            }
        }
        ,
        DOWN{

            @Override
            List<Integer> getSlots(int count, Inventory inventory) {
                ArrayList<Integer> slots = new ArrayList<Integer>();
                for (int i = 0; i < inventory.getSize(); ++i) {
                    if (inventory.getSize() - (count + 1) * 9 > i) continue;
                    slots.add(i);
                }
                return slots;
            }

            @Override
            int getMaxCount(Inventory inventory) {
                return inventory.getSize() / 9;
            }
        }
        ,
        UP{

            @Override
            List<Integer> getSlots(int count, Inventory inventory) {
                ArrayList<Integer> slots = new ArrayList<Integer>();
                for (int i = 0; i < inventory.getSize(); ++i) {
                    if ((count + 1) * 9 <= i) continue;
                    slots.add(i);
                }
                return slots;
            }

            @Override
            int getMaxCount(Inventory inventory) {
                return inventory.getSize() / 9;
            }
        };


        abstract List<Integer> getSlots(int var1, Inventory var2);

        abstract int getMaxCount(Inventory var1);
    }
}

