/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.inthecorners.network;

import java.util.function.Supplier;
import net.mcreator.inthecorners.InTheCornersMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class InTheCornersModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        InTheCornersMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        InTheCornersMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.musictick = message.data.musictick;
                    variables.musicwait = message.data.musicwait;
                    variables.musiclock = message.data.musiclock;
                    variables.musicreplace = message.data.musicreplace;
                    variables.musicplay = message.data.musicplay;
                    variables.musictick2 = message.data.musictick2;
                    variables.musicwait2 = message.data.musicwait2;
                    variables.musiclock2 = message.data.musiclock2;
                    variables.musicreplace2 = message.data.musicreplace2;
                    variables.musicplay2 = message.data.musicplay2;
                    variables.musictick3 = message.data.musictick3;
                    variables.musicwait3 = message.data.musicwait3;
                    variables.musiclock3 = message.data.musiclock3;
                    variables.musicreplace3 = message.data.musicreplace3;
                    variables.musicplay3 = message.data.musicplay3;
                    variables.mt1 = message.data.mt1;
                    variables.mw1 = message.data.mw1;
                    variables.ml1 = message.data.ml1;
                    variables.mr1 = message.data.mr1;
                    variables.mp1 = message.data.mp1;
                    variables.mt2 = message.data.mt2;
                    variables.mw2 = message.data.mw2;
                    variables.ml2 = message.data.ml2;
                    variables.mr2 = message.data.mr2;
                    variables.mp2 = message.data.mp2;
                    variables.mt3 = message.data.mt3;
                    variables.mw3 = message.data.mw3;
                    variables.ml3 = message.data.ml3;
                    variables.mr3 = message.data.mr3;
                    variables.mp3 = message.data.mp3;
                    variables.mt4 = message.data.mt4;
                    variables.mw4 = message.data.mw4;
                    variables.ml4 = message.data.ml4;
                    variables.mr4 = message.data.mr4;
                    variables.mp4 = message.data.mp4;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double musictick = 0.0;
        public double musicwait = 0.0;
        public boolean musiclock = false;
        public boolean musicreplace = false;
        public String musicplay = "\"\"";
        public double musictick2 = 0.0;
        public double musicwait2 = 0.0;
        public boolean musiclock2 = false;
        public boolean musicreplace2 = false;
        public String musicplay2 = "\"\"";
        public double musictick3 = 0.0;
        public double musicwait3 = 0.0;
        public boolean musiclock3 = false;
        public boolean musicreplace3 = false;
        public String musicplay3 = "\"\"";
        public double mt1 = 0.0;
        public double mw1 = 0.0;
        public boolean ml1 = false;
        public boolean mr1 = false;
        public String mp1 = "\"\"";
        public double mt2 = 0.0;
        public double mw2 = 0.0;
        public boolean ml2 = false;
        public boolean mr2 = false;
        public String mp2 = "\"\"";
        public double mt3 = 0.0;
        public double mw3 = 0.0;
        public boolean ml3 = false;
        public boolean mr3 = false;
        public String mp3 = "\"\"";
        public double mt4 = 0.0;
        public double mw4 = 0.0;
        public boolean ml4 = false;
        public boolean mr4 = false;
        public String mp4 = "\"\"";

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                InTheCornersMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("musictick", this.musictick);
            nbt.m_128347_("musicwait", this.musicwait);
            nbt.m_128379_("musiclock", this.musiclock);
            nbt.m_128379_("musicreplace", this.musicreplace);
            nbt.m_128359_("musicplay", this.musicplay);
            nbt.m_128347_("musictick2", this.musictick2);
            nbt.m_128347_("musicwait2", this.musicwait2);
            nbt.m_128379_("musiclock2", this.musiclock2);
            nbt.m_128379_("musicreplace2", this.musicreplace2);
            nbt.m_128359_("musicplay2", this.musicplay2);
            nbt.m_128347_("musictick3", this.musictick3);
            nbt.m_128347_("musicwait3", this.musicwait3);
            nbt.m_128379_("musiclock3", this.musiclock3);
            nbt.m_128379_("musicreplace3", this.musicreplace3);
            nbt.m_128359_("musicplay3", this.musicplay3);
            nbt.m_128347_("mt1", this.mt1);
            nbt.m_128347_("mw1", this.mw1);
            nbt.m_128379_("ml1", this.ml1);
            nbt.m_128379_("mr1", this.mr1);
            nbt.m_128359_("mp1", this.mp1);
            nbt.m_128347_("mt2", this.mt2);
            nbt.m_128347_("mw2", this.mw2);
            nbt.m_128379_("ml2", this.ml2);
            nbt.m_128379_("mr2", this.mr2);
            nbt.m_128359_("mp2", this.mp2);
            nbt.m_128347_("mt3", this.mt3);
            nbt.m_128347_("mw3", this.mw3);
            nbt.m_128379_("ml3", this.ml3);
            nbt.m_128379_("mr3", this.mr3);
            nbt.m_128359_("mp3", this.mp3);
            nbt.m_128347_("mt4", this.mt4);
            nbt.m_128347_("mw4", this.mw4);
            nbt.m_128379_("ml4", this.ml4);
            nbt.m_128379_("mr4", this.mr4);
            nbt.m_128359_("mp4", this.mp4);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.musictick = nbt.m_128459_("musictick");
            this.musicwait = nbt.m_128459_("musicwait");
            this.musiclock = nbt.m_128471_("musiclock");
            this.musicreplace = nbt.m_128471_("musicreplace");
            this.musicplay = nbt.m_128461_("musicplay");
            this.musictick2 = nbt.m_128459_("musictick2");
            this.musicwait2 = nbt.m_128459_("musicwait2");
            this.musiclock2 = nbt.m_128471_("musiclock2");
            this.musicreplace2 = nbt.m_128471_("musicreplace2");
            this.musicplay2 = nbt.m_128461_("musicplay2");
            this.musictick3 = nbt.m_128459_("musictick3");
            this.musicwait3 = nbt.m_128459_("musicwait3");
            this.musiclock3 = nbt.m_128471_("musiclock3");
            this.musicreplace3 = nbt.m_128471_("musicreplace3");
            this.musicplay3 = nbt.m_128461_("musicplay3");
            this.mt1 = nbt.m_128459_("mt1");
            this.mw1 = nbt.m_128459_("mw1");
            this.ml1 = nbt.m_128471_("ml1");
            this.mr1 = nbt.m_128471_("mr1");
            this.mp1 = nbt.m_128461_("mp1");
            this.mt2 = nbt.m_128459_("mt2");
            this.mw2 = nbt.m_128459_("mw2");
            this.ml2 = nbt.m_128471_("ml2");
            this.mr2 = nbt.m_128471_("mr2");
            this.mp2 = nbt.m_128461_("mp2");
            this.mt3 = nbt.m_128459_("mt3");
            this.mw3 = nbt.m_128459_("mw3");
            this.ml3 = nbt.m_128471_("ml3");
            this.mr3 = nbt.m_128471_("mr3");
            this.mp3 = nbt.m_128461_("mp3");
            this.mt4 = nbt.m_128459_("mt4");
            this.mw4 = nbt.m_128459_("mw4");
            this.ml4 = nbt.m_128471_("ml4");
            this.mr4 = nbt.m_128471_("mr4");
            this.mp4 = nbt.m_128461_("mp4");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("in_the_corners", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "in_the_corners_mapvars";
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                InTheCornersMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "in_the_corners_worldvars";
        public boolean phase2spawn = false;
        public boolean entityspawn = false;
        public boolean providence = true;
        public boolean greeted = false;
        public boolean providenceexist = false;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.phase2spawn = nbt.m_128471_("phase2spawn");
            this.entityspawn = nbt.m_128471_("entityspawn");
            this.providence = nbt.m_128471_("providence");
            this.greeted = nbt.m_128471_("greeted");
            this.providenceexist = nbt.m_128471_("providenceexist");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("phase2spawn", this.phase2spawn);
            nbt.m_128379_("entityspawn", this.entityspawn);
            nbt.m_128379_("providence", this.providence);
            nbt.m_128379_("greeted", this.greeted);
            nbt.m_128379_("providenceexist", this.providenceexist);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                InTheCornersMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.musictick = original.musictick;
            clone.musicwait = original.musicwait;
            clone.musiclock = original.musiclock;
            clone.musicreplace = original.musicreplace;
            clone.musicplay = original.musicplay;
            clone.musictick2 = original.musictick2;
            clone.musicwait2 = original.musicwait2;
            clone.musiclock2 = original.musiclock2;
            clone.musicreplace2 = original.musicreplace2;
            clone.musicplay2 = original.musicplay2;
            clone.musictick3 = original.musictick3;
            clone.musicwait3 = original.musicwait3;
            clone.musiclock3 = original.musiclock3;
            clone.musicreplace3 = original.musicreplace3;
            clone.musicplay3 = original.musicplay3;
            clone.mt1 = original.mt1;
            clone.mw1 = original.mw1;
            clone.ml1 = original.ml1;
            clone.mr1 = original.mr1;
            clone.mp1 = original.mp1;
            clone.mt2 = original.mt2;
            clone.mw2 = original.mw2;
            clone.ml2 = original.ml2;
            clone.mr2 = original.mr2;
            clone.mp2 = original.mp2;
            clone.mt3 = original.mt3;
            clone.mw3 = original.mw3;
            clone.ml3 = original.ml3;
            clone.mr3 = original.mr3;
            clone.mp3 = original.mp3;
            clone.mt4 = original.mt4;
            clone.mw4 = original.mw4;
            clone.ml4 = original.ml4;
            clone.mr4 = original.mr4;
            clone.mp4 = original.mp4;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    InTheCornersMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    InTheCornersMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                InTheCornersMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

