/*
 * Decompiled with CFR 0.152.
 */
package org.hinoob.dynamicviewmodel;

import com.mojang.logging.LogUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.function.Consumer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import net.minecraft.class_642;
import org.bstats.MetricsBase;
import org.bstats.charts.SimplePie;
import org.bstats.json.JsonObjectBuilder;
import org.hinoob.dynamicviewmodel.util.Configuration;
import org.hinoob.dynamicviewmodel.util.Variables;
import org.slf4j.Logger;

public class DynamicViewModelClient
implements ClientModInitializer {
    public static final String MODID = "org/hinoob/dynamicviewmodel";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static Configuration configuration = new Configuration();

    public void onInitializeClient() {
        Variables.load();
        HashMap<String, String> chartData = new HashMap<String, String>();
        chartData.put("modVersion", "1.0.0");
        System.setProperty("bstats.relocatecheck", "false");
        MetricsBase metrics = new MetricsBase("bukkit", configuration.getClientId(), 27857, true, this.appendPlatformData(), this.appendServiceData(), runnable -> new Thread((Runnable)runnable).start(), () -> true, (s, t) -> System.err.println("[bStats] Error: " + s), s -> System.out.println("[bStats] Info: " + s), true, true, true);
        metrics.addCustomChart(new SimplePie("mod_version", () -> "1.0.0"));
        Method method = null;
        try {
            method = MetricsBase.class.getDeclaredMethod("submitData", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)metrics, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        ClientPlayConnectionEvents.JOIN.register((client, handler, sender) -> {
            try {
                class_642 info;
                class_310 mc = class_310.method_1551();
                if (mc != null && mc.method_1558() != null && (info = mc.method_1558()) != null && info.field_3761 != null) {
                    configuration.addConnectedServer(info.field_3761);
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to record connected server", (Throwable)e);
            }
        });
    }

    private Consumer<JsonObjectBuilder> appendPlatformData() {
        return builder -> {
            builder.appendField("osName", System.getProperty("os.name"));
            builder.appendField("osArch", System.getProperty("os.arch"));
            builder.appendField("javaVersion", System.getProperty("java.version"));
            builder.appendField("fabricVersion", FabricLoader.getInstance().getModContainer("fabricloader").map(container -> container.getMetadata().getVersion().getFriendlyString()).orElse("unknown"));
        };
    }

    private Consumer<JsonObjectBuilder> appendServiceData() {
        return builder -> {
            builder.appendField("modName", "dynamicviewmodel");
            builder.appendField("modVersion", "1.0.0");
        };
    }
}

