/*
 * Decompiled with CFR 0.152.
 */
package org.hinoob.dynamicviewmodel.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.hinoob.dynamicviewmodel.util.Vector3f;
import org.hinoob.dynamicviewmodel.util.VectorData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class Configuration {
    private static final Logger LOGGER = LoggerFactory.getLogger(Configuration.class);
    private File file;

    public Configuration() {
        this.resetFile();
        try {
            if (!this.file.exists()) {
                boolean created = this.file.createNewFile();
                if (!created) {
                    LOGGER.warn("Configuration file did not exist and could not be created: {}", (Object)this.file.getAbsolutePath());
                }
                HashMap<String, VectorData> defaultMap = new HashMap<String, VectorData>();
                defaultMap.put("normal", new VectorData());
                this.saveMap(defaultMap);
            }
        }
        catch (Exception var2) {
            LOGGER.error("Failed to initialize configuration file", (Throwable)var2);
        }
    }

    public void resetFile() {
        try {
            File dir = new File("dynamicviewmodel");
            if (!dir.exists() && !dir.mkdirs()) {
                LOGGER.warn("Could not create configuration directory: {}", (Object)dir.getAbsolutePath());
            }
        }
        catch (Exception var2) {
            LOGGER.error("Failed to reset configuration directory", (Throwable)var2);
        }
        this.file = new File("dynamicviewmodel", "config.yml");
    }

    public void saveMap(Map<String, VectorData> map) {
        Set<String> connected = this.loadConnectedServers();
        this.saveAll(map, connected, this.loadClientId());
    }

    private void saveAll(Map<String, VectorData> map, Set<String> connectedServers, String clientId) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.file));){
            Yaml yaml = new Yaml();
            HashMap vectorsOut = new HashMap();
            for (Map.Entry<String, VectorData> e : map.entrySet()) {
                VectorData vd = e.getValue();
                HashMap<String, Map<String, Object>> vdMap = new HashMap<String, Map<String, Object>>();
                vdMap.put("firstPersonLeftRotation", this.vecToMap(vd.firstPersonLeftRotation));
                vdMap.put("firstPersonLeftTranslation", this.vecToMap(vd.firstPersonLeftTranslation));
                vdMap.put("firstPersonLeftScale", this.vecToMap(vd.firstPersonLeftScale));
                vdMap.put("firstPersonRightRotation", this.vecToMap(vd.firstPersonRightRotation));
                vdMap.put("firstPersonRightTranslation", this.vecToMap(vd.firstPersonRightTranslation));
                vdMap.put("firstPersonRightScale", this.vecToMap(vd.firstPersonRightScale));
                vectorsOut.put(e.getKey(), vdMap);
            }
            HashMap<String, Object> root = new HashMap<String, Object>();
            root.put("vectors", vectorsOut);
            ArrayList<String> list = new ArrayList<String>();
            if (connectedServers != null) {
                list.addAll(connectedServers);
            }
            root.put("connectedServers", list);
            root.put("clientId", clientId);
            yaml.dump(root, writer);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to save configuration to YAML", (Throwable)ex);
        }
    }

    public Map<String, VectorData> loadMap() {
        HashMap<String, VectorData> result = new HashMap<String, VectorData>();
        Yaml yaml = new Yaml();
        try (FileInputStream fis = new FileInputStream(this.file);){
            Object obj = yaml.load(fis);
            if (obj instanceof Map) {
                Map vectorsObj;
                Map root = (Map)obj;
                Map map = vectorsObj = root.containsKey("vectors") ? root.get("vectors") : root;
                if (vectorsObj instanceof Map) {
                    Map vectorsMap = vectorsObj;
                    for (Map.Entry entry : vectorsMap.entrySet()) {
                        String key = String.valueOf(entry.getKey());
                        Object val = entry.getValue();
                        VectorData vd = new VectorData();
                        if (val instanceof Map) {
                            Map vm = (Map)val;
                            vd.firstPersonLeftRotation = this.mapToVec(vm.get("firstPersonLeftRotation"));
                            vd.firstPersonLeftTranslation = this.mapToVec(vm.get("firstPersonLeftTranslation"));
                            vd.firstPersonLeftScale = this.mapToVec(vm.get("firstPersonLeftScale"));
                            vd.firstPersonRightRotation = this.mapToVec(vm.get("firstPersonRightRotation"));
                            vd.firstPersonRightTranslation = this.mapToVec(vm.get("firstPersonRightTranslation"));
                            vd.firstPersonRightScale = this.mapToVec(vm.get("firstPersonRightScale"));
                        }
                        result.put(key, vd);
                    }
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to load YAML configuration, will use defaults", (Throwable)ex);
        }
        if (!result.containsKey("normal")) {
            result.put("normal", new VectorData());
        }
        return result;
    }

    public Set<String> loadConnectedServers() {
        HashSet<String> result = new HashSet<String>();
        Yaml yaml = new Yaml();
        try (FileInputStream fis = new FileInputStream(this.file);){
            Map root;
            Object listObj;
            Object obj = yaml.load(fis);
            if (obj instanceof Map && (listObj = (root = (Map)obj).get("connectedServers")) instanceof List) {
                for (Object o : (List)listObj) {
                    if (o == null) continue;
                    result.add(String.valueOf(o));
                }
            }
        }
        catch (Exception ex) {
            LOGGER.debug("No connected servers persisted or failed to read them", (Throwable)ex);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String loadClientId() {
        Yaml yaml = new Yaml();
        try (FileInputStream fis = new FileInputStream(this.file);){
            Map root;
            Object cidObj;
            Object obj = yaml.load(fis);
            if (obj instanceof Map && (cidObj = (root = (Map)obj).get("clientId")) != null) {
                String string = String.valueOf(cidObj);
                return string;
            }
        }
        catch (Exception ex) {
            LOGGER.debug("No client ID persisted or failed to read it", (Throwable)ex);
        }
        UUID uuid = UUID.randomUUID();
        this.saveClientId(uuid.toString());
        return uuid.toString();
    }

    public void saveClientId(String s) {
        Map<String, VectorData> vectors = this.loadMap();
        this.saveAll(vectors, this.loadConnectedServers(), s);
    }

    public void saveConnectedServers(Set<String> connectedServers) {
        Map<String, VectorData> vectors = this.loadMap();
        this.saveAll(vectors, connectedServers, this.loadClientId());
    }

    public void addConnectedServer(String address) {
        try {
            if (address == null) {
                return;
            }
            Set<String> connected = this.loadConnectedServers();
            if (connected.add(address)) {
                this.saveConnectedServers(connected);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to persist connected server", (Throwable)ex);
        }
    }

    private Map<String, Object> vecToMap(Vector3f v) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("x", Float.valueOf(v.x));
        m.put("y", Float.valueOf(v.y));
        m.put("z", Float.valueOf(v.z));
        return m;
    }

    private Vector3f mapToVec(Object obj) {
        if (!(obj instanceof Map)) {
            return new Vector3f();
        }
        Map vm = (Map)obj;
        float x = this.toFloat(vm.get("x"));
        float y = this.toFloat(vm.get("y"));
        float z = this.toFloat(vm.get("z"));
        return new Vector3f(x, y, z);
    }

    private float toFloat(Object o) {
        if (o == null) {
            return 0.0f;
        }
        if (o instanceof Number) {
            return ((Number)o).floatValue();
        }
        try {
            return Float.parseFloat(String.valueOf(o));
        }
        catch (Exception ex) {
            return 0.0f;
        }
    }

    public String get(String key) {
        Map<String, VectorData> map = this.loadMap();
        VectorData vd = map.get(key);
        return vd == null ? null : vd.toString();
    }

    public String getClientId() {
        return this.loadClientId();
    }

    public List<String> getLines() {
        try {
            ArrayList<String> lines = new ArrayList<String>();
            try (BufferedReader reader = new BufferedReader(new FileReader(this.file));){
                String line;
                while ((line = reader.readLine()) != null) {
                    lines.add(line);
                }
            }
            return lines;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to read configuration lines", (Throwable)e);
            return new ArrayList<String>();
        }
    }
}

