/*
 * Decompiled with CFR 0.152.
 */
package org.hinoob.dynamicviewmodel.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1306;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import org.hinoob.dynamicviewmodel.DynamicViewModelClient;
import org.hinoob.dynamicviewmodel.menu.SettingGui;
import org.hinoob.dynamicviewmodel.util.VectorData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Variables {
    private static final Logger LOGGER = LoggerFactory.getLogger(Variables.class);
    public static Map<String, VectorData> map = new HashMap<String, VectorData>();

    public static void resetToOriginal() {
        Variables.getActive().reset();
        SettingGui.settings.update();
    }

    public static void load() {
        try {
            map = DynamicViewModelClient.configuration.loadMap();
        }
        catch (Exception e) {
            LOGGER.error("Failed to load variables from configuration", (Throwable)e);
            map = new HashMap<String, VectorData>();
            map.put("normal", new VectorData());
        }
    }

    public static void save() {
        try {
            DynamicViewModelClient.configuration.saveMap(map);
        }
        catch (Exception e) {
            LOGGER.error("Failed to save variables to configuration", (Throwable)e);
        }
    }

    private static String itemNameFromStack(class_1799 stack) {
        if (stack == null) {
            return null;
        }
        String name = stack.method_7909().toString().toUpperCase();
        if (name.contains(":")) {
            name = name.split(":")[1];
        }
        return name;
    }

    private static String keyForHand(String baseName, boolean right) {
        if (baseName == null) {
            return null;
        }
        return baseName + (right ? "_RIGHT" : "_LEFT");
    }

    public static String getKeyForStack(class_1799 stack, boolean right) {
        String base = Variables.itemNameFromStack(stack);
        if (base == null) {
            return null;
        }
        return Variables.keyForHand(base, right);
    }

    public static VectorData getOrCreateForNameHand(String baseName, boolean rightHand) {
        if (baseName == null) {
            return map.getOrDefault("normal", new VectorData());
        }
        String handKey = Variables.keyForHand(baseName, rightHand);
        if (map.containsKey(handKey)) {
            return map.get(handKey);
        }
        if (map.containsKey(baseName)) {
            VectorData copy = map.get(baseName).copy();
            map.put(handKey, copy);
            return copy;
        }
        VectorData normal = map.getOrDefault("normal", new VectorData()).copy();
        map.put(handKey, normal);
        return normal;
    }

    public static VectorData getForStack(class_1799 stack, boolean rightHand) {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1724 == null) {
            return map.get("normal");
        }
        if (stack == null || stack.method_7960()) {
            return map.get("normal");
        }
        String baseName = Variables.itemNameFromStack(stack);
        if (baseName == null) {
            return map.get("normal");
        }
        String handKey = Variables.keyForHand(baseName, rightHand);
        if (map.containsKey(handKey)) {
            return map.get(handKey);
        }
        if (map.containsKey(baseName)) {
            return map.get(baseName);
        }
        return map.getOrDefault("normal", new VectorData());
    }

    public static VectorData getActive() {
        boolean offHasCfg;
        boolean offEmpty;
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1724 == null) {
            return map.get("normal");
        }
        class_1799 main = mc.field_1724.method_6047();
        class_1799 off = mc.field_1724.method_6079();
        boolean mainEmpty = main == null || main.method_7960();
        boolean bl = offEmpty = off == null || off.method_7960();
        if (mainEmpty && offEmpty) {
            return map.get("normal");
        }
        String mainName = Variables.itemNameFromStack(main);
        String offName = Variables.itemNameFromStack(off);
        boolean mainHasCfg = mainName != null && (map.containsKey(mainName) || map.containsKey(Variables.keyForHand(mainName, true)) || map.containsKey(Variables.keyForHand(mainName, false)));
        boolean bl2 = offHasCfg = offName != null && (map.containsKey(offName) || map.containsKey(Variables.keyForHand(offName, true)) || map.containsKey(Variables.keyForHand(offName, false)));
        if (!mainEmpty && !offEmpty) {
            if (mainHasCfg && offHasCfg) {
                return map.get("normal");
            }
            if (mainHasCfg) {
                boolean mainIsRight = mc.field_1724.method_6068() == class_1306.field_6183;
                return Variables.getForStack(main, mainIsRight);
            }
            if (offHasCfg) {
                boolean mainIsRight = mc.field_1724.method_6068() == class_1306.field_6183;
                return Variables.getForStack(off, !mainIsRight);
            }
            return map.get("normal");
        }
        if (!mainEmpty) {
            boolean mainIsRight = mc.field_1724.method_6068() == class_1306.field_6183;
            return Variables.getForStack(main, mainIsRight);
        }
        boolean mainIsRight = mc.field_1724.method_6068() == class_1306.field_6183;
        return Variables.getForStack(off, !mainIsRight);
    }

    public static String getActiveName() {
        boolean offHasCfg;
        boolean offEmpty;
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1724 == null) {
            return "normal";
        }
        class_1799 main = mc.field_1724.method_6047();
        class_1799 off = mc.field_1724.method_6079();
        boolean mainEmpty = main == null || main.method_7960();
        boolean bl = offEmpty = off == null || off.method_7960();
        if (mainEmpty && offEmpty) {
            return "normal";
        }
        String mainName = Variables.itemNameFromStack(main);
        String offName = Variables.itemNameFromStack(off);
        boolean mainHasCfg = mainName != null && (map.containsKey(mainName) || map.containsKey(Variables.keyForHand(mainName, true)) || map.containsKey(Variables.keyForHand(mainName, false)));
        boolean bl2 = offHasCfg = offName != null && (map.containsKey(offName) || map.containsKey(Variables.keyForHand(offName, true)) || map.containsKey(Variables.keyForHand(offName, false)));
        if (!mainEmpty && !offEmpty) {
            if (mainHasCfg && offHasCfg) {
                return "normal";
            }
            if (mainHasCfg) {
                return mainName;
            }
            if (offHasCfg) {
                return offName;
            }
            return "normal";
        }
        if (!mainEmpty) {
            return mainHasCfg ? mainName : "normal";
        }
        return offHasCfg ? offName : "normal";
    }
}

