/*
 * Decompiled with CFR 0.152.
 */
package goldenage.potatotech.blocks;

import goldenage.potatotech.PTItems;
import goldenage.potatotech.blocks.entities.TileEntityPipe;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import turniplabs.halplibe.helper.EnvironmentHelper;

public class BlockLogicPipe
extends BlockLogic {
    public BlockLogicPipe(Block<?> block, Material material) {
        super(block, material);
        this.setBlockBounds(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);
    }

    public boolean isSolidRender() {
        return false;
    }

    public boolean renderAsNormalBlockOnCondition(WorldSource world, int x, int y, int z) {
        return false;
    }

    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        TileEntityPipe te = (TileEntityPipe)world.getTileEntity(x, y, z);
        if (te != null) {
            te.dropItems();
        }
        super.onBlockRemoved(world, x, y, z, data);
    }

    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xHit, double yHit) {
        if (EnvironmentHelper.isClientWorld()) {
            return false;
        }
        TileEntityPipe te = (TileEntityPipe)world.getTileEntity(x, y, z);
        ItemStack heldItem = player.getHeldItem();
        if (heldItem == null) {
            te.dropItems();
        } else {
            if (heldItem.itemID == PTItems.wrench.id) {
                int mode = te.modeBySide[side.getId()];
                mode = (mode + 1) % 4;
                te.modeBySide[side.getId()] = (short)mode;
                world.markBlockNeedsUpdate(x, y, z);
                world.playSoundEffect((Entity)player, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, mode % 2 == 0 ? 0.5f : 0.6f);
                return true;
            }
            if (heldItem.itemID == Items.DYE.id) {
                te.colorBySide[side.getId()] = (short)(heldItem.getMetadata() + 1);
                world.markBlockNeedsUpdate(x, y, z);
                return true;
            }
            if (heldItem.getItem().getClass().getName().equals("goocraft4evr.nonamedyes.item.ItemModDye")) {
                te.colorBySide[side.getId()] = (short)(heldItem.getMetadata() + 17);
                world.markBlockNeedsUpdate(x, y, z);
                return true;
            }
            if (heldItem.itemID == Items.PAPER.id) {
                te.colorBySide[side.getId()] = 0;
                world.markBlockNeedsUpdate(x, y, z);
                return true;
            }
        }
        return false;
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        boolean flag;
        boolean bl = flag = world.hasDirectSignal(x, y, z) || world.hasNeighborSignal(x, y, z);
        if (flag) {
            world.scheduleBlockUpdate(x, y, z, this.id(), 0);
        }
        if (EnvironmentHelper.isServerEnvironment()) {
            world.markBlockNeedsUpdate(x, y, z);
        }
    }
}

