/*
 * Decompiled with CFR 0.152.
 */
package goldenage.potatotech;

import goldenage.potatotech.PipeStack;
import goldenage.potatotech.PotatoTech;
import goldenage.potatotech.blocks.entities.TileEntityChute;
import goldenage.potatotech.blocks.entities.TileEntityCrafter;
import goldenage.potatotech.blocks.entities.TileEntityFilter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.BlockLogicChest;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.block.entity.TileEntityFurnace;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public class Util {
    public static double[] crossProduct(double[] v0, double[] v1) {
        double[] crossProduct = new double[]{v0[1] * v1[2] - v0[2] * v1[1], v0[2] * v1[0] - v0[0] * v1[2], v0[0] * v1[1] - v0[1] * v1[0]};
        return crossProduct;
    }

    public static void normalize(double[] v) {
        double len = Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
        v[0] = v[0] / len;
        v[1] = v[1] / len;
        v[2] = v[2] / len;
    }

    public static void draw3dLine(double width, double x1, double y1, double z1, double x2, double y2, double z2, float r, float g, float b) {
        GL11.glPushAttrib((int)8192);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        Tessellator tessellator = Tessellator.instance;
        double l = Math.sqrt(x2 * x2 + y2 * y2 + z2 * x2);
        Vector3f norm = new Vector3f((float)(x2 - x1), (float)(y2 - y1), (float)(z2 - z1));
        norm.normalise(norm);
        Vector3f perp = new Vector3f(1.0f, 0.0f, 0.0f);
        if (Math.abs(norm.x) > 0.9f) {
            perp.x = 0.0f;
            perp.y = 0.0f;
            perp.z = 1.0f;
        } else if (Math.abs(norm.z) > 0.9f) {
            perp.x = 0.0f;
            perp.y = 1.0f;
            perp.z = 0.0f;
        }
        Vector3f up = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f.cross((Vector3f)norm, (Vector3f)perp, (Vector3f)up);
        up.normalise(up);
        Vector3f right = new Vector3f();
        Vector3f.cross((Vector3f)norm, (Vector3f)up, (Vector3f)right);
        up.x *= (float)(width * 0.5);
        up.y *= (float)(width * 0.5);
        up.z *= (float)(width * 0.5);
        right.x *= (float)(width * 0.5);
        right.y *= (float)(width * 0.5);
        right.z *= (float)(width * 0.5);
        tessellator.startDrawing(7);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
        tessellator.setNormal(-right.x, -right.y, -right.z);
        tessellator.addVertex(x1 - (double)up.x - (double)right.x, y1 - (double)up.y - (double)right.y, z1 - (double)up.z - (double)right.z);
        tessellator.addVertex(x1 + (double)up.x - (double)right.x, y1 + (double)up.y - (double)right.y, z1 + (double)up.z - (double)right.z);
        tessellator.addVertex(x2 + (double)up.x - (double)right.x, y2 + (double)up.y - (double)right.y, z2 + (double)up.z - (double)right.z);
        tessellator.addVertex(x2 - (double)up.x - (double)right.x, y2 - (double)up.y - (double)right.y, z2 - (double)up.z - (double)right.z);
        tessellator.setNormal(right.x, right.y, right.z);
        tessellator.addVertex(x1 - (double)up.x + (double)right.x, y1 - (double)up.y + (double)right.y, z1 - (double)up.z + (double)right.z);
        tessellator.addVertex(x2 - (double)up.x + (double)right.x, y2 - (double)up.y + (double)right.y, z2 - (double)up.z + (double)right.z);
        tessellator.addVertex(x2 + (double)up.x + (double)right.x, y2 + (double)up.y + (double)right.y, z2 + (double)up.z + (double)right.z);
        tessellator.addVertex(x1 + (double)up.x + (double)right.x, y1 + (double)up.y + (double)right.y, z1 + (double)up.z + (double)right.z);
        tessellator.setNormal(up.x, up.y, up.z);
        tessellator.addVertex(x1 - (double)right.x + (double)up.x, y1 - (double)right.y + (double)up.y, z1 - (double)right.z + (double)up.z);
        tessellator.addVertex(x1 + (double)right.x + (double)up.x, y1 + (double)right.y + (double)up.y, z1 + (double)right.z + (double)up.z);
        tessellator.addVertex(x2 + (double)right.x + (double)up.x, y2 + (double)right.y + (double)up.y, z2 + (double)right.z + (double)up.z);
        tessellator.addVertex(x2 - (double)right.x + (double)up.x, y2 - (double)right.y + (double)up.y, z2 - (double)right.z + (double)up.z);
        tessellator.setNormal(-up.x, -up.y, -up.z);
        tessellator.addVertex(x1 - (double)right.x - (double)up.x, y1 - (double)right.y - (double)up.y, z1 - (double)right.z - (double)up.z);
        tessellator.addVertex(x2 - (double)right.x - (double)up.x, y2 - (double)right.y - (double)up.y, z2 - (double)right.z - (double)up.z);
        tessellator.addVertex(x2 + (double)right.x - (double)up.x, y2 + (double)right.y - (double)up.y, z2 + (double)right.z - (double)up.z);
        tessellator.addVertex(x1 + (double)right.x - (double)up.x, y1 + (double)right.y - (double)up.y, z1 + (double)right.z - (double)up.z);
        tessellator.draw();
        GL11.glPopAttrib();
    }

    public static void draw3dLineWithTexture(int textureId, double width, double x1, double y1, double z1, double x2, double y2, double z2, float r, float g, float b) {
        GL11.glPushAttrib((int)8192);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
        Tessellator tessellator = Tessellator.instance;
        double l = Math.sqrt(x2 * x2 + y2 * y2 + z2 * x2);
        Vector3f norm = new Vector3f((float)(x2 - x1), (float)(y2 - y1), (float)(z2 - z1));
        norm.normalise(norm);
        Vector3f perp = new Vector3f(1.0f, 0.0f, 0.0f);
        if (Math.abs(norm.x) > 0.9f) {
            perp.x = 0.0f;
            perp.y = 0.0f;
            perp.z = 1.0f;
        } else if (Math.abs(norm.z) > 0.9f) {
            perp.x = 0.0f;
            perp.y = 1.0f;
            perp.z = 0.0f;
        }
        Vector3f up = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f.cross((Vector3f)norm, (Vector3f)perp, (Vector3f)up);
        up.normalise(up);
        Vector3f right = new Vector3f();
        Vector3f.cross((Vector3f)norm, (Vector3f)up, (Vector3f)right);
        up.x *= (float)(width * 0.5);
        up.y *= (float)(width * 0.5);
        up.z *= (float)(width * 0.5);
        right.x *= (float)(width * 0.5);
        right.y *= (float)(width * 0.5);
        right.z *= (float)(width * 0.5);
        tessellator.startDrawing(7);
        tessellator.addVertex(x1 - (double)up.x - (double)right.x, y1 - (double)up.y - (double)right.y, z1 - (double)up.z - (double)right.z);
        tessellator.addVertex(x1 + (double)up.x - (double)right.x, y1 + (double)up.y - (double)right.y, z1 + (double)up.z - (double)right.z);
        tessellator.addVertex(x2 + (double)up.x - (double)right.x, y2 + (double)up.y - (double)right.y, z2 + (double)up.z - (double)right.z);
        tessellator.addVertex(x2 - (double)up.x - (double)right.x, y2 - (double)up.y - (double)right.y, z2 - (double)up.z - (double)right.z);
        tessellator.addVertex(x1 - (double)up.x + (double)right.x, y1 - (double)up.y + (double)right.y, z1 - (double)up.z + (double)right.z);
        tessellator.addVertex(x2 - (double)up.x + (double)right.x, y2 - (double)up.y + (double)right.y, z2 - (double)up.z + (double)right.z);
        tessellator.addVertex(x2 + (double)up.x + (double)right.x, y2 + (double)up.y + (double)right.y, z2 + (double)up.z + (double)right.z);
        tessellator.addVertex(x1 + (double)up.x + (double)right.x, y1 + (double)up.y + (double)right.y, z1 + (double)up.z + (double)right.z);
        tessellator.addVertex(x1 - (double)right.x + (double)up.x, y1 - (double)right.y + (double)up.y, z1 - (double)right.z + (double)up.z);
        tessellator.addVertex(x1 + (double)right.x + (double)up.x, y1 + (double)right.y + (double)up.y, z1 + (double)right.z + (double)up.z);
        tessellator.addVertex(x2 + (double)right.x + (double)up.x, y2 + (double)right.y + (double)up.y, z2 + (double)right.z + (double)up.z);
        tessellator.addVertex(x2 - (double)right.x + (double)up.x, y2 - (double)right.y + (double)up.y, z2 - (double)right.z + (double)up.z);
        tessellator.addVertex(x1 - (double)right.x - (double)up.x, y1 - (double)right.y - (double)up.y, z1 - (double)right.z - (double)up.z);
        tessellator.addVertex(x2 - (double)right.x - (double)up.x, y2 - (double)right.y - (double)up.y, z2 - (double)right.z - (double)up.z);
        tessellator.addVertex(x2 + (double)right.x - (double)up.x, y2 + (double)right.y - (double)up.y, z2 + (double)right.z - (double)up.z);
        tessellator.addVertex(x1 + (double)right.x - (double)up.x, y1 + (double)right.y - (double)up.y, z1 + (double)right.z - (double)up.z);
        tessellator.draw();
        GL11.glPopAttrib();
    }

    public static ItemStack[] cloneStackArray(ItemStack[] stacks) {
        ItemStack[] _result = new ItemStack[stacks.length];
        for (int i = 0; i < _result.length; ++i) {
            ItemStack stack = stacks[i];
            _result[i] = new ItemStack(stack.itemID, stack.stackSize, stack.getMetadata());
        }
        return _result;
    }

    public static ItemStack removeItemFromStack(ItemStack stack) {
        ItemStack newStack = stack.copy();
        newStack.stackSize = 1;
        --stack.stackSize;
        return newStack;
    }

    public static PipeStack getItemFromInventoryNoCatch(World world, int x, int y, int z, Direction dir, int stackTimer) {
        ItemStack stack;
        PipeStack returnStack = null;
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof Container) {
            ItemStack stack2;
            Container inventory = (Container)te;
            String inventoryName = inventory.getNameTranslationKey();
            if (Objects.equals(inventoryName, "container.chest.name")) {
                inventory = BlockLogicChest.getInventory((World)world, (int)x, (int)y, (int)z);
            }
            if (Objects.equals(inventoryName, "container.chest.name") || Objects.equals(inventoryName, "container.dispenser.name") || inventoryName.startsWith("container.ironchest") || Objects.equals(inventoryName, "container.filter.name")) {
                int j;
                int inventorySize = inventory.getContainerSize();
                ItemStack stack3 = null;
                if (!inventoryName.equals("container.filter.name")) {
                    for (j = 0; stack3 == null && j < inventorySize; ++j) {
                        stack3 = inventory.getItem(j);
                    }
                } else {
                    while (stack3 == null && j < inventorySize) {
                        stack3 = inventory.getItem(j);
                        if (stack3 != null && stack3.stackSize <= 1) {
                            stack3 = null;
                        }
                        ++j;
                    }
                }
                if (stack3 != null && j > 0) {
                    short color = 0;
                    if (Objects.equals(inventoryName, "container.filter.name")) {
                        TileEntityFilter filter = (TileEntityFilter)inventory;
                        color = filter.getColorInSlot(j - 1);
                    }
                    returnStack = new PipeStack(Util.removeItemFromStack(stack3), dir, stackTimer, color);
                    if (stack3.stackSize <= 0) {
                        stack3 = null;
                    }
                    inventory.setItem(j - 1, stack3);
                    return returnStack;
                }
            } else if (Objects.equals(inventoryName, "container.trommel.name")) {
                int j;
                int inventorySize = 4;
                ItemStack stack4 = null;
                for (j = 0; stack4 == null && j < inventorySize; ++j) {
                    stack4 = inventory.getItem(j);
                }
                if (stack4 != null && j > 0) {
                    returnStack = new PipeStack(Util.removeItemFromStack(stack4), dir, stackTimer);
                    if (stack4.stackSize <= 0) {
                        stack4 = null;
                    }
                    inventory.setItem(j - 1, stack4);
                    return returnStack;
                }
            } else if (Objects.equals(inventoryName, "container.crafter.name")) {
                TileEntityCrafter ac = (TileEntityCrafter)te;
                ItemStack stack5 = ac.removeOneResult();
                if (stack5 != null) {
                    returnStack = new PipeStack(Util.removeItemFromStack(stack5), dir, stackTimer);
                } else {
                    ItemStack extra = ac.extraOutputs.getItem(0);
                    if (extra != null) {
                        ItemStack r = Util.removeItemFromStack(extra);
                        if (extra.stackSize <= 0) {
                            ac.extraOutputs.setItem(0, null);
                        }
                        returnStack = new PipeStack(r, dir, stackTimer);
                    }
                }
            } else if (te instanceof TileEntityFlag) {
                ItemStack stack6 = inventory.getItem(36);
                if (stack6 != null) {
                    returnStack = new PipeStack(Util.removeItemFromStack(stack6), dir, stackTimer);
                    if (stack6.stackSize <= 0) {
                        stack6 = null;
                    }
                    inventory.setItem(36, stack6);
                }
            } else if (te instanceof TileEntityFurnace) {
                ItemStack stack7 = inventory.getItem(2);
                if (stack7 != null) {
                    returnStack = new PipeStack(Util.removeItemFromStack(stack7), dir, stackTimer);
                    if (stack7.stackSize <= 0) {
                        stack7 = null;
                    }
                    inventory.setItem(2, stack7);
                }
            } else if (inventory.getContainerSize() > 0 && (stack2 = inventory.getItem(0)) != null) {
                returnStack = new PipeStack(Util.removeItemFromStack(stack2), dir, stackTimer);
                if (stack2.stackSize <= 0) {
                    stack2 = null;
                }
                inventory.setItem(0, stack2);
            }
        } else if (te instanceof TileEntityChute && dir == Direction.UP && (stack = ((TileEntityChute)te).removeOneItem()) != null) {
            returnStack = new PipeStack(stack, dir, stackTimer);
        }
        return returnStack;
    }

    public static PipeStack getItemFromInventory(World world, int x, int y, int z, Direction dir, int stackTimer) {
        PipeStack result = null;
        try {
            result = Util.getItemFromInventoryNoCatch(world, x, y, z, dir, stackTimer);
        }
        catch (Exception e) {
            PotatoTech.LOGGER.error(e.getMessage());
        }
        return result;
    }

    public static boolean insertOnInventoryNoCatch(Container inventory, ItemStack stack, Direction direction) {
        boolean hasInserted;
        block9: {
            String inventoryName;
            int inventorySize;
            block10: {
                int maxStackSize;
                ItemStack flagStack;
                int targetSlot;
                block11: {
                    block7: {
                        int targetSlot2;
                        ItemStack furnaceStack;
                        block8: {
                            int inputSlot;
                            hasInserted = false;
                            if (inventory == null) {
                                System.out.println(Arrays.toString(new NullPointerException("Null Pointer in insertOnInventory!!").getStackTrace()));
                                StringBuilder builder = new StringBuilder("Error something is null when it shouldn't be!! | Inventory: ");
                                System.out.println(builder);
                                PotatoTech.LOGGER.info(builder.toString());
                                return false;
                            }
                            inventorySize = inventory.getContainerSize();
                            inventoryName = inventory.getNameTranslationKey();
                            if (!(inventory instanceof TileEntityFurnace) && !Objects.equals(inventoryName, "container.trommel.name")) break block7;
                            int fuelSlot = 1;
                            if (Objects.equals(inventoryName, "container.trommel.name")) {
                                fuelSlot = 4;
                                for (inputSlot = 0; inputSlot < 3; ++inputSlot) {
                                    int maxStackSize2;
                                    ItemStack s = inventory.getItem(inputSlot);
                                    int n = maxStackSize2 = inventory.getMaxStackSize() != 64 ? inventory.getMaxStackSize() : s.getMaxStackSize();
                                    if (s == null || s.canStackWith(stack) && s.stackSize < maxStackSize2) break;
                                }
                            }
                            if ((furnaceStack = inventory.getItem(targetSlot2 = direction == Direction.UP ? fuelSlot : inputSlot)) != null) break block8;
                            inventory.setItem(targetSlot2, stack);
                            hasInserted = true;
                            break block9;
                        }
                        int maxStackSize3 = 8;
                        if (!furnaceStack.canStackWith(stack) || furnaceStack.stackSize >= maxStackSize3) break block9;
                        ++furnaceStack.stackSize;
                        inventory.setItem(targetSlot2, furnaceStack);
                        hasInserted = true;
                        break block9;
                    }
                    if (!(inventory instanceof TileEntityFlag)) break block10;
                    targetSlot = 36;
                    flagStack = inventory.getItem(targetSlot);
                    if (flagStack != null) break block11;
                    inventory.setItem(targetSlot, stack);
                    hasInserted = true;
                    break block9;
                }
                int n = maxStackSize = inventory.getMaxStackSize() != 64 ? inventory.getMaxStackSize() : flagStack.getMaxStackSize();
                if (!flagStack.canStackWith(stack) || flagStack.stackSize >= maxStackSize) break block9;
                ++flagStack.stackSize;
                inventory.setItem(targetSlot, flagStack);
                hasInserted = true;
                break block9;
            }
            if (Objects.equals(inventoryName, "container.crafter.name")) {
                TileEntityCrafter ac = (TileEntityCrafter)inventory;
                hasInserted = ac.insertItem(stack);
            } else {
                for (int j = 0; j < inventorySize; ++j) {
                    int maxStackSize;
                    ItemStack chestStack = inventory.getItem(j);
                    if (chestStack == null) {
                        if (inventoryName.equals("container.filter.name") || inventoryName.equals("container.crafter.name")) break;
                        inventory.setItem(j, stack);
                        hasInserted = true;
                        break;
                    }
                    int n = maxStackSize = inventory.getMaxStackSize() != 64 ? inventory.getMaxStackSize() : chestStack.getMaxStackSize();
                    if (!chestStack.canStackWith(stack) || chestStack.stackSize >= maxStackSize) continue;
                    ++chestStack.stackSize;
                    inventory.setItem(j, chestStack);
                    hasInserted = true;
                    break;
                }
            }
        }
        return hasInserted;
    }

    public static boolean canInsertOnInventory(World world, int x, int y, int z, Direction dir, ItemStack item) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te == null) {
            return false;
        }
        if (!(te instanceof Container)) {
            return false;
        }
        if (te instanceof TileEntityFilter) {
            return ((TileEntityFilter)te).canInsertItem(item);
        }
        Container inventory = (Container)te;
        int inventorySize = inventory.getContainerSize();
        String inventoryName = inventory.getNameTranslationKey();
        if (Objects.equals(inventoryName, "container.chest.name") || Objects.equals(inventoryName, "container.dispenser.name") || inventoryName.startsWith("container.ironchest") || Objects.equals(inventoryName, "container.filter.name") || Objects.equals(inventoryName, "container.crafter.name")) {
            for (int j = 0; j < inventorySize; ++j) {
                int maxStackSize;
                ItemStack chestStack = inventory.getItem(j);
                if (chestStack == null) {
                    return !inventoryName.equals("container.filter.name");
                }
                int n = maxStackSize = inventory.getMaxStackSize() != 64 ? inventory.getMaxStackSize() : chestStack.getMaxStackSize();
                if (!chestStack.canStackWith(item) || chestStack.stackSize >= maxStackSize) continue;
                return true;
            }
        } else {
            int targetSlot;
            ItemStack furnaceStack;
            int inputSlot;
            if (inventory instanceof TileEntityFlag) {
                int targetSlot2 = 36;
                ItemStack flagStack = inventory.getItem(targetSlot2);
                if (flagStack == null) {
                    return true;
                }
                return flagStack.canStackWith(item);
            }
            int fuelSlot = 1;
            if (Objects.equals(inventoryName, "container.trommel.name")) {
                fuelSlot = 4;
                for (inputSlot = 0; inputSlot < 3; ++inputSlot) {
                    int maxStackSize;
                    ItemStack s = inventory.getItem(inputSlot);
                    int n = maxStackSize = inventory.getMaxStackSize() != 64 ? inventory.getMaxStackSize() : s.getMaxStackSize();
                    if (s == null || s.canStackWith(item) && s.stackSize < maxStackSize) break;
                }
            }
            if ((furnaceStack = inventory.getItem(targetSlot = dir == Direction.UP ? fuelSlot : inputSlot)) == null) {
                return true;
            }
            return furnaceStack.canStackWith(item) && furnaceStack.stackSize < Math.min(8, item.getMaxStackSize());
        }
        return false;
    }

    public static boolean insertOnInventory(Container inventory, ItemStack stack, Direction direction) {
        boolean result = false;
        try {
            result = Util.insertOnInventoryNoCatch(inventory, stack, direction);
        }
        catch (Exception e) {
            PotatoTech.LOGGER.error(e.getMessage());
        }
        return result;
    }

    public static PipeStack peekItemFromInventory(World world, int x, int y, int z, Direction dir, int stackTimer) {
        PipeStack result = null;
        try {
            result = Util.peekItemFromInventoryNoCatch(world, x, y, z, dir, stackTimer);
        }
        catch (Exception e) {
            PotatoTech.LOGGER.error(e.getMessage());
        }
        return result;
    }

    public static PipeStack peekItemFromInventoryNoCatch(World world, int x, int y, int z, Direction dir, int stackTimer) {
        PipeStack returnStack = null;
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof Container) {
            ItemStack stack;
            Container inventory = (Container)te;
            String inventoryName = inventory.getNameTranslationKey();
            if (Objects.equals(inventoryName, "container.chest.name")) {
                inventory = BlockLogicChest.getInventory((World)world, (int)x, (int)y, (int)z);
            }
            if (Objects.equals(inventoryName, "container.chest.name") || Objects.equals(inventoryName, "container.dispenser.name") || inventoryName.startsWith("container.ironchest") || Objects.equals(inventoryName, "container.filter.name")) {
                int inventorySize = inventory.getContainerSize();
                ItemStack stack2 = null;
                int j = 0;
                if (!inventoryName.equals("container.filter.name")) {
                    while (stack2 == null && j < inventorySize) {
                        stack2 = inventory.getItem(j++);
                    }
                    if (stack2 != null && stack2.stackSize <= 1) {
                        returnStack = null;
                    }
                } else {
                    while (stack2 == null && j < inventorySize) {
                        if ((stack2 = inventory.getItem(j++)) == null || stack2.stackSize++ > 1) continue;
                        returnStack = null;
                    }
                }
                if (stack2 != null && j > 0) {
                    returnStack = new PipeStack(stack2.copy(), dir, stackTimer);
                    return returnStack;
                }
            } else if (inventoryName.equals("container.trommel.name")) {
                int inventorySize = 4;
                ItemStack stack3 = null;
                int j = 0;
                while (stack3 == null && j < inventorySize) {
                    stack3 = inventory.getItem(j++);
                }
                if (stack3 != null && j > 0) {
                    returnStack = new PipeStack(stack3, dir, stackTimer);
                    return returnStack;
                }
            } else if (inventoryName.equals("container.crafter.name")) {
                TileEntityCrafter ac = (TileEntityCrafter)te;
                ItemStack stack4 = ac.craftResult.getItem(0).copy();
                if (stack4 != null) {
                    returnStack = new PipeStack(stack4, dir, stackTimer);
                } else {
                    ItemStack extra = ac.extraOutputs.getItem(0).copy();
                    if (extra != null) {
                        returnStack = new PipeStack(extra, dir, stackTimer);
                    }
                }
            } else if (te instanceof TileEntityFurnace) {
                ItemStack stack5 = inventory.getItem(2);
                if (stack5 != null) {
                    returnStack = new PipeStack(Util.removeItemFromStack(stack5), dir, stackTimer);
                    if (stack5.stackSize <= 0) {
                        stack5 = null;
                    }
                    inventory.setItem(2, stack5);
                }
            } else if (inventory.getContainerSize() > 0 && (stack = inventory.getItem(0)) != null) {
                stack = stack.copy();
                returnStack = new PipeStack(stack, dir, stackTimer);
            }
        } else if (te instanceof TileEntityChute && dir == Direction.UP) {
            TileEntityChute.ChuteEntry firstKey = null;
            Iterator<Map.Entry<TileEntityChute.ChuteEntry, Integer>> inventoryName = ((TileEntityChute)te).contents.entrySet().iterator();
            if (inventoryName.hasNext()) {
                Map.Entry<TileEntityChute.ChuteEntry, Integer> entry = inventoryName.next();
                firstKey = entry.getKey();
            }
            if (firstKey == null) {
                return null;
            }
            ItemStack stack = new ItemStack(firstKey.getItem(), 1, firstKey.metadata);
            returnStack = new PipeStack(stack, dir, stackTimer);
        }
        return returnStack;
    }
}

