/*
 * Decompiled with CFR 0.152.
 */
package goldenage.potatotech.blocks.entities;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.ListTag;
import com.mojang.nbt.tags.Tag;
import goldenage.potatotech.blocks.entities.FilterPaintContainer;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.player.inventory.container.Container;

public class TileEntityFilter
extends TileEntity
implements Container {
    private ItemStack[] filterContents;
    public FilterPaintContainer paintInventory = new FilterPaintContainer();

    public TileEntityFilter(int size) {
        this.filterContents = new ItemStack[size];
    }

    public TileEntityFilter() {
        this(9);
    }

    public int getContainerSize() {
        return this.filterContents.length;
    }

    public ItemStack getItem(int i) {
        return this.filterContents[i];
    }

    public short getColorInSlot(int i) {
        ItemStack stack = this.paintInventory.getItem(i);
        if (stack == null) {
            return 0;
        }
        if (stack.itemID == Items.DYE.id) {
            return (short)(stack.getMetadata() + 1);
        }
        if (stack.getItem().getClass().getName().equals("goocraft4evr.nonamedyes.item.ItemModDye")) {
            return (short)(stack.getMetadata() + 17);
        }
        return 0;
    }

    public ItemStack removeItem(int i, int j) {
        if (this.filterContents[i] != null) {
            if (this.filterContents[i].stackSize <= j) {
                ItemStack itemstack = this.filterContents[i];
                this.filterContents[i] = null;
                this.setChanged();
                return itemstack;
            }
            ItemStack itemstack1 = this.filterContents[i].splitStack(j);
            if (this.filterContents[i].stackSize <= 0) {
                this.filterContents[i] = null;
            }
            this.setChanged();
            return itemstack1;
        }
        return null;
    }

    public boolean canInsertItem(ItemStack itemStack) {
        for (int i = 0; i < 9; ++i) {
            if (this.filterContents[i] == null || !this.filterContents[i].canStackWith(itemStack)) continue;
            return true;
        }
        return false;
    }

    public void setItem(int i, ItemStack itemstack) {
        this.filterContents[i] = itemstack;
        if (itemstack != null && itemstack.stackSize > this.getMaxStackSize()) {
            itemstack.stackSize = this.getMaxStackSize();
        }
        this.setChanged();
    }

    public String getNameTranslationKey() {
        return "container.filter.name";
    }

    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        ListTag nbttaglist = nbttagcompound.getList("Items");
        this.filterContents = new ItemStack[this.getContainerSize()];
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            CompoundTag nbttagcompound1 = (CompoundTag)nbttaglist.tagAt(i);
            int j = nbttagcompound1.getByte("Slot") & 0xFF;
            if (j >= this.filterContents.length) continue;
            this.filterContents[j] = ItemStack.readItemStackFromNbt((CompoundTag)nbttagcompound1);
        }
        ListTag nbttaglist2 = nbttagcompound.getList("ItemsC");
        for (int i = 0; i < nbttaglist2.tagCount(); ++i) {
            CompoundTag nbttagcompound1 = (CompoundTag)nbttaglist2.tagAt(i);
            int j = nbttagcompound1.getByte("Slot") & 0xFF;
            if (j >= this.paintInventory.contents.length) continue;
            this.paintInventory.contents[j] = ItemStack.readItemStackFromNbt((CompoundTag)nbttagcompound1);
        }
    }

    public void writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        ListTag nbttaglist = new ListTag();
        for (int i = 0; i < this.filterContents.length; ++i) {
            if (this.filterContents[i] == null) continue;
            CompoundTag nbttagcompound1 = new CompoundTag();
            nbttagcompound1.putByte("Slot", (byte)i);
            this.filterContents[i].writeToNBT(nbttagcompound1);
            nbttaglist.addTag((Tag)nbttagcompound1);
        }
        nbttagcompound.put("Items", (Tag)nbttaglist);
        ListTag nbttaglist2 = new ListTag();
        for (int i = 0; i < this.paintInventory.contents.length; ++i) {
            if (this.paintInventory.contents[i] == null) continue;
            CompoundTag nbttagcompound1 = new CompoundTag();
            nbttagcompound1.putByte("Slot", (byte)i);
            this.paintInventory.contents[i].writeToNBT(nbttagcompound1);
            nbttaglist2.addTag((Tag)nbttagcompound1);
        }
        nbttagcompound.put("ItemsC", (Tag)nbttaglist2);
    }

    public int getMaxStackSize() {
        return 64;
    }

    public boolean stillValid(Player player) {
        if (this.worldObj.getTileEntity(this.x, this.y, this.z) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5) <= 64.0;
    }

    public void sortContainer() {
    }
}

