/*
 * Decompiled with CFR 0.152.
 */
package goldenage.potatotech.networks.client;

import goldenage.potatotech.mixins.PlayerServerAccessor;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Screen;
import net.minecraft.core.crafting.ContainerListener;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.player.inventory.menu.MenuAbstract;
import net.minecraft.server.entity.player.PlayerServer;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.helper.network.UniversalPacket;

abstract class OpenGuiContainerMessage<A>
implements NetworkMessage {
    protected final A container;
    private int windowId = 0;

    public OpenGuiContainerMessage(A container) {
        this.container = container;
    }

    public void sendToPlayer(Player player) {
        if (EnvironmentHelper.isServerEnvironment()) {
            this.serverSetWindow(player);
        }
        NetworkHandler.sendToPlayer((Player)player, (NetworkMessage)this);
        if (EnvironmentHelper.isServerEnvironment()) {
            this.serverSetWindow2(player);
        }
    }

    @Environment(value=EnvType.SERVER)
    private void serverSetWindow(Player player) {
        if (player instanceof PlayerServer) {
            ((PlayerServerAccessor)player).invokeGetNextWindowId();
            this.windowId = ((PlayerServerAccessor)player).getCurrentWindowId();
        }
    }

    protected abstract MenuAbstract getMenuInstance(ContainerInventory var1, A var2);

    @Environment(value=EnvType.SERVER)
    protected void serverSetWindow2(Player player) {
        if (player instanceof PlayerServer) {
            player.craftingInventory.onCraftGuiClosed(player);
            player.craftingInventory = this.getMenuInstance(player.inventory, this.container);
            player.craftingInventory.containerId = this.windowId;
            player.craftingInventory.addSlotListener((ContainerListener)((PlayerServer)player));
        }
    }

    public void encodeToUniversalPacket(@Nonnull UniversalPacket buf) {
        buf.writeInt(this.windowId);
    }

    public void decodeFromUniversalPacket(@Nonnull UniversalPacket buf) {
        this.windowId = buf.readInt();
    }

    @Environment(value=EnvType.CLIENT)
    protected abstract Screen getScreenInstance(ContainerInventory var1, A var2);

    public void handle(NetworkMessage.NetworkContext context) {
        if (EnvironmentHelper.isSinglePlayer()) {
            this.doSinglePlayer();
            return;
        }
        if (EnvironmentHelper.isClientWorld()) {
            this.doClient();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void doClient() {
        Minecraft.getMinecraft().displayScreen(this.getScreenInstance(Minecraft.getMinecraft().thePlayer.inventory, this.container));
        Minecraft.getMinecraft().thePlayer.craftingInventory.containerId = this.windowId;
    }

    @Environment(value=EnvType.CLIENT)
    private void doSinglePlayer() {
        Minecraft.getMinecraft().displayScreen(this.getScreenInstance(Minecraft.getMinecraft().thePlayer.inventory, this.container));
    }
}

