/*
 * Decompiled with CFR 0.152.
 */
package goldenage.potatotech;

import goldenage.potatotech.PTBlocks;
import goldenage.potatotech.PipeStack;
import goldenage.potatotech.blocks.entities.TileEntityPipe;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.ItemRenderer;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.phys.AABB;
import org.lwjgl.opengl.GL11;

public class TileEntityRendererPipe
extends TileEntityRenderer<TileEntityPipe> {
    private static final ItemRenderer itemEntityRenderer = new ItemRenderer(Minecraft.getMinecraft());
    private EntityItem itemEntity = null;
    private long timer = 0L;
    int[] colors = new int[]{-1, -16185079, -65536, -16733696, -8376288, -16776961, -6291201, -16727809, -4144960, -11513776, -24416, -14614752, -4128992, -7302913, -52993, -28672, -1, -3526582, -9560549, -5981784, -7303892, -3636160, -15498, -10362686, -1383793, -11583786, -3081172, -4102092, -13686911, -9162870, -12744081};

    public void doRender(Tessellator tessellator, TileEntityPipe tileEntity, double x, double y, double z, float g) {
        ++this.timer;
        if (this.timer > 8000L) {
            this.timer = 0L;
        }
        Minecraft mc = Minecraft.getMinecraft();
        float rotAngle = 360.0f * ((float)this.timer / 8000.0f);
        if (this.itemEntity == null) {
            this.itemEntity = new EntityItem(tileEntity.worldObj, 0.0, 0.0, 0.0, new ItemStack(PTBlocks.testAreaMaker));
            this.itemEntity.entityBrightness = 1.0f;
            this.itemEntity.age = 1;
        }
        List<float[]> blockPos = tileEntity.getStacksInPipePosition();
        List<ItemStack> stacks = tileEntity.getStacksInPipe();
        PipeStack[] pipeStacks = tileEntity.stacks;
        for (int i = 0; i < blockPos.size(); ++i) {
            BlockModel blockModel;
            double yOffset;
            ItemStack stack = stacks.get(i);
            PipeStack pipeStack = pipeStacks[i];
            if (stack == null) continue;
            float[] pos = blockPos.get(i);
            this.itemEntity.item = stack;
            double d = yOffset = stack.itemID < Blocks.blocksList.length ? 0.0 : 0.1;
            if (stack.itemID == Blocks.SAPLING_OAK.id() || stack.itemID == Blocks.SAPLING_PINE.id() || stack.itemID == Blocks.SAPLING_BIRCH.id() || stack.itemID == Blocks.SAPLING_CHERRY.id() || stack.itemID == Blocks.SAPLING_OAK_RETRO.id() || stack.itemID == Blocks.SAPLING_EUCALYPTUS.id() || stack.itemID == Blocks.SAPLING_SHRUB.id() || stack.itemID == Blocks.SAPLING_THORN.id()) {
                yOffset = 0.1;
            }
            float brightness = 1.0f;
            ItemStack itemstack = this.itemEntity.item;
            Item item = itemstack.getItem();
            if (item == null) continue;
            int renderCount = 1;
            if (this.itemEntity.item.stackSize > 1) {
                renderCount = 2;
            }
            if (this.itemEntity.item.stackSize > 5) {
                renderCount = 3;
            }
            if (this.itemEntity.item.stackSize > 20) {
                renderCount = 4;
            }
            GL11.glEnable((int)32826);
            GL11.glEnable((int)3042);
            BlockModel.setRenderBlocks((RenderBlocks)TileEntityRendererPipe.itemEntityRenderer.renderBlocksInstance);
            GL11.glPushMatrix();
            if (itemstack.itemID < Blocks.blocksList.length && Blocks.blocksList[itemstack.itemID] != null) {
                TextureRegistry.blockAtlas.bind();
                float itemSize = 0.25f;
                GL11.glTranslatef((float)((float)(x + (double)pos[0])), (float)((float)(y + (double)pos[1] - yOffset)), (float)((float)(z + (double)pos[2])));
                GL11.glScalef((float)itemSize, (float)itemSize, (float)itemSize);
                for (int j = 0; j < renderCount; ++j) {
                    blockModel = (BlockModel)BlockModelDispatcher.getInstance().getDispatch((Object)Blocks.blocksList[itemstack.itemID]);
                    blockModel.renderBlockOnInventory(tessellator, itemstack.getMetadata(), brightness, null);
                }
            } else {
                if (((Boolean)mc.gameSettings.items3D.value).booleanValue()) {
                    GL11.glTranslatef((float)((float)(x + (double)pos[0])), (float)((float)(y + (double)pos[1] - yOffset - 0.1)), (float)((float)(z + (double)pos[2])));
                    GL11.glScalef((float)0.75f, (float)0.75f, (float)0.75f);
                    GL11.glRotatef((float)rotAngle, (float)0.0f, (float)1.0f, (float)0.0f);
                } else {
                    GL11.glTranslatef((float)((float)(x + (double)pos[0])), (float)((float)(y + (double)pos[1] - yOffset)), (float)((float)(z + (double)pos[2])));
                }
                ((ItemModel)ItemModelDispatcher.getInstance().getDispatch((Object)item)).renderAsItemEntity(Tessellator.instance, (Entity)this.itemEntity, new Random(), itemstack, renderCount, 0.0f, brightness, 1.0f);
            }
            GL11.glPopMatrix();
            if (pipeStack.color > 0) {
                GL11.glEnable((int)3042);
                GL11.glPushMatrix();
                int color = this.colors[pipeStack.color];
                TextureRegistry.blockAtlas.bind();
                float itemSize = 0.35f;
                GL11.glTranslatef((float)((float)(x + (double)pos[0])), (float)((float)(y + (double)pos[1])), (float)((float)(z + (double)pos[2])));
                GL11.glScalef((float)itemSize, (float)itemSize, (float)itemSize);
                blockModel = (BlockModelStandard)BlockModelDispatcher.getInstance().getDispatch(PTBlocks.pipeStack);
                blockModel.renderBlockOnInventory(tessellator, color, brightness, null);
                if (BlockModelStandard.renderBlocks.useInventoryTint) {
                    float cr = (float)(color >> 16 & 0xFF) / 255.0f;
                    float cg = (float)(color >> 8 & 0xFF) / 255.0f;
                    float cb = (float)(color & 0xFF) / 255.0f;
                    GL11.glColor4f((float)cr, (float)cg, (float)cb, (float)1.0f);
                } else {
                    GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
                }
                float yOffset2 = 0.5f;
                AABB bounds = blockModel.getBlockBoundsForItemRender();
                GL11.glTranslatef((float)-0.5f, (float)(0.0f - yOffset2), (float)-0.5f);
                blockModel.renderBlockWithBounds(tessellator, bounds, 0, brightness, 1.0f, null);
                GL11.glTranslatef((float)0.5f, (float)yOffset2, (float)0.5f);
                GL11.glPopMatrix();
                GL11.glDisable((int)3042);
            }
            GL11.glDisable((int)3042);
            GL11.glDisable((int)32826);
        }
    }
}

