/*
 * Decompiled with CFR 0.152.
 */
package goldenage.potatotech.blocks;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public class BlockLogicTestAreaMaker
extends BlockLogic {
    public BlockLogicTestAreaMaker(Block<?> block, Material material) {
        super(block, material);
    }

    public void onBlockPlacedByMob(World world, int x, int y, int z, @NotNull Side side, Mob mob, double xPlaced, double yPlaced) {
        int xi;
        int zi;
        int yi;
        super.onBlockPlacedByMob(world, x, y, z, side, mob, xPlaced, yPlaced);
        int startX = world.getChunkFromBlockCoords((int)x, (int)z).xPosition * 16;
        int startZ = world.getChunkFromBlockCoords((int)x, (int)z).zPosition * 16;
        int endX = startX + 15;
        int endZ = startZ + 15;
        for (yi = y + 1; yi < 256; ++yi) {
            for (zi = startZ; zi <= endZ; ++zi) {
                for (xi = startX; xi <= endX; ++xi) {
                    world.setBlockWithNotify(xi, yi, zi, 0);
                }
            }
        }
        for (yi = 0; yi <= y; ++yi) {
            for (zi = startZ; zi <= endZ; ++zi) {
                for (xi = startX; xi <= endX; ++xi) {
                    int id;
                    int n = id = (zi & 1) == (xi & 1) ? Blocks.BASALT_POLISHED.id() : Blocks.STONE_POLISHED.id();
                    if (xi == 0 || yi == 0 || xi == endX || zi == endZ) {
                        id = (zi & 1) == (xi & 1) ? Blocks.GRANITE_POLISHED.id() : Blocks.LIMESTONE_POLISHED.id();
                    }
                    world.setBlockWithNotify(xi, yi, zi, id);
                }
            }
        }
    }
}

