/*
 * Decompiled with CFR 0.152.
 */
package goldenage.potatotech.blocks.entities;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.ListTag;
import com.mojang.nbt.tags.Tag;
import goldenage.potatotech.screens.MenuCrafter;
import java.util.List;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCrafting;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PacketTileEntityData;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.player.inventory.container.ContainerCrafting;
import net.minecraft.core.player.inventory.container.ContainerResult;
import net.minecraft.core.player.inventory.container.ContainerSimple;
import net.minecraft.core.player.inventory.menu.MenuAbstract;
import org.jetbrains.annotations.Nullable;

public class TileEntityCrafter
extends TileEntity
implements Container {
    public ContainerCrafting craftMatrix;
    public Container pattern;
    public Container extraOutputs;
    public Container craftResult = new ContainerResult();
    public MenuCrafter dummyContainer;
    private final List<RecipeEntryCrafting<?, ?>> craftingRecipeEntries = Registries.RECIPES.getAllCraftingRecipes();
    int timer = 0;

    public TileEntityCrafter() {
        this.dummyContainer = new MenuCrafter(null, this);
        this.craftMatrix = new ContainerCrafting((MenuAbstract)this.dummyContainer, 3, 3);
        this.pattern = new ContainerSimple("pattern", 9);
        this.extraOutputs = new ContainerSimple("extra outputs", 1);
    }

    public int getContainerSize() {
        return 10;
    }

    @Nullable
    public ItemStack getItem(int i) {
        if (i == 0) {
            return this.craftResult.getItem(0);
        }
        if (this.craftMatrix != null) {
            return this.craftMatrix.getItem(i - 1);
        }
        return null;
    }

    @Nullable
    public ItemStack removeItem(int i, int j) {
        if (i == 0) {
            return this.craftResult.removeItem(i, j);
        }
        if (this.craftMatrix != null) {
            return this.craftMatrix.removeItem(i, j);
        }
        return null;
    }

    public void setItem(int i, @Nullable ItemStack itemStack) {
        if (i == 0) {
            this.craftResult.setItem(0, itemStack);
        } else if (this.craftMatrix != null) {
            this.craftMatrix.setItem(i - 1, itemStack);
        }
    }

    public String getNameTranslationKey() {
        return "container.crafter.name";
    }

    public void readFromNBT(CompoundTag nbttagcompound) {
        int j;
        CompoundTag nbttagcompound1;
        int i;
        super.readFromNBT(nbttagcompound);
        ListTag nbttaglist = nbttagcompound.getList("CraftGrid");
        for (i = 0; i < nbttaglist.tagCount(); ++i) {
            nbttagcompound1 = (CompoundTag)nbttaglist.tagAt(i);
            j = nbttagcompound1.getByte("Slot") & 0xFF;
            if (j >= this.craftMatrix.getContainerSize()) continue;
            this.craftMatrix.setItem(j, ItemStack.readItemStackFromNbt((CompoundTag)nbttagcompound1));
        }
        nbttaglist = nbttagcompound.getList("Pattern");
        for (i = 0; i < nbttaglist.tagCount(); ++i) {
            nbttagcompound1 = (CompoundTag)nbttaglist.tagAt(i);
            j = nbttagcompound1.getByte("Slot") & 0xFF;
            if (j >= this.pattern.getContainerSize()) continue;
            this.pattern.setItem(j, ItemStack.readItemStackFromNbt((CompoundTag)nbttagcompound1));
        }
        nbttaglist = nbttagcompound.getList("CraftResult");
        for (i = 0; i < nbttaglist.tagCount(); ++i) {
            nbttagcompound1 = (CompoundTag)nbttaglist.tagAt(i);
            j = nbttagcompound1.getByte("Slot") & 0xFF;
            if (j >= this.craftResult.getContainerSize()) continue;
            this.craftResult.setItem(j, ItemStack.readItemStackFromNbt((CompoundTag)nbttagcompound1));
        }
    }

    public void writeToNBT(CompoundTag nbttagcompound) {
        CompoundTag nbttagcompound1;
        ItemStack stack;
        int i;
        super.writeToNBT(nbttagcompound);
        ListTag nbttaglist = new ListTag();
        for (i = 0; i < this.craftMatrix.getContainerSize(); ++i) {
            stack = this.craftMatrix.getItem(i);
            if (stack == null) continue;
            nbttagcompound1 = new CompoundTag();
            nbttagcompound1.putByte("Slot", (byte)i);
            stack.writeToNBT(nbttagcompound1);
            nbttaglist.addTag((Tag)nbttagcompound1);
        }
        nbttagcompound.put("CraftGrid", (Tag)nbttaglist);
        nbttaglist = new ListTag();
        for (i = 0; i < this.pattern.getContainerSize(); ++i) {
            stack = this.pattern.getItem(i);
            if (stack == null) continue;
            nbttagcompound1 = new CompoundTag();
            nbttagcompound1.putByte("Slot", (byte)i);
            stack.writeToNBT(nbttagcompound1);
            nbttaglist.addTag((Tag)nbttagcompound1);
        }
        nbttagcompound.put("Pattern", (Tag)nbttaglist);
        nbttaglist = new ListTag();
        for (i = 0; i < this.craftResult.getContainerSize(); ++i) {
            stack = this.craftResult.getItem(i);
            if (stack == null) continue;
            nbttagcompound1 = new CompoundTag();
            nbttagcompound1.putByte("Slot", (byte)i);
            stack.writeToNBT(nbttagcompound1);
            nbttaglist.addTag((Tag)nbttagcompound1);
        }
        nbttagcompound.put("CraftResult", (Tag)nbttaglist);
    }

    public int getMaxStackSize() {
        return 64;
    }

    public boolean stillValid(Player player) {
        if (this.worldObj.getTileEntity(this.x, this.y, this.z) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5) <= 64.0;
    }

    public void sortContainer() {
    }

    public Packet getDescriptionPacket() {
        return new PacketTileEntityData((TileEntity)this);
    }

    public ItemStack removeOneResult() {
        ItemStack stack = this.craftResult.getItem(0);
        if (stack != null) {
            --stack.stackSize;
            if (stack.stackSize <= 0) {
                this.craftResult.setItem(0, null);
            } else {
                this.craftResult.setItem(0, stack.copy());
            }
            stack.stackSize = 1;
            this.setChanged();
            return stack;
        }
        return null;
    }

    public boolean insertItem(ItemStack stackToInsert) {
        boolean inserted = false;
        int slotToInsert = -1;
        int lastSlotCount = 99;
        if (this.craftMatrix != null) {
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.craftMatrix.getItem(i);
                ItemStack stackPattern = this.pattern.getItem(i);
                if (stackPattern == null) continue;
                if (stack == null) {
                    if (stackPattern.itemID != stackToInsert.itemID || stackPattern.getMetadata() != stackToInsert.getMetadata()) continue;
                    slotToInsert = i;
                    lastSlotCount = 0;
                    continue;
                }
                if (stack.itemID != stackToInsert.itemID || stack.getMetadata() != stackToInsert.getMetadata() || stack.stackSize >= stack.getMaxStackSize() || stack.stackSize >= lastSlotCount) continue;
                slotToInsert = i;
                lastSlotCount = stack.stackSize;
            }
            if (slotToInsert >= 0) {
                if (lastSlotCount == 0) {
                    this.craftMatrix.setItem(slotToInsert, stackToInsert.copy());
                    this.setChanged();
                    inserted = true;
                } else {
                    ItemStack stack = this.craftMatrix.getItem(slotToInsert);
                    if (stack != null) {
                        ++stack.stackSize;
                        this.craftMatrix.setItem(slotToInsert, stack);
                        this.setChanged();
                        inserted = true;
                    }
                }
            }
        }
        return inserted;
    }

    public void setChanged() {
        super.setChanged();
    }

    /*
     * WARNING - void declaration
     */
    public void tick() {
        super.tick();
        if (this.craftMatrix != null && !this.worldObj.isClientSide) {
            boolean canCraft = true;
            for (int i = 0; i < 9; ++i) {
                ItemStack i0 = this.craftMatrix.getItem(i);
                ItemStack itemStack = this.pattern.getItem(i);
                if (i0 != null && itemStack == null || i0 == null && itemStack != null) {
                    canCraft = false;
                    break;
                }
                if (i0 == null || itemStack == null || i0.itemID == itemStack.itemID) continue;
                canCraft = false;
                break;
            }
            if (this.extraOutputs.getItem(0) != null) {
                canCraft = false;
            }
            RecipeEntryCrafting recipe = null;
            for (RecipeEntryCrafting recipeEntryCrafting : this.craftingRecipeEntries) {
                if (!recipeEntryCrafting.matches(this.craftMatrix)) continue;
                recipe = recipeEntryCrafting;
                break;
            }
            ItemStack craftingResult = null;
            if (recipe != null) {
                craftingResult = recipe.getCraftingResult(this.craftMatrix);
            }
            if (this.craftResult.getItem(0) == null && craftingResult != null && canCraft) {
                if (this.timer > 10) {
                    void var4_9;
                    recipe.onCraftResult(this.craftMatrix);
                    this.craftResult.setItem(0, craftingResult);
                    this.setChanged();
                    boolean bl = false;
                    for (int i = 0; i < 9; ++i) {
                        ItemStack s = this.craftMatrix.getItem(i);
                        if (s == null || s.itemID != Items.BUCKET.id) continue;
                        this.craftMatrix.setItem(i, null);
                        ++var4_9;
                    }
                    if (var4_9 > 0) {
                        this.extraOutputs.setItem(0, new ItemStack(Items.BUCKET, (int)var4_9));
                    }
                    this.timer = 0;
                }
                ++this.timer;
            }
        }
    }
}

