/*
 * Decompiled with CFR 0.152.
 */
package goldenage.potatotech.blocks.entities;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.ListTag;
import com.mojang.nbt.tags.Tag;
import goldenage.potatotech.PipeStack;
import goldenage.potatotech.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.block.BlockLogicChest;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PacketTileEntityData;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.World;

public class TileEntityPipe
extends TileEntity {
    public PipeStack[] stacks = new PipeStack[7];
    public short[] modeBySide = new short[6];
    public short[] colorBySide = new short[6];
    public int maxInputTimer;
    public int inputTimer = this.maxInputTimer = 12;
    public int maxPipeStackTimer = 6;

    public void dropItems() {
        for (int i = 0; i < this.stacks.length; ++i) {
            PipeStack stack = this.stacks[i];
            if (stack == null) continue;
            this.worldObj.dropItem(this.x, this.y, this.z, stack.stack);
            this.stacks[i] = null;
        }
    }

    public List<ItemStack> getStacksInPipe() {
        ArrayList<ItemStack> l = new ArrayList<ItemStack>(this.stacks.length);
        for (PipeStack stack : this.stacks) {
            l.add(stack != null ? stack.stack : null);
        }
        return l;
    }

    public List<float[]> getStacksInPipePosition() {
        ArrayList<float[]> l = new ArrayList<float[]>(this.stacks.length);
        int i = 0;
        for (PipeStack stack : this.stacks) {
            float[] pos = new float[3];
            if (stack != null) {
                float t = (float)stack.timer / (float)this.maxPipeStackTimer;
                if ((double)t > 1.0) {
                    t = 1.0f;
                }
                if (i > 0) {
                    Direction dir = Direction.getDirectionById((int)(i - 1));
                    float x1 = (float)dir.getOffsetX() * 0.325f;
                    float y1 = (float)dir.getOffsetY() * 0.325f;
                    float z1 = (float)dir.getOffsetZ() * 0.325f;
                    float x0 = x1 + (float)stack.direction.getOffsetX() * 0.325f;
                    float y0 = y1 + (float)stack.direction.getOffsetY() * 0.325f;
                    float z0 = z1 + (float)stack.direction.getOffsetZ() * 0.325f;
                    float xof = x0 * (1.0f - t) + x1 * t;
                    float yof = y0 * (1.0f - t) + y1 * t;
                    float zof = z0 * (1.0f - t) + z1 * t;
                    pos[0] = 0.5f + xof;
                    pos[1] = 0.5f + yof;
                    pos[2] = 0.5f + zof;
                } else {
                    float x0 = (float)stack.direction.getOffsetX() * 0.325f;
                    float y0 = (float)stack.direction.getOffsetY() * 0.325f;
                    float z0 = (float)stack.direction.getOffsetZ() * 0.325f;
                    float xof = x0 * (1.0f - t);
                    float yof = y0 * (1.0f - t);
                    float zof = z0 * (1.0f - t);
                    pos[0] = 0.5f + xof;
                    pos[1] = 0.5f + yof;
                    pos[2] = 0.5f + zof;
                }
            } else {
                pos[0] = 0.5f;
                pos[1] = 0.5f;
                pos[2] = 0.5f;
            }
            l.add(pos);
            ++i;
        }
        return l;
    }

    public void readFromNBT(CompoundTag nbttagcompound) {
        int i;
        super.readFromNBT(nbttagcompound);
        ListTag nbttaglist = nbttagcompound.getList("Items");
        this.stacks = new PipeStack[7];
        for (i = 0; i < nbttaglist.tagCount(); ++i) {
            CompoundTag nbttagcompound1 = (CompoundTag)nbttaglist.tagAt(i);
            this.stacks[i] = PipeStack.readPipeStackFromNbt(nbttagcompound1);
            if (this.stacks[i].stack != null) continue;
            this.stacks[i] = null;
        }
        for (i = 0; i < this.modeBySide.length; ++i) {
            this.modeBySide[i] = nbttagcompound.getShort("mode" + i);
        }
        for (i = 0; i < this.colorBySide.length; ++i) {
            this.colorBySide[i] = nbttagcompound.getShort("color" + i);
        }
    }

    public void writeToNBT(CompoundTag nbttagcompound) {
        int i;
        super.writeToNBT(nbttagcompound);
        ListTag nbttaglist = new ListTag();
        for (PipeStack stack : this.stacks) {
            if (stack == null) {
                PipeStack s = new PipeStack();
                s.direction = Direction.getDirectionById((int)0);
                CompoundTag nbttagcompound1 = new CompoundTag();
                s.writeToNBT(nbttagcompound1);
                nbttaglist.addTag((Tag)nbttagcompound1);
                continue;
            }
            CompoundTag nbttagcompound1 = new CompoundTag();
            stack.writeToNBT(nbttagcompound1);
            nbttaglist.addTag((Tag)nbttagcompound1);
        }
        nbttagcompound.put("Items", (Tag)nbttaglist);
        for (i = 0; i < this.modeBySide.length; ++i) {
            nbttagcompound.putShort("mode" + i, this.modeBySide[i]);
        }
        for (i = 0; i < this.colorBySide.length; ++i) {
            nbttagcompound.putShort("color" + i, this.colorBySide[i]);
        }
    }

    public void inputItems() {
        for (Direction dir : Direction.directions) {
            PipeStack stack;
            if (this.modeBySide[dir.getId()] != 2 || (stack = this.stacks[dir.getId() + 1]) != null) continue;
            stack = Util.getItemFromInventory(this.worldObj, this.x + dir.getOffsetX(), this.y + dir.getOffsetY(), this.z + dir.getOffsetZ(), dir, 0);
            if (stack != null) {
                stack.timer = 0;
                if (stack.color == 0) {
                    stack.color = this.colorBySide[dir.getId()];
                }
            }
            this.stacks[dir.getId() + 1] = stack;
        }
    }

    public void outputItems() {
        for (Direction dir : Direction.directions) {
            boolean inserted;
            TileEntity te;
            PipeStack stack = this.stacks[dir.getId() + 1];
            if (stack == null || stack.direction != dir.getOpposite() || stack.timer < this.maxPipeStackTimer || !((te = this.worldObj.getTileEntity(this.x + dir.getOffsetX(), this.y + dir.getOffsetY(), this.z + dir.getOffsetZ())) instanceof Container) || te instanceof TileEntityPipe || this.modeBySide[dir.getId()] > 1) continue;
            Container inventory = (Container)te;
            if (Objects.equals(inventory.getNameTranslationKey(), "container.chest.name")) {
                inventory = BlockLogicChest.getInventory((World)this.worldObj, (int)(this.x + dir.getOffsetX()), (int)(this.y + dir.getOffsetY()), (int)(this.z + dir.getOffsetZ()));
            }
            if (!(inserted = Util.insertOnInventory(inventory, stack.stack, dir))) continue;
            this.stacks[dir.getId() + 1] = null;
        }
    }

    public void moveItems() {
        boolean isPowered;
        int i;
        for (Direction dir : Direction.directions) {
            TileEntity te;
            PipeStack stack = this.stacks[dir.getId() + 1];
            if (stack == null || stack.direction != dir.getOpposite() || stack.timer < this.maxPipeStackTimer || !((te = this.worldObj.getTileEntity(this.x + dir.getOffsetX(), this.y + dir.getOffsetY(), this.z + dir.getOffsetZ())) instanceof TileEntityPipe)) continue;
            TileEntityPipe p = (TileEntityPipe)te;
            if (p.stacks[dir.getOpposite().getId() + 1] != null) continue;
            stack.timer = 0;
            p.stacks[dir.getOpposite().getId() + 1] = stack;
            this.stacks[dir.getId() + 1] = null;
        }
        if (this.stacks[0] != null && this.stacks[0].timer >= this.maxPipeStackTimer) {
            ArrayList<Direction> freeDir = new ArrayList<Direction>();
            for (i = 0; i < 6; ++i) {
                Direction dir;
                PipeStack stack2 = this.stacks[i + 1];
                dir = Direction.getDirectionById((int)i);
                TileEntity te = this.worldObj.getTileEntity(this.x + dir.getOffsetX(), this.y + dir.getOffsetY(), this.z + dir.getOffsetZ());
                if (stack2 != null || !(te instanceof Container) && !(te instanceof TileEntityPipe) || i == this.stacks[0].direction.getId() || this.modeBySide[i] >= 2) continue;
                if (te instanceof TileEntityPipe) {
                    boolean cannotMove;
                    TileEntityPipe pipe = (TileEntityPipe)te;
                    short pipeMode = pipe.modeBySide[dir.getOpposite().getId()];
                    boolean bl = cannotMove = pipeMode == 3 || pipeMode == 1;
                    if (cannotMove) {
                        continue;
                    }
                } else {
                    boolean canInsert = this.modeBySide[i] == 1;
                    if (canInsert &= !Util.canInsertOnInventory(this.worldObj, this.x + dir.getOffsetX(), this.y + dir.getOffsetY(), this.z + dir.getOffsetZ(), dir.getOpposite(), this.stacks[0].stack)) continue;
                }
                if (this.colorBySide[i] > 0) {
                    if (this.colorBySide[i] != this.stacks[0].color) continue;
                    freeDir.clear();
                    freeDir.add(Direction.getDirectionById((int)i));
                    break;
                }
                if (this.modeBySide[i] == 1) {
                    freeDir.clear();
                    freeDir.add(Direction.getDirectionById((int)i));
                    break;
                }
                freeDir.add(Direction.getDirectionById((int)i));
            }
            if (!freeDir.isEmpty()) {
                int selected = (int)(Math.random() * (double)freeDir.size());
                Direction dir = (Direction)freeDir.get(selected);
                this.stacks[0].direction = dir.getOpposite();
                this.stacks[0].timer = 0;
                this.stacks[dir.getId() + 1] = this.stacks[0];
                this.stacks[0] = null;
            }
        }
        boolean bl = isPowered = this.worldObj.hasNeighborSignal(this.x, this.y, this.z) || this.worldObj.hasDirectSignal(this.x, this.y, this.z);
        if (!isPowered) {
            for (i = 0; i < 6; ++i) {
                PipeStack stack = this.stacks[i + 1];
                if (stack == null || stack.direction != Direction.getDirectionById((int)i) || stack.timer < this.maxPipeStackTimer || this.stacks[0] != null) continue;
                this.stacks[0] = stack;
                this.stacks[0].timer = 0;
                this.stacks[i + 1] = null;
            }
        }
    }

    public void tick() {
        for (PipeStack pipeStack : this.stacks) {
            if (pipeStack == null) continue;
            ++pipeStack.timer;
        }
        this.outputItems();
        --this.inputTimer;
        if (this.inputTimer < 0) {
            this.inputItems();
            this.inputTimer = this.maxInputTimer;
        }
        this.moveItems();
    }

    public Packet getDescriptionPacket() {
        return new PacketTileEntityData((TileEntity)this);
    }
}

