/*
 * Decompiled with CFR 0.152.
 */
package dev.gamelord2011.ags_reborn;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgsLang {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"ags_reborn.AgsLang");
    private static final String KEY_CATEGORY = "key.categories.ags_reborn";
    private static final String KEY_SWITCH = "key.ags_reborn.switch";
    private static final String KEY_CONTROL_TOGGLE = "key.ags_reborn.control_toggle";
    private static final String KEY_SWITCH_ON = "message.ags_reborn.switch_on";
    private static final String KEY_SWITCH_OFF = "message.ags_reborn.switch_off";
    private static final String KEY_CATEGORY_RUNTIME;
    private static final String KEY_SWITCH_RUNTIME;
    private static final String KEY_CONTROL_TOGGLE_RUNTIME;
    private static final String KEY_SWITCH_ON_RUNTIME;
    private static final String KEY_SWITCH_OFF_RUNTIME;
    private static final String[] EN;
    private static final String[] ES;
    private static final String[] PL;
    private static final String[] PIRATE_SPEAK;
    private static final String[] LOLCAT;
    private static final String[] SHAKESPEAREAN_ENGLISH;
    private static final String[] ANGLISH;
    private static final String[] UPSIDE_DOWN_ENGLISH;
    private static final String[] KLINGON;
    private static final String[] QUENYA;
    private static final Map<String, String[]> LANGUAGE_MAP;

    public static Map<String, String> constructLanguageSet(String langCode) {
        try {
            LOGGER.info("constructLanguageSet called for langCode={}", (Object)langCode);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String[] values = LANGUAGE_MAP.getOrDefault(langCode, EN);
        LinkedHashMap<String, String> translationsMap = new LinkedHashMap<String, String>();
        translationsMap.put(KEY_CATEGORY_RUNTIME, values[0]);
        try {
            translationsMap.put("key.categories." + KEY_CATEGORY_RUNTIME, values[0]);
            translationsMap.put("key.category." + KEY_CATEGORY_RUNTIME, values[0]);
            translationsMap.put("key.category.minecraft." + KEY_CATEGORY_RUNTIME, values[0]);
            translationsMap.put("key.category.ags_reborn." + KEY_CATEGORY_RUNTIME, values[0]);
            translationsMap.put("key.categories.ags_reborn." + KEY_CATEGORY_RUNTIME, values[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        translationsMap.put(KEY_SWITCH_RUNTIME, values[1]);
        translationsMap.put(KEY_CONTROL_TOGGLE_RUNTIME, values[2]);
        translationsMap.put(KEY_SWITCH_ON_RUNTIME, values[3]);
        translationsMap.put(KEY_SWITCH_OFF_RUNTIME, values[4]);
        LOGGER.info("constructLanguageSet produced {} entries for lang {}", (Object)translationsMap.size(), (Object)langCode);
        return translationsMap;
    }

    public static String getCategoryKey() {
        return KEY_CATEGORY;
    }

    public static String getKeySwitch() {
        return KEY_SWITCH;
    }

    public static String getKeyControlToggle() {
        return KEY_CONTROL_TOGGLE;
    }

    public static String getKeySwitchOn() {
        return KEY_SWITCH_ON;
    }

    public static String getKeySwitchOff() {
        return KEY_SWITCH_OFF;
    }

    public static String getRuntimeCategoryKey() {
        return KEY_CATEGORY_RUNTIME;
    }

    public static String getRuntimeKeySwitch() {
        return KEY_SWITCH_RUNTIME;
    }

    public static String getRuntimeKeyControlToggle() {
        return KEY_CONTROL_TOGGLE_RUNTIME;
    }

    public static String getRuntimeKeySwitchOn() {
        return KEY_SWITCH_ON_RUNTIME;
    }

    public static String getRuntimeKeySwitchOff() {
        return KEY_SWITCH_OFF_RUNTIME;
    }

    public static String getStableMessageSwitchOn() {
        return KEY_SWITCH_ON;
    }

    public static String getStableMessageSwitchOff() {
        return KEY_SWITCH_OFF;
    }

    static {
        String prefix = "ags_reborn.dynamic.";
        KEY_CATEGORY_RUNTIME = "ags_reborn.dynamic." + UUID.randomUUID().toString();
        KEY_SWITCH_RUNTIME = "ags_reborn.dynamic." + UUID.randomUUID().toString();
        KEY_CONTROL_TOGGLE_RUNTIME = "ags_reborn.dynamic." + UUID.randomUUID().toString();
        KEY_SWITCH_ON_RUNTIME = "ags_reborn.dynamic." + UUID.randomUUID().toString();
        KEY_SWITCH_OFF_RUNTIME = "ags_reborn.dynamic." + UUID.randomUUID().toString();
        try {
            LOGGER.info("Generated runtime keys - category={}, switch={}, control={}, on={}, off={}", new Object[]{KEY_CATEGORY_RUNTIME, KEY_SWITCH_RUNTIME, KEY_CONTROL_TOGGLE_RUNTIME, KEY_SWITCH_ON_RUNTIME, KEY_SWITCH_OFF_RUNTIME});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        EN = new String[]{"Anti Grian Switch Reborn", "Anti Grian Switch", "Should Control Be Held (Y/N)", "Anti Grian Switch: ON", "Anti Grian Switch: OFF"};
        ES = new String[]{"Interruptor Anti Grian Renacido", "Interruptor Anti Grian", "\u00bfSe debe mantener pulsado ctrl? (Y/N)", "Interruptor Anti Grian: ACTIVADO", "Interruptor Anti Grian: DESACTIVADO"};
        PL = new String[]{"Nowy Tryb Anti Grain", "Tryb Anti Grian", "Czy nale\u017cy trzyma\u0107 ctrl? (Y/N)", "Tryb Anti Grian: W\u0141\u0104CZONY", "Tryb Anti Grian: WY\u0141\u0104CZONY"};
        PIRATE_SPEAK = new String[]{"Anti-Grian Switch Hoist'd Again", "Anti-Grian Lever", "Be ye holdin\u2019 Control? (Y/N)", "Anti-Grian Lever: Aye!", "Anti-Grian Lever: Nay!"};
        LOLCAT = new String[]{"Anti-Grian Swich Rebornded", "Anti-Grian Swich", "Hold CTRL? (Y/N)", "Anti-Grian Swich: YUS", "Anti-Grian Swich: NU"};
        SHAKESPEAREAN_ENGLISH = new String[]{"Anti-Grian Lever Reawaken\u2019d", "Anti-Grian Lever", "Shall Control Be Held? (Yea/Nay)", "Anti-Grian Lever: Engaged", "Anti-Grian Lever: Disengaged"};
        ANGLISH = new String[]{"Anti-Grian Toggle Born Anew", "Anti-Grian Toggle", "Should Grasp-Key Be Held? (Y/N)", "Anti-Grian Toggle: ON", "Anti-Grian Toggle: OFF"};
        UPSIDE_DOWN_ENGLISH = new String[]{"u\u0279oq\u01dd\u0279 \u0265\u0254\u0287\u1d09\u028dS u\u1d09\u0250\u0279\u2141 \u1d09\u0287u\u2200", "\u0265\u0254\u0287\u1d09\u028dS u\u1d09\u0250\u0279\u2141 \u1d09\u0287u\u2200", "(N/\u2144) pl\u01dd\u0265 \u01ddq l\u0250\u0279\u0287uo\u0186 plno\u0265S", "NO :\u0265\u0254\u0287\u1d09\u028dS u\u1d09\u0250\u0279\u2141 \u1d09\u0287u\u2200", "FFO :\u0265\u0254\u0287\u1d09\u028dS u\u1d09\u0250\u0279\u2141 \u1d09\u0287u\u2200"};
        KLINGON = new String[]{"Grian wIvHa' chu' Ha'DIbaH", "Grian wIvHa' SeHlaw", "SeHlaw yI'uch'a'? (HIja'/ghobe')", "Grian wIvHa': Qap", "Grian wIvHa': Qapbe'"};
        QUENYA = new String[]{"Anti-Grian Lelya Ata", "Anti-Grian Lelya", "Nai mapa i cotumo? (Y/N)", "Anti-Grian Lelya: Calima", "Anti-Grian Lelya: L\u00f3m\u00eba"};
        LANGUAGE_MAP = Map.of("en_us", EN, "es_es", ES, "pl_pl", PL, "en_pt", PIRATE_SPEAK, "lol_us", LOLCAT, "enws", SHAKESPEAREAN_ENGLISH, "enp", ANGLISH, "en_ud", UPSIDE_DOWN_ENGLISH, "thl_aa", KLINGON, "qya_aa", QUENYA);
    }
}

