/*
 * Decompiled with CFR 0.152.
 */
package dev.gamelord2011.ags_reborn.mixin;

import dev.gamelord2011.ags_reborn.AgsLang;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1078;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1078.class})
public class TranslationStorageMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"ags_reborn.TranslationStorageMixin");

    @Inject(method={"method_4675(Lnet/minecraft/class_3300;Ljava/util/List;Z)Lnet/minecraft/class_1078;"}, at={@At(value="TAIL")})
    private static void interceptLoad(class_3300 resourceManager, List<?> list, boolean reload, CallbackInfoReturnable<class_1078> cir) {
        class_1078 storage = (class_1078)cir.getReturnValue();
        if (storage == null) {
            return;
        }
        String langCode = "en_us";
        try {
            langCode = class_310.method_1551().method_1526().method_4669();
            LOGGER.info("Hey, the current language is {}", (Object)langCode);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to get the language, sry, here's why, {}", t);
        }
        Map<String, String> dynamicTranslations = AgsLang.constructLanguageSet(langCode);
        LOGGER.info("Built {} dynamic translations for {}", (Object)dynamicTranslations.size(), (Object)langCode);
        try {
            for (Class<?> cls = storage.getClass(); cls != null; cls = cls.getSuperclass()) {
                for (Field field : cls.getDeclaredFields()) {
                    if (!Map.class.isAssignableFrom(field.getType())) continue;
                    field.setAccessible(true);
                    Object val = field.get(storage);
                    if (!(val instanceof Map)) continue;
                    Map translations = (Map)val;
                    try {
                        translations.putAll(dynamicTranslations);
                        LOGGER.info("Merged dynamic translations into TranslationStorage (field {}).", (Object)field.getName());
                        return;
                    }
                    catch (UnsupportedOperationException uoe) {
                        try {
                            LinkedHashMap<String, String> newMap = new LinkedHashMap<String, String>(translations);
                            newMap.putAll(dynamicTranslations);
                            field.set(storage, newMap);
                            LOGGER.info("Replaced TranslationStorage.{} with mutable map and merged dynamic translations.", (Object)field.getName());
                            return;
                        }
                        catch (Throwable setException) {
                            LOGGER.error("Failed to replace translations field: {}", (Object)setException.toString());
                            return;
                        }
                    }
                }
            }
            LOGGER.warn("No translations map field found on TranslationStorage instance to merge into.");
        }
        catch (Throwable exception) {
            LOGGER.error("Failed merging dynamic translations: {}", (Object)exception.toString());
        }
    }
}

