/*
 * Decompiled with CFR 0.152.
 */
package dev.gamelord2011.ags_reborn.mixin;

import dev.gamelord2011.ags_reborn.mixin.TranslationStorageAccessor;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1078;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1078.class})
public class TranslationStorageMixin {
    private static final Set<String> TARGET_KEYS = Set.of("key.category.minecraft.agsr.config.keybinds", "agsr.config.keybind", "agsr.config.ctrlheld", "agsr.activate.message.on", "agsr.activate.message.off");
    private final Map<String, String> randomizedTranslations = new HashMap<String, String>();
    private boolean randomized = false;

    @Inject(method={"method_4679(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;"}, at={@At(value="HEAD")}, cancellable=true)
    private void interceptGet(String key, String fallback, CallbackInfoReturnable<String> cir) {
        String randomKey;
        TranslationStorageAccessor accessor = (TranslationStorageAccessor)((Object)this);
        Map<String, String> original = accessor.getTranslations();
        if (!this.randomized) {
            for (String targetKey : TARGET_KEYS) {
                if (!original.containsKey(targetKey)) continue;
                try {
                    byte[] hash;
                    String uuids = UUID.randomUUID().toString() + UUID.randomUUID().toString();
                    MessageDigest digest = MessageDigest.getInstance("SHA3-512");
                    StringBuilder hexString = new StringBuilder();
                    for (byte b : hash = digest.digest(uuids.getBytes(StandardCharsets.UTF_8))) {
                        String hex = Integer.toHexString(0xFF & b);
                        if (hex.length() == 1) {
                            hexString.append('0');
                        }
                        hexString.append(hex);
                    }
                    String randomKey2 = "agsr.random." + hexString.toString();
                    this.randomizedTranslations.put(targetKey, randomKey2);
                    this.randomizedTranslations.put(randomKey2, original.get(targetKey));
                    System.out.println("[AGSR]: Randomization triggered, " + targetKey + " is now " + randomKey2);
                }
                catch (NoSuchAlgorithmException e) {
                    System.out.println("[ERROR]: No such hash algorithim.");
                }
            }
            this.randomized = true;
        }
        if (TARGET_KEYS.contains(key) && (randomKey = this.randomizedTranslations.get(key)) != null && this.randomizedTranslations.containsKey(randomKey)) {
            cir.setReturnValue((Object)this.randomizedTranslations.get(randomKey));
        }
    }
}

