package hiiragi283.ragium.client.gui.screen

import hiiragi283.ragium.api.gui.component.HTFluidWidget
import hiiragi283.ragium.api.inventory.HTSlotHelper
import hiiragi283.ragium.api.item.component.HTTeleportPos
import hiiragi283.ragium.api.registry.createKey
import hiiragi283.ragium.client.gui.component.HTNumberEditBox
import hiiragi283.ragium.common.block.entity.device.HTTelepadBlockentity
import hiiragi283.ragium.common.inventory.container.HTBlockEntityContainerMenu
import net.minecraft.client.gui.components.EditBox
import net.minecraft.core.BlockPos
import net.minecraft.core.registries.Registries
import net.minecraft.network.chat.Component
import net.minecraft.resources.ResourceKey
import net.minecraft.resources.ResourceLocation
import net.minecraft.world.entity.player.Inventory
import net.minecraft.world.level.Level
import org.lwjgl.glfw.GLFW

class HTTelepadScreen(
    texture: ResourceLocation,
    menu: HTBlockEntityContainerMenu<HTTelepadBlockentity>,
    inventory: Inventory,
    title: Component,
) : HTBlockEntityContainerScreen<HTTelepadBlockentity>(texture, menu, inventory, title) {
    private lateinit var fluidWidget: HTFluidWidget

    private lateinit var editBoxX: HTNumberEditBox.IntRanged
    private lateinit var editBoxY: HTNumberEditBox.IntRanged
    private lateinit var editBoxZ: HTNumberEditBox.IntRanged
    private lateinit var editBoxDim: EditBox

    override fun init() {
        super.init()
        // fluid
        fluidWidget = createFluidTank(blockEntity.tank, HTSlotHelper.getSlotPosX(0), HTSlotHelper.getSlotPosY(0))
        // x
        editBoxX = setupNumberBox(0)
        // y
        editBoxY = setupNumberBox(1)
        // z
        editBoxZ = setupNumberBox(2)
        // dimension
        editBoxDim = setupEditBox()

        val (dim: ResourceKey<Level>, pos: BlockPos) = blockEntity.teleportPos ?: return
        editBoxX.number = pos.x
        editBoxY.number = pos.y
        editBoxZ.number = pos.z
        editBoxDim.value = dim.location().toString()
    }

    /**
     * @see net.minecraft.client.gui.screens.inventory.AnvilScreen
     */
    private fun setupNumberBox(y: Int): HTNumberEditBox.IntRanged {
        val editBox: HTNumberEditBox.IntRanged = addRenderableWidget(
            HTNumberEditBox.IntRanged(
                font,
                startX + HTSlotHelper.getSlotPosX(3),
                startY + HTSlotHelper.getSlotPosY(y) - (4 * y),
                18 * 3,
            ),
        )
        editBox.setCanLoseFocus(true)
        editBox.setTextColor(-1)
        editBox.setTextColorUneditable(-1)
        editBox.setMaxLength(10)
        return editBox
    }

    private fun setupEditBox(): EditBox {
        val editBox: EditBox = addRenderableWidget(
            EditBox(
                font,
                startX + HTSlotHelper.getSlotPosX(3),
                startY + HTSlotHelper.getSlotPosY(3) - (4 * 3),
                18 * 3,
                12,
                Component.empty(),
            ),
        )
        editBox.setCanLoseFocus(true)
        editBox.setTextColor(-1)
        editBox.setTextColorUneditable(-1)
        editBox.setMaxLength(50)
        return editBox
    }

    override fun setInitialFocus() {
        setInitialFocus(editBoxX)
    }

    override fun keyPressed(keyCode: Int, scanCode: Int, modifiers: Int): Boolean = when (keyCode) {
        GLFW.GLFW_KEY_ESCAPE -> super.keyPressed(keyCode, scanCode, modifiers)
        else -> when {
            editBoxX.isFocused -> editBoxX.keyPressed(keyCode, scanCode, modifiers)
            editBoxY.isFocused -> editBoxY.keyPressed(keyCode, scanCode, modifiers)
            editBoxZ.isFocused -> editBoxZ.keyPressed(keyCode, scanCode, modifiers)
            editBoxDim.isFocused -> editBoxDim.keyPressed(keyCode, scanCode, modifiers)
            else -> super.keyPressed(keyCode, scanCode, modifiers)
        }
    }

    override fun removed() {
        syncTeleportPos()
        super.removed()
    }

    private fun syncTeleportPos() {
        val x: Int = editBoxX.number
        val y: Int = editBoxY.number
        val z: Int = editBoxZ.number
        val id: ResourceLocation = editBoxDim.value.let(ResourceLocation::tryParse) ?: return
        val dim: ResourceKey<Level> = Registries.DIMENSION.createKey(id)
        this.blockEntity.teleportPos = HTTeleportPos(dim, x, y, z)
    }

    override fun getFluidWidgets(): List<HTFluidWidget> = listOf(fluidWidget)
}
