package hiiragi283.ragium.common.item.food

import hiiragi283.ragium.api.storage.HTStorageAccess
import hiiragi283.ragium.api.storage.HTStorageAction
import hiiragi283.ragium.api.storage.capability.HTItemCapabilities
import hiiragi283.ragium.api.storage.item.HTItemSlot
import hiiragi283.ragium.api.storage.item.getItemStack
import hiiragi283.ragium.common.util.HTItemDropHelper
import hiiragi283.ragium.setup.RagiumMenuTypes
import net.minecraft.advancements.CriteriaTriggers
import net.minecraft.server.level.ServerPlayer
import net.minecraft.world.InteractionHand
import net.minecraft.world.InteractionResultHolder
import net.minecraft.world.entity.LivingEntity
import net.minecraft.world.entity.player.Player
import net.minecraft.world.item.Item
import net.minecraft.world.item.ItemStack
import net.minecraft.world.item.ItemUtils
import net.minecraft.world.item.UseAnim
import net.minecraft.world.level.Level

class HTPotionBundleItem(properties: Properties) : Item(properties.stacksTo(1)) {
    override fun finishUsingItem(stack: ItemStack, level: Level, livingEntity: LivingEntity): ItemStack {
        for (slot: HTItemSlot in HTItemCapabilities.getItemSlots(stack)) {
            val stackIn: ItemStack = slot.getItemStack()
            if (stackIn.isEmpty) continue
            val result: ItemStack = stackIn.finishUsingItem(level, livingEntity)
            if (!livingEntity.hasInfiniteMaterials()) {
                slot.extract(1, HTStorageAction.EXECUTE, HTStorageAccess.INTERNAL)
            }
            if (result != stackIn && livingEntity is Player) {
                HTItemDropHelper.giveStackTo(livingEntity, result)
            }
            if (livingEntity is ServerPlayer) {
                CriteriaTriggers.CONSUME_ITEM.trigger(livingEntity, stack)
            }
            return stack
        }
        return stack
    }

    override fun getUseDuration(stack: ItemStack, entity: LivingEntity): Int = 32

    override fun getUseAnimation(stack: ItemStack): UseAnim = UseAnim.DRINK

    override fun use(level: Level, player: Player, usedHand: InteractionHand): InteractionResultHolder<ItemStack> {
        val stack: ItemStack = player.getItemInHand(usedHand)
        // 　シフト中はGUIを開く
        return when {
            player.isShiftKeyDown -> InteractionResultHolder(
                RagiumMenuTypes.POTION_BUNDLE.openMenu(
                    player,
                    usedHand,
                    stack,
                ),
                stack,
            )

            else -> ItemUtils.startUsingInstantly(level, player, usedHand)
        }
    }
}
