package hiiragi283.ragium.impl.data.recipe

import hiiragi283.ragium.api.data.recipe.HTStackRecipeBuilder
import hiiragi283.ragium.api.material.HTMaterialLike
import hiiragi283.ragium.api.material.prefix.HTPrefixLike
import hiiragi283.ragium.api.stack.ImmutableItemStack
import net.minecraft.tags.TagKey
import net.minecraft.world.item.Item
import net.minecraft.world.item.ItemStack
import net.minecraft.world.item.crafting.CraftingBookCategory
import net.minecraft.world.item.crafting.Ingredient
import net.minecraft.world.item.crafting.ShapedRecipe
import net.minecraft.world.item.crafting.ShapedRecipePattern
import net.minecraft.world.level.ItemLike
import net.neoforged.neoforge.common.crafting.ICustomIngredient

class HTShapedRecipeBuilder(private val category: CraftingBookCategory, stack: ImmutableItemStack) :
    HTStackRecipeBuilder<HTShapedRecipeBuilder>("shaped", stack) {
    companion object {
        @JvmStatic
        fun building(item: ItemLike, count: Int = 1): HTShapedRecipeBuilder =
            HTShapedRecipeBuilder(CraftingBookCategory.BUILDING, ImmutableItemStack.of(item, count))

        @JvmStatic
        fun redstone(item: ItemLike, count: Int = 1): HTShapedRecipeBuilder =
            HTShapedRecipeBuilder(CraftingBookCategory.REDSTONE, ImmutableItemStack.of(item, count))

        @JvmStatic
        fun equipment(item: ItemLike, count: Int = 1): HTShapedRecipeBuilder =
            HTShapedRecipeBuilder(CraftingBookCategory.EQUIPMENT, ImmutableItemStack.of(item, count))

        @JvmStatic
        fun misc(item: ItemLike, count: Int = 1): HTShapedRecipeBuilder =
            HTShapedRecipeBuilder(CraftingBookCategory.MISC, ImmutableItemStack.of(item, count))
    }

    private val symbols: MutableMap<Char, Ingredient> = mutableMapOf()

    fun define(symbol: Char, prefix: HTPrefixLike, key: HTMaterialLike): HTShapedRecipeBuilder = define(symbol, prefix.itemTagKey(key))

    fun define(symbol: Char, tagKey: TagKey<Item>): HTShapedRecipeBuilder = define(symbol, Ingredient.of(tagKey))

    fun define(symbol: Char, item: ItemLike): HTShapedRecipeBuilder = define(symbol, Ingredient.of(item))

    fun define(symbol: Char, ingredient: ICustomIngredient): HTShapedRecipeBuilder = define(symbol, ingredient.toVanilla())

    fun define(symbol: Char, ingredient: Ingredient): HTShapedRecipeBuilder = apply {
        check(symbol !in symbols) { "Symbol '$symbol' is already used!" }
        check(symbol != ' ') { "Symbol ' ' is not allowed!" }
        symbols[symbol] = ingredient
    }

    private val patterns: MutableList<String> = mutableListOf()

    fun pattern(vararg pattern: String): HTShapedRecipeBuilder = apply {
        check(pattern.map(String::length).toSet().size == 1) { "Each pattern must be the same length!" }
        patterns.addAll(pattern)
    }

    fun storage4(): HTShapedRecipeBuilder = pattern("AA", "AA")

    fun storage9(): HTShapedRecipeBuilder = pattern("AAA", "AAA", "AAA")

    fun hollow(): HTShapedRecipeBuilder = pattern("AAA", "A A", "AAA")

    fun hollow4(): HTShapedRecipeBuilder = pattern(" A ", "ABA", " A ")

    fun hollow8(): HTShapedRecipeBuilder = pattern("AAA", "ABA", "AAA")

    fun cross4(): HTShapedRecipeBuilder = pattern(" A ", "BCB", " A ")

    fun cross8(): HTShapedRecipeBuilder = pattern("ABA", "BCB", "ABA")

    fun crossLayered(): HTShapedRecipeBuilder = pattern("ABA", "CDC", "ABA")

    fun casing(): HTShapedRecipeBuilder = pattern("AAA", "ABA", "CCC")

    fun mosaic4(): HTShapedRecipeBuilder = pattern("AB", "BA")

    //    RecipeBuilder    //

    private var group: String? = null

    fun setGroup(group: String?): HTShapedRecipeBuilder = apply {
        this.group = group
    }

    override fun createRecipe(output: ItemStack): ShapedRecipe = ShapedRecipe(
        group ?: "",
        category,
        ShapedRecipePattern.of(symbols, patterns),
        output,
        true,
    )
}
