/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.api.storage.fluid;

import hiiragi283.ragium.api.codec.BiCodecs;
import hiiragi283.ragium.api.storage.HTStackSlot;
import hiiragi283.ragium.api.storage.HTStorageAccess;
import hiiragi283.ragium.api.storage.fluid.HTFluidTankWrapper;
import hiiragi283.ragium.api.storage.predicate.HTFluidPredicates;
import hiiragi283.ragium.api.storage.value.HTValueOutput;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001aJ\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0002H\u0017J\b\u0010\u000f\u001a\u00020\u0010H\u0017J\b\u0010\u0011\u001a\u00020\u0010H\u0017J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0002H\u0017J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0017\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001b\u00c0\u0006\u0001"}, d2={"Lhiiragi283/ragium/api/storage/fluid/HTFluidTank;", "Lhiiragi283/ragium/api/storage/HTStackSlot;", "Lnet/neoforged/neoforge/fluids/FluidStack;", "Lnet/neoforged/neoforge/fluids/IFluidTank;", "getAmountAsLong", "", "isEmpty", "", "serialize", "", "output", "Lhiiragi283/ragium/api/storage/value/HTValueOutput;", "toSingleHandler", "Lnet/neoforged/neoforge/fluids/capability/IFluidHandler;", "getFluid", "getFluidAmount", "", "getCapacity", "isFluidValid", "stack", "fill", "resource", "action", "Lnet/neoforged/neoforge/fluids/capability/IFluidHandler$FluidAction;", "drain", "maxDrain", "Mutable", "ragium_api"})
public interface HTFluidTank
extends HTStackSlot<FluidStack>,
IFluidTank {
    @Override
    default public long getAmountAsLong() {
        return ((FluidStack)this.getStack()).getAmount();
    }

    @Override
    default public boolean isEmpty() {
        return ((FluidStack)this.getStack()).isEmpty();
    }

    @Override
    default public void serialize(@NotNull HTValueOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.store("fluid", BiCodecs.fluidStack(true), this.getStack());
    }

    @NotNull
    default public IFluidHandler toSingleHandler() {
        return new HTFluidTankWrapper(this);
    }

    @Deprecated(message="Use `getStack()` instead", replaceWith=@ReplaceWith(expression="this.getStack()", imports={}), level=DeprecationLevel.ERROR)
    @NotNull
    default public FluidStack getFluid() {
        return (FluidStack)this.getStack();
    }

    @Deprecated(message="Use `getAmountAsInt()` instead", replaceWith=@ReplaceWith(expression="this.getAmountAsInt()", imports={}), level=DeprecationLevel.ERROR)
    default public int getFluidAmount() {
        return ((FluidStack)this.getStack()).getAmount();
    }

    @Deprecated(message="Use `getCapacityAsInt(FluidStack)` instead", level=DeprecationLevel.ERROR)
    default public int getCapacity() {
        return this.getCapacityAsInt(this.getStack());
    }

    @Deprecated(message="Use `isValid(FluidStack)` instead", replaceWith=@ReplaceWith(expression="this.isValid(stack)", imports={}), level=DeprecationLevel.ERROR)
    default public boolean isFluidValid(@NotNull FluidStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return this.isValid(stack);
    }

    @Deprecated(message="Use `insert(FluidStack, Boolean, HTStorageAccess) `instead")
    default public int fill(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return resource.getAmount() - this.insert(resource, action.simulate(), HTStorageAccess.EXTERNAL).getAmount();
    }

    @Deprecated(message="Use `extract(FluidStack, Boolean, HTStorageAccess)` instead")
    @NotNull
    default public FluidStack drain(int maxDrain, @NotNull IFluidHandler.FluidAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return (FluidStack)this.extract(maxDrain, action.simulate(), HTStorageAccess.EXTERNAL);
    }

    @Deprecated(message="Use `extract(FluidStack, Boolean, HTStorageAccess)` instead")
    @NotNull
    default public FluidStack drain(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        if (!HTFluidPredicates.byFluidAndComponent(resource).test((FluidStack)this.getStack())) {
            FluidStack fluidStack = FluidStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"EMPTY");
            return fluidStack;
        }
        return (FluidStack)this.extract(resource.getAmount(), action.simulate(), HTStorageAccess.EXTERNAL);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\bf\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002J\b\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0014\u00c0\u0006\u0001"}, d2={"Lhiiragi283/ragium/api/storage/fluid/HTFluidTank$Mutable;", "Lhiiragi283/ragium/api/storage/fluid/HTFluidTank;", "Lhiiragi283/ragium/api/storage/HTStackSlot$Mutable;", "Lnet/neoforged/neoforge/fluids/FluidStack;", "setEmpty", "", "insert", "stack", "simulate", "", "access", "Lhiiragi283/ragium/api/storage/HTStorageAccess;", "extract", "amount", "", "isFluidValidForInsert", "canFluidExtract", "setStackSize", "growStack", "shrinkStack", "ragium_api"})
    public static interface Mutable
    extends HTFluidTank,
    HTStackSlot.Mutable<FluidStack> {
        @Override
        default public void setEmpty() {
            FluidStack fluidStack = FluidStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"EMPTY");
            this.setStack(fluidStack);
        }

        @Override
        @NotNull
        default public FluidStack insert(@NotNull FluidStack stack, boolean simulate, @NotNull HTStorageAccess access) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)((Object)access), (String)"access");
            if (stack.isEmpty()) {
                FluidStack fluidStack = FluidStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"EMPTY");
                return fluidStack;
            }
            int needed = this.getNeededAsInt(stack);
            if (needed <= 0 || !this.isFluidValidForInsert(stack, access)) {
                return stack;
            }
            boolean sameType = FluidStack.isSameFluidSameComponents((FluidStack)((FluidStack)this.getStack()), (FluidStack)stack);
            if (this.isEmpty() || sameType) {
                int toAdd = Math.min(stack.getAmount(), needed);
                if (!simulate) {
                    if (sameType) {
                        this.growStack(toAdd, false);
                        this.onContentsChanged();
                    } else {
                        FluidStack fluidStack = stack.copyWithAmount(toAdd);
                        Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"copyWithAmount(...)");
                        this.setStack(fluidStack);
                    }
                }
                FluidStack fluidStack = stack.copyWithAmount(stack.getAmount() - toAdd);
                Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"copyWithAmount(...)");
                return fluidStack;
            }
            return stack;
        }

        @Override
        @NotNull
        default public FluidStack extract(int amount, boolean simulate, @NotNull HTStorageAccess access) {
            Intrinsics.checkNotNullParameter((Object)((Object)access), (String)"access");
            FluidStack stack = (FluidStack)this.getStack();
            if (this.isEmpty() || amount < 1 || !this.canFluidExtract((FluidStack)this.getStack(), access)) {
                FluidStack fluidStack = FluidStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"EMPTY");
                return fluidStack;
            }
            int current = Math.min(stack.getAmount(), this.getCapacityAsInt(this.getStack()));
            int fixedAmount = Math.min(amount, current);
            FluidStack fluidStack = stack.copyWithAmount(fixedAmount);
            Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"copyWithAmount(...)");
            FluidStack result = fluidStack;
            if (!simulate) {
                this.shrinkStack(fixedAmount, false);
                this.onContentsChanged();
            }
            return result;
        }

        default public boolean isFluidValidForInsert(@NotNull FluidStack stack, @NotNull HTStorageAccess access) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)((Object)access), (String)"access");
            return this.isValid(stack);
        }

        default public boolean canFluidExtract(@NotNull FluidStack stack, @NotNull HTStorageAccess access) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)((Object)access), (String)"access");
            return true;
        }

        default public int setStackSize(int amount, boolean simulate) {
            if (this.isEmpty()) {
                return 0;
            }
            if (amount <= 0) {
                if (!simulate) {
                    this.setEmpty();
                }
                return 0;
            }
            FluidStack stack = (FluidStack)this.getStack();
            int maxStackSize = this.getCapacityAsInt(stack);
            int fixedAmount = Math.min(amount, maxStackSize);
            if (stack.getAmount() == fixedAmount || simulate) {
                return fixedAmount;
            }
            FluidStack fluidStack = stack.copyWithAmount(fixedAmount);
            Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"copyWithAmount(...)");
            this.setStack(fluidStack);
            this.onContentsChanged();
            return fixedAmount;
        }

        default public int growStack(int amount, boolean simulate) {
            int current = this.getAmountAsInt();
            if (current == 0) {
                return 0;
            }
            int fixedAmount = amount > 0 ? Math.min(amount, this.getCapacityAsInt(this.getStack())) : amount;
            int newSize = this.setStackSize(current + fixedAmount, simulate);
            return newSize - current;
        }

        default public int shrinkStack(int amount, boolean simulate) {
            return -this.growStack(-amount, simulate);
        }
    }
}

