/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.api.storage.item;

import hiiragi283.ragium.api.codec.BiCodecs;
import hiiragi283.ragium.api.storage.HTStackSlot;
import hiiragi283.ragium.api.storage.HTStorageAccess;
import hiiragi283.ragium.api.storage.value.HTValueOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\r\u000eJ\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lhiiragi283/ragium/api/storage/item/HTItemSlot;", "Lhiiragi283/ragium/api/storage/HTStackSlot;", "Lnet/minecraft/world/item/ItemStack;", "getAmountAsLong", "", "isEmpty", "", "serialize", "", "output", "Lhiiragi283/ragium/api/storage/value/HTValueOutput;", "createContainerSlot", "Lnet/minecraft/world/inventory/Slot;", "Companion", "Mutable", "ragium_api"})
public interface HTItemSlot
extends HTStackSlot<ItemStack> {
    @NotNull
    public static final Companion Companion = hiiragi283.ragium.api.storage.item.HTItemSlot$Companion.$$INSTANCE;
    public static final long ABSOLUTE_MAX_STACK_SIZE = 99L;

    @Override
    default public long getAmountAsLong() {
        return ((ItemStack)this.getStack()).getCount();
    }

    @Override
    default public boolean isEmpty() {
        return ((ItemStack)this.getStack()).isEmpty();
    }

    @Override
    default public void serialize(@NotNull HTValueOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.store("item", BiCodecs.itemStack(true), this.getStack());
    }

    @Nullable
    public Slot createContainerSlot();

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lhiiragi283/ragium/api/storage/item/HTItemSlot$Companion;", "", "<init>", "()V", "ABSOLUTE_MAX_STACK_SIZE", "", "ragium_api"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        public static final long ABSOLUTE_MAX_STACK_SIZE = 99L;

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\bf\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002J\b\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0014\u00c0\u0006\u0001"}, d2={"Lhiiragi283/ragium/api/storage/item/HTItemSlot$Mutable;", "Lhiiragi283/ragium/api/storage/item/HTItemSlot;", "Lhiiragi283/ragium/api/storage/HTStackSlot$Mutable;", "Lnet/minecraft/world/item/ItemStack;", "setEmpty", "", "insert", "stack", "simulate", "", "access", "Lhiiragi283/ragium/api/storage/HTStorageAccess;", "extract", "amount", "", "isItemValidForInsert", "canItemExtract", "setStackSize", "growStack", "shrinkStack", "ragium_api"})
    public static interface Mutable
    extends HTItemSlot,
    HTStackSlot.Mutable<ItemStack> {
        @Override
        default public void setEmpty() {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            this.setStack(itemStack);
        }

        @Override
        @NotNull
        default public ItemStack insert(@NotNull ItemStack stack, boolean simulate, @NotNull HTStorageAccess access) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)((Object)access), (String)"access");
            if (stack.isEmpty()) {
                ItemStack itemStack = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
            int needed = this.getNeededAsInt(stack);
            if (needed <= 0 || !this.isItemValidForInsert(stack, access)) {
                return stack;
            }
            boolean sameType = ItemStack.isSameItemSameComponents((ItemStack)((ItemStack)this.getStack()), (ItemStack)stack);
            if (this.isEmpty() || sameType) {
                int toAdd = Math.min(stack.getCount(), needed);
                if (!simulate) {
                    if (sameType) {
                        this.growStack(toAdd, false);
                        this.onContentsChanged();
                    } else {
                        ItemStack itemStack = stack.copyWithCount(toAdd);
                        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copyWithCount(...)");
                        this.setStack(itemStack);
                    }
                }
                ItemStack itemStack = stack.copyWithCount(stack.getCount() - toAdd);
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copyWithCount(...)");
                return itemStack;
            }
            return stack;
        }

        @Override
        @NotNull
        default public ItemStack extract(int amount, boolean simulate, @NotNull HTStorageAccess access) {
            Intrinsics.checkNotNullParameter((Object)((Object)access), (String)"access");
            ItemStack stack = (ItemStack)this.getStack();
            if (this.isEmpty() || amount < 1 || !this.canItemExtract((ItemStack)this.getStack(), access)) {
                ItemStack itemStack = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
            int current = Math.min(stack.getCount(), stack.getMaxStackSize());
            int fixedAmount = Math.min(amount, current);
            ItemStack itemStack = stack.copyWithCount(fixedAmount);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copyWithCount(...)");
            ItemStack result = itemStack;
            if (!simulate) {
                this.shrinkStack(fixedAmount, false);
                this.onContentsChanged();
            }
            return result;
        }

        default public boolean isItemValidForInsert(@NotNull ItemStack stack, @NotNull HTStorageAccess access) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)((Object)access), (String)"access");
            return this.isValid(stack);
        }

        default public boolean canItemExtract(@NotNull ItemStack stack, @NotNull HTStorageAccess access) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)((Object)access), (String)"access");
            return true;
        }

        default public int setStackSize(int amount, boolean simulate) {
            if (this.isEmpty()) {
                return 0;
            }
            if (amount <= 0) {
                if (!simulate) {
                    this.setEmpty();
                }
                return 0;
            }
            ItemStack stack = (ItemStack)this.getStack();
            int maxStackSize = this.getCapacityAsInt(stack);
            int fixedAmount = Math.min(amount, maxStackSize);
            if (stack.getCount() == fixedAmount || simulate) {
                return fixedAmount;
            }
            ItemStack itemStack = stack.copyWithCount(fixedAmount);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copyWithCount(...)");
            this.setStack(itemStack);
            this.onContentsChanged();
            return fixedAmount;
        }

        default public int growStack(int amount, boolean simulate) {
            int current = this.getAmountAsInt();
            if (current == 0) {
                return 0;
            }
            int fixedAmount = amount > 0 ? Math.min(amount, this.getCapacityAsInt(this.getStack())) : amount;
            int newSize = this.setStackSize(current + fixedAmount, simulate);
            return newSize - current;
        }

        default public int shrinkStack(int amount, boolean simulate) {
            return -this.growStack(-amount, simulate);
        }
    }
}

