/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.block.entity.device;

import hiiragi283.ragium.api.extension.LevelExtensionsKt;
import hiiragi283.ragium.api.storage.HTContentListener;
import hiiragi283.ragium.api.storage.HTStorageAccess;
import hiiragi283.ragium.api.storage.fluid.HTFluidInteractable;
import hiiragi283.ragium.api.storage.holder.HTFluidTankHolder;
import hiiragi283.ragium.common.block.entity.device.HTDeviceBlockEntity;
import hiiragi283.ragium.common.storage.fluid.HTVariableFluidStackTank;
import hiiragi283.ragium.common.storage.holder.HTSimpleFluidTankHolder;
import hiiragi283.ragium.common.variant.HTDeviceVariant;
import hiiragi283.ragium.config.RagiumConfig;
import hiiragi283.ragium.setup.RagiumFluidContents;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lhiiragi283/ragium/common/block/entity/device/HTExpCollectorBlockEntity;", "Lhiiragi283/ragium/common/block/entity/device/HTDeviceBlockEntity;", "Lhiiragi283/ragium/api/storage/fluid/HTFluidInteractable;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "tank", "Lhiiragi283/ragium/common/storage/fluid/HTVariableFluidStackTank;", "initializeFluidHandler", "Lhiiragi283/ragium/api/storage/holder/HTFluidTankHolder;", "listener", "Lhiiragi283/ragium/api/storage/HTContentListener;", "actionServer", "", "level", "Lnet/minecraft/server/level/ServerLevel;", "interactWith", "Lnet/minecraft/world/ItemInteractionResult;", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "ragium"})
public final class HTExpCollectorBlockEntity
extends HTDeviceBlockEntity
implements HTFluidInteractable {
    private HTVariableFluidStackTank tank;

    public HTExpCollectorBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(HTDeviceVariant.EXP_COLLECTOR, pos, state);
    }

    @Override
    @NotNull
    protected HTFluidTankHolder initializeFluidHandler(@NotNull HTContentListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.tank = HTVariableFluidStackTank.Companion.output(listener, RagiumConfig.COMMON.deviceCollectorTankCapacity);
        HTVariableFluidStackTank hTVariableFluidStackTank = this.tank;
        if (hTVariableFluidStackTank == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tank");
            hTVariableFluidStackTank = null;
        }
        return HTSimpleFluidTankHolder.Companion.output(null, hTVariableFluidStackTank);
    }

    @Override
    protected boolean actionServer(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        List list = level.getEntitiesOfClass(ExperienceOrb.class, LevelExtensionsKt.getRangedAABB(pos, (Number)RagiumConfig.COMMON.deviceCollectorEntityRange.getAsDouble()));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesOfClass(...)");
        List expOrbs = list;
        if (expOrbs.isEmpty()) {
            return false;
        }
        for (ExperienceOrb entity : expOrbs) {
            FluidStack remainStack;
            int fluidAmount = entity.value * RagiumConfig.COMMON.expCollectorMultiplier.getAsInt();
            FluidStack stack = RagiumFluidContents.EXPERIENCE.toStack(fluidAmount);
            HTVariableFluidStackTank hTVariableFluidStackTank = this.tank;
            if (hTVariableFluidStackTank == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tank");
                hTVariableFluidStackTank = null;
            }
            if ((remainStack = hTVariableFluidStackTank.insert(stack, false, HTStorageAccess.INTERNAl)).isEmpty()) {
                entity.discard();
                continue;
            }
            entity.value = remainStack.getAmount();
        }
        return true;
    }

    @Override
    @NotNull
    public ItemInteractionResult interactWith(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        HTVariableFluidStackTank hTVariableFluidStackTank = this.tank;
        if (hTVariableFluidStackTank == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tank");
            hTVariableFluidStackTank = null;
        }
        return this.interactWith(player, hand, hTVariableFluidStackTank);
    }
}

