/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.block.entity.device;

import hiiragi283.ragium.api.storage.HTContentListener;
import hiiragi283.ragium.api.storage.HTStorageAccess;
import hiiragi283.ragium.api.storage.fluid.HTFluidInteractable;
import hiiragi283.ragium.api.storage.holder.HTFluidTankHolder;
import hiiragi283.ragium.common.block.entity.device.HTDeviceBlockEntity;
import hiiragi283.ragium.common.storage.fluid.HTVariableFluidStackTank;
import hiiragi283.ragium.common.storage.holder.HTSimpleFluidTankHolder;
import hiiragi283.ragium.common.variant.HTDeviceVariant;
import hiiragi283.ragium.config.RagiumConfig;
import hiiragi283.ragium.setup.RagiumMenuTypes;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J0\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u0006H$J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u0006H$J \u0010 \u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lhiiragi283/ragium/common/block/entity/device/HTFluidCollectorBlockEntity;", "Lhiiragi283/ragium/common/block/entity/device/HTDeviceBlockEntity;", "Lhiiragi283/ragium/api/storage/fluid/HTFluidInteractable;", "variant", "Lhiiragi283/ragium/common/variant/HTDeviceVariant;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lhiiragi283/ragium/common/variant/HTDeviceVariant;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "tank", "Lhiiragi283/ragium/common/storage/fluid/HTVariableFluidStackTank;", "initializeFluidHandler", "Lhiiragi283/ragium/api/storage/holder/HTFluidTankHolder;", "listener", "Lhiiragi283/ragium/api/storage/HTContentListener;", "onRightClicked", "Lnet/minecraft/world/InteractionResult;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "actionServer", "", "Lnet/minecraft/server/level/ServerLevel;", "getGeneratedFluid", "Lnet/neoforged/neoforge/fluids/FluidStack;", "playSound", "", "interactWith", "Lnet/minecraft/world/ItemInteractionResult;", "hand", "Lnet/minecraft/world/InteractionHand;", "ragium"})
public abstract class HTFluidCollectorBlockEntity
extends HTDeviceBlockEntity
implements HTFluidInteractable {
    private HTVariableFluidStackTank tank;

    public HTFluidCollectorBlockEntity(@NotNull HTDeviceVariant variant, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(variant, pos, state);
    }

    @Override
    @NotNull
    protected HTFluidTankHolder initializeFluidHandler(@NotNull HTContentListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.tank = HTVariableFluidStackTank.Companion.output(listener, RagiumConfig.COMMON.deviceCollectorTankCapacity);
        HTVariableFluidStackTank hTVariableFluidStackTank = this.tank;
        if (hTVariableFluidStackTank == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tank");
            hTVariableFluidStackTank = null;
        }
        return HTSimpleFluidTankHolder.Companion.output(null, hTVariableFluidStackTank);
    }

    @Override
    @NotNull
    public InteractionResult onRightClicked(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        return RagiumMenuTypes.FLUID_COLLECTOR.openMenu(player, this.getName(), this, (Function1<RegistryFriendlyByteBuf, Unit>)((Function1)new Function1<RegistryFriendlyByteBuf, Unit>((Object)this){

            public final void invoke(RegistryFriendlyByteBuf p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((HTFluidCollectorBlockEntity)this.receiver).writeExtraContainerData(p0);
            }
        }));
    }

    @Override
    protected boolean actionServer(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        FluidStack stack = this.getGeneratedFluid(level, pos);
        if (stack.isEmpty()) {
            return false;
        }
        HTVariableFluidStackTank hTVariableFluidStackTank = this.tank;
        if (hTVariableFluidStackTank == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tank");
            hTVariableFluidStackTank = null;
        }
        if (!hTVariableFluidStackTank.insert(stack, true, HTStorageAccess.INTERNAl).isEmpty()) {
            return false;
        }
        HTVariableFluidStackTank hTVariableFluidStackTank2 = this.tank;
        if (hTVariableFluidStackTank2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tank");
            hTVariableFluidStackTank2 = null;
        }
        hTVariableFluidStackTank2.insert(stack, false, HTStorageAccess.INTERNAl);
        this.playSound(level, pos);
        return true;
    }

    @NotNull
    protected abstract FluidStack getGeneratedFluid(@NotNull ServerLevel var1, @NotNull BlockPos var2);

    protected abstract void playSound(@NotNull ServerLevel var1, @NotNull BlockPos var2);

    @Override
    @NotNull
    public ItemInteractionResult interactWith(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        HTVariableFluidStackTank hTVariableFluidStackTank = this.tank;
        if (hTVariableFluidStackTank == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tank");
            hTVariableFluidStackTank = null;
        }
        return this.interactWith(player, hand, hTVariableFluidStackTank);
    }
}

