/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.block.entity.generator;

import hiiragi283.ragium.api.inventory.HTSlotHelper;
import hiiragi283.ragium.api.storage.HTContentListener;
import hiiragi283.ragium.api.storage.HTStorageAccess;
import hiiragi283.ragium.api.storage.energy.HTEnergyBattery;
import hiiragi283.ragium.api.storage.fluid.HTFluidInteractable;
import hiiragi283.ragium.api.storage.holder.HTFluidTankHolder;
import hiiragi283.ragium.api.storage.holder.HTItemSlotHolder;
import hiiragi283.ragium.common.block.entity.generator.HTGeneratorBlockEntity;
import hiiragi283.ragium.common.storage.fluid.HTVariableFluidStackTank;
import hiiragi283.ragium.common.storage.holder.HTSimpleFluidTankHolder;
import hiiragi283.ragium.common.storage.holder.HTSimpleItemSlotHolder;
import hiiragi283.ragium.common.storage.item.slot.HTFluidFuelItemStackSlot;
import hiiragi283.ragium.common.variant.HTGeneratorVariant;
import hiiragi283.ragium.config.RagiumConfig;
import hiiragi283.ragium.setup.RagiumMenuTypes;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J(\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010$\u001a\u00020%H\u0014J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H$J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u000b\u001a\u00020'H$J\u0018\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020.2\u0006\u0010(\u001a\u00020+H$J\u001e\u0010/\u001a\u0002002\u0006\u0010\"\u001a\u0002012\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00102\u001a\u000203R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0084.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u0014@BX\u0084.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00064"}, d2={"Lhiiragi283/ragium/common/block/entity/generator/HTFuelGeneratorBlockEntity;", "Lhiiragi283/ragium/common/block/entity/generator/HTGeneratorBlockEntity;", "Lhiiragi283/ragium/api/storage/fluid/HTFluidInteractable;", "variant", "Lhiiragi283/ragium/common/variant/HTGeneratorVariant;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lhiiragi283/ragium/common/variant/HTGeneratorVariant;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "value", "Lhiiragi283/ragium/common/storage/item/slot/HTFluidFuelItemStackSlot;", "slot", "getSlot", "()Lhiiragi283/ragium/common/storage/item/slot/HTFluidFuelItemStackSlot;", "initializeItemHandler", "Lhiiragi283/ragium/api/storage/holder/HTItemSlotHolder;", "listener", "Lhiiragi283/ragium/api/storage/HTContentListener;", "Lhiiragi283/ragium/common/storage/fluid/HTVariableFluidStackTank;", "tank", "getTank", "()Lhiiragi283/ragium/common/storage/fluid/HTVariableFluidStackTank;", "initializeFluidHandler", "Lhiiragi283/ragium/api/storage/holder/HTFluidTankHolder;", "openGui", "Lnet/minecraft/world/InteractionResult;", "player", "Lnet/minecraft/world/entity/player/Player;", "title", "Lnet/minecraft/network/chat/Component;", "onUpdateServer", "", "level", "Lnet/minecraft/server/level/ServerLevel;", "network", "Lhiiragi283/ragium/api/storage/energy/HTEnergyBattery;", "getFuelValue", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "getFuelStack", "Lnet/neoforged/neoforge/fluids/FluidStack;", "getRequiredAmount", "access", "Lnet/minecraft/core/RegistryAccess;", "interactWith", "Lnet/minecraft/world/ItemInteractionResult;", "Lnet/minecraft/world/level/Level;", "hand", "Lnet/minecraft/world/InteractionHand;", "ragium"})
public abstract class HTFuelGeneratorBlockEntity
extends HTGeneratorBlockEntity
implements HTFluidInteractable {
    private HTFluidFuelItemStackSlot slot;
    private HTVariableFluidStackTank tank;

    public HTFuelGeneratorBlockEntity(@NotNull HTGeneratorVariant variant, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(variant, pos, state);
    }

    @NotNull
    protected final HTFluidFuelItemStackSlot getSlot() {
        HTFluidFuelItemStackSlot hTFluidFuelItemStackSlot = this.slot;
        if (hTFluidFuelItemStackSlot != null) {
            return hTFluidFuelItemStackSlot;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"slot");
        return null;
    }

    @Override
    @NotNull
    protected HTItemSlotHolder initializeItemHandler(@NotNull HTContentListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.slot = HTFluidFuelItemStackSlot.Companion.create(this.getTank(), (Function1<? super ItemStack, Integer>)((Function1)new Function1<ItemStack, Integer>((Object)this){

            public final Integer invoke(ItemStack p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((HTFuelGeneratorBlockEntity)this.receiver).getFuelValue(p0);
            }
        }), (Function1<? super Integer, FluidStack>)((Function1)new Function1<Integer, FluidStack>((Object)this){

            public final FluidStack invoke(int p0) {
                return ((HTFuelGeneratorBlockEntity)this.receiver).getFuelStack(p0);
            }
        }), listener, HTSlotHelper.getSlotPosX(2), HTSlotHelper.getSlotPosY(1));
        return new HTSimpleItemSlotHolder(this, CollectionsKt.listOf((Object)this.getSlot()), CollectionsKt.emptyList(), null, 8, null);
    }

    @NotNull
    protected final HTVariableFluidStackTank getTank() {
        HTVariableFluidStackTank hTVariableFluidStackTank = this.tank;
        if (hTVariableFluidStackTank != null) {
            return hTVariableFluidStackTank;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"tank");
        return null;
    }

    @Override
    @Nullable
    protected HTFluidTankHolder initializeFluidHandler(@NotNull HTContentListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.tank = HTVariableFluidStackTank.Companion.input$default(HTVariableFluidStackTank.Companion, listener, RagiumConfig.COMMON.generatorInputTankCapacity, null, arg_0 -> HTFuelGeneratorBlockEntity.initializeFluidHandler$lambda$0(this, arg_0), 4, null);
        return HTSimpleFluidTankHolder.Companion.input(this, this.getTank());
    }

    @Override
    @NotNull
    protected InteractionResult openGui(@NotNull Player player, @NotNull Component title) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        return RagiumMenuTypes.FUEL_GENERATOR.openMenu(player, title, this, (Function1<RegistryFriendlyByteBuf, Unit>)((Function1)new Function1<RegistryFriendlyByteBuf, Unit>((Object)this){

            public final void invoke(RegistryFriendlyByteBuf p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((HTFuelGeneratorBlockEntity)this.receiver).writeExtraContainerData(p0);
            }
        }));
    }

    @Override
    protected boolean onUpdateServer(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull HTEnergyBattery network) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        this.getSlot().fillOrBurn();
        RegistryAccess registryAccess = level.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        int required = this.getRequiredAmount(registryAccess, this.getTank().getStack());
        if (required <= 0) {
            return false;
        }
        if (this.getTank().extract(required, true, HTStorageAccess.INTERNAl).isEmpty()) {
            return false;
        }
        int usage = this.getModifiedEnergy(this.getEnergyUsage());
        if (network.insertEnergy(usage, true, HTStorageAccess.INTERNAl) > 0) {
            this.getTank().extract(required, false, HTStorageAccess.INTERNAl);
            network.insertEnergy(usage, false, HTStorageAccess.INTERNAl);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    protected abstract int getFuelValue(@NotNull ItemStack var1);

    @NotNull
    protected abstract FluidStack getFuelStack(int var1);

    protected abstract int getRequiredAmount(@NotNull RegistryAccess var1, @NotNull FluidStack var2);

    @Override
    @NotNull
    public final ItemInteractionResult interactWith(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        return this.interactWith(player, hand, this.getTank());
    }

    private static final boolean initializeFluidHandler$lambda$0(HTFuelGeneratorBlockEntity this$0, FluidStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Level level = this$0.level;
        if (level == null || (level = level.registryAccess()) == null) {
            return false;
        }
        Level access = level;
        return this$0.getRequiredAmount((RegistryAccess)access, stack) > 0;
    }
}

