/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.block.entity.machine;

import hiiragi283.ragium.api.inventory.HTSlotHelper;
import hiiragi283.ragium.api.recipe.HTSingleInputRecipe;
import hiiragi283.ragium.api.storage.HTAccessConfiguration;
import hiiragi283.ragium.api.storage.HTContentListener;
import hiiragi283.ragium.api.storage.HTStorageAccess;
import hiiragi283.ragium.api.storage.holder.HTItemSlotHolder;
import hiiragi283.ragium.api.storage.item.HTItemSlot;
import hiiragi283.ragium.api.storage.value.HTValueInput;
import hiiragi283.ragium.api.storage.value.HTValueOutput;
import hiiragi283.ragium.common.block.entity.machine.HTProcessorBlockEntity;
import hiiragi283.ragium.common.storage.holder.HTSimpleItemSlotHolder;
import hiiragi283.ragium.common.storage.item.slot.HTItemStackSlot;
import hiiragi283.ragium.common.tier.HTComponentTier;
import hiiragi283.ragium.common.util.HTIngredientHelper;
import hiiragi283.ragium.common.variant.HTMachineVariant;
import hiiragi283.ragium.impl.recipe.manager.HTMultiRecipeCache;
import hiiragi283.ragium.setup.RagiumMenuTypes;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001,B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0018\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\u001a\u0010%\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010#\u001a\u00020$H\u0014J\b\u0010&\u001a\u00020'H\u0002J \u0010(\u001a\u00020)2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010*\u001a\u00020\u0003H\u0014J0\u0010+\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010*\u001a\u00020\u0003H\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lhiiragi283/ragium/common/block/entity/machine/HTMultiSmelterBlockEntity;", "Lhiiragi283/ragium/common/block/entity/machine/HTProcessorBlockEntity;", "Lnet/minecraft/world/item/crafting/SingleRecipeInput;", "Lhiiragi283/ragium/api/recipe/HTSingleInputRecipe;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "inputSlot", "Lhiiragi283/ragium/api/storage/item/HTItemSlot$Mutable;", "outputSlot", "Lhiiragi283/ragium/api/storage/item/HTItemSlot;", "initializeItemHandler", "Lhiiragi283/ragium/api/storage/holder/HTItemSlotHolder;", "listener", "Lhiiragi283/ragium/api/storage/HTContentListener;", "writeValue", "", "output", "Lhiiragi283/ragium/api/storage/value/HTValueOutput;", "readValue", "input", "Lhiiragi283/ragium/api/storage/value/HTValueInput;", "openGui", "Lnet/minecraft/world/InteractionResult;", "player", "Lnet/minecraft/world/entity/player/Player;", "title", "Lnet/minecraft/network/chat/Component;", "baseCache", "Lhiiragi283/ragium/impl/recipe/manager/HTMultiRecipeCache;", "Lnet/minecraft/world/item/crafting/AbstractCookingRecipe;", "createRecipeInput", "level", "Lnet/minecraft/server/level/ServerLevel;", "getMatchedRecipe", "getMaxParallel", "", "canProgressRecipe", "", "recipe", "completeRecipe", "MultiSmeltingRecipe", "ragium"})
public final class HTMultiSmelterBlockEntity
extends HTProcessorBlockEntity<SingleRecipeInput, HTSingleInputRecipe> {
    private HTItemSlot.Mutable inputSlot;
    private HTItemSlot outputSlot;
    @NotNull
    private final HTMultiRecipeCache<SingleRecipeInput, AbstractCookingRecipe> baseCache;

    public HTMultiSmelterBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(HTMachineVariant.MULTI_SMELTER, pos, state);
        RecipeType[] recipeTypeArray = new RecipeType[]{RecipeType.SMELTING, RecipeType.SMOKING, RecipeType.BLASTING};
        this.baseCache = new HTMultiRecipeCache(recipeTypeArray);
    }

    @Override
    @NotNull
    protected HTItemSlotHolder initializeItemHandler(@NotNull HTContentListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.inputSlot = HTItemStackSlot.Companion.input$default(HTItemStackSlot.Companion, listener, HTSlotHelper.getSlotPosX(2), HTSlotHelper.getSlotPosY(0), 0L, null, null, 56, null);
        this.outputSlot = HTItemStackSlot.Companion.output$default(HTItemStackSlot.Companion, listener, HTSlotHelper.getSlotPosX(5.5), HTSlotHelper.getSlotPosY(1), 0L, 8, null);
        HTAccessConfiguration.Holder holder = this;
        HTItemSlot.Mutable mutable = this.inputSlot;
        if (mutable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputSlot");
            mutable = null;
        }
        List list = CollectionsKt.listOf((Object)mutable);
        HTItemSlot hTItemSlot = this.outputSlot;
        if (hTItemSlot == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputSlot");
            hTItemSlot = null;
        }
        return new HTSimpleItemSlotHolder(holder, list, CollectionsKt.listOf((Object)hTItemSlot), null, 8, null);
    }

    @Override
    protected void writeValue(@NotNull HTValueOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        super.writeValue(output);
        this.baseCache.serialize(output);
    }

    @Override
    protected void readValue(@NotNull HTValueInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        super.readValue(input);
        this.baseCache.deserialize(input);
    }

    @Override
    @NotNull
    protected InteractionResult openGui(@NotNull Player player, @NotNull Component title) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        return RagiumMenuTypes.SMELTER.openMenu(player, title, this, (Function1<RegistryFriendlyByteBuf, Unit>)((Function1)new Function1<RegistryFriendlyByteBuf, Unit>((Object)this){

            public final void invoke(RegistryFriendlyByteBuf p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((HTMultiSmelterBlockEntity)this.receiver).writeExtraContainerData(p0);
            }
        }));
    }

    @Override
    @NotNull
    protected SingleRecipeInput createRecipeInput(@NotNull ServerLevel level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        HTItemSlot.Mutable mutable = this.inputSlot;
        if (mutable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputSlot");
            mutable = null;
        }
        return new SingleRecipeInput((ItemStack)mutable.getStack());
    }

    @Override
    @Nullable
    protected HTSingleInputRecipe getMatchedRecipe(@NotNull SingleRecipeInput input, @NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        AbstractCookingRecipe abstractCookingRecipe = (AbstractCookingRecipe)this.baseCache.getFirstRecipe((RecipeInput)input, (Level)level);
        if (abstractCookingRecipe == null) {
            return null;
        }
        AbstractCookingRecipe baseRecipe = abstractCookingRecipe;
        ItemStack itemStack = baseRecipe.assemble(input, (HolderLookup.Provider)level.registryAccess());
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"assemble(...)");
        ItemStack result = itemStack;
        if (result.isEmpty()) {
            return null;
        }
        int resultMaxSize = result.getMaxStackSize();
        HTItemSlot.Mutable mutable = this.inputSlot;
        if (mutable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputSlot");
            mutable = null;
        }
        int n = mutable.getAmountAsInt();
        int n2 = this.getMaxParallel();
        int inputCount = Math.min(n, n2);
        int maxParallel = Math.min(inputCount, this.getMaxParallel());
        int outputCount = result.getCount() * maxParallel;
        if (outputCount > resultMaxSize) {
            outputCount = resultMaxSize - resultMaxSize % maxParallel;
            inputCount = outputCount / maxParallel;
        }
        if (inputCount <= 0 || outputCount <= 0) {
            return null;
        }
        return new MultiSmeltingRecipe(baseRecipe, outputCount);
    }

    private final int getMaxParallel() {
        HTComponentTier hTComponentTier = this.getUpgradeHandler().getTier();
        return switch (hTComponentTier == null ? -1 : WhenMappings.$EnumSwitchMapping$0[hTComponentTier.ordinal()]) {
            case 1 -> 2;
            case 2 -> 4;
            case 3 -> 8;
            case 4 -> 16;
            case 5 -> {
                HTItemSlot.Mutable v2 = this.inputSlot;
                if (v2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"inputSlot");
                    v2 = null;
                }
                yield ((ItemStack)v2.getStack()).getMaxStackSize();
            }
            case -1 -> 1;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    protected boolean canProgressRecipe(@NotNull ServerLevel level, @NotNull SingleRecipeInput input, @NotNull HTSingleInputRecipe recipe) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
        HTItemSlot hTItemSlot = this.outputSlot;
        if (hTItemSlot == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputSlot");
            hTItemSlot = null;
        }
        ItemStack itemStack = recipe.assemble((RecipeInput)input, (HolderLookup.Provider)level.registryAccess());
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"assemble(...)");
        return hTItemSlot.insert(itemStack, true, HTStorageAccess.INTERNAl).isEmpty();
    }

    @Override
    protected void completeRecipe(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull SingleRecipeInput input, @NotNull HTSingleInputRecipe recipe) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
        HTItemSlot hTItemSlot = this.outputSlot;
        if (hTItemSlot == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputSlot");
            hTItemSlot = null;
        }
        ItemStack itemStack = recipe.assemble((RecipeInput)input, (HolderLookup.Provider)level.registryAccess());
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"assemble(...)");
        hTItemSlot.insert(itemStack, false, HTStorageAccess.INTERNAl);
        HTItemSlot.Mutable mutable = this.inputSlot;
        if (mutable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputSlot");
            mutable = null;
        }
        HTIngredientHelper.shrinkStack(mutable, recipe::getRequiredCount, false);
        level.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 1.0f);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\f\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J\f\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lhiiragi283/ragium/common/block/entity/machine/HTMultiSmelterBlockEntity$MultiSmeltingRecipe;", "Lhiiragi283/ragium/api/recipe/HTSingleInputRecipe;", "recipe", "Lnet/minecraft/world/item/crafting/AbstractCookingRecipe;", "count", "", "<init>", "(Lnet/minecraft/world/item/crafting/AbstractCookingRecipe;I)V", "ingredient", "Lnet/minecraft/world/item/crafting/Ingredient;", "getIngredient", "()Lnet/minecraft/world/item/crafting/Ingredient;", "getRequiredCount", "stack", "Lnet/minecraft/world/item/ItemStack;", "test", "", "input", "Lnet/minecraft/world/item/crafting/SingleRecipeInput;", "assemble", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "getSerializer", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "getType", "Lnet/minecraft/world/item/crafting/RecipeType;", "isIncomplete", "ragium"})
    @SourceDebugExtension(value={"SMAP\nHTMultiSmelterBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HTMultiSmelterBlockEntity.kt\nhiiragi283/ragium/common/block/entity/machine/HTMultiSmelterBlockEntity$MultiSmeltingRecipe\n+ 2 ResultExtensions.kt\nhiiragi283/ragium/api/extension/ResultExtensionsKt\n*L\n1#1,135:1\n35#2:136\n35#2:137\n*S KotlinDebug\n*F\n+ 1 HTMultiSmelterBlockEntity.kt\nhiiragi283/ragium/common/block/entity/machine/HTMultiSmelterBlockEntity$MultiSmeltingRecipe\n*L\n128#1:136\n130#1:137\n*E\n"})
    private static final class MultiSmeltingRecipe
    implements HTSingleInputRecipe {
        @NotNull
        private final AbstractCookingRecipe recipe;
        private final int count;

        public MultiSmeltingRecipe(@NotNull AbstractCookingRecipe recipe, int count) {
            Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
            this.recipe = recipe;
            this.count = count;
        }

        private final Ingredient getIngredient() {
            Object object = this.recipe.getIngredients().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return (Ingredient)object;
        }

        @Override
        public int getRequiredCount(@NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            return this.getIngredient().test(stack) ? 1 : 0;
        }

        @Override
        public boolean test(@NotNull SingleRecipeInput input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return this.getIngredient().test(input.item());
        }

        @NotNull
        public ItemStack assemble(@NotNull SingleRecipeInput input, @NotNull HolderLookup.Provider registries) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
            ItemStack itemStack = this.recipe.assemble(input, registries).copyWithCount(this.count);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copyWithCount(...)");
            return itemStack;
        }

        @NotNull
        public RecipeSerializer<?> getSerializer() {
            boolean $i$f$unsupported = false;
            throw new UnsupportedOperationException();
        }

        @NotNull
        public RecipeType<?> getType() {
            boolean $i$f$unsupported = false;
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isIncomplete() {
            ItemStack[] itemStackArray = this.getIngredient().getItems();
            Intrinsics.checkNotNullExpressionValue((Object)itemStackArray, (String)"getItems(...)");
            return ((Object[])itemStackArray).length == 0;
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HTComponentTier.values().length];
            try {
                nArray[HTComponentTier.BASIC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HTComponentTier.ADVANCED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HTComponentTier.ELITE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HTComponentTier.ULTIMATE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HTComponentTier.ETERNAL.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

