/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.item;

import hiiragi283.ragium.api.extension.LevelExtensionsKt;
import hiiragi283.ragium.api.storage.HTStorageAccess;
import hiiragi283.ragium.api.storage.item.HTItemSlot;
import hiiragi283.ragium.common.item.base.HTContainerItem;
import hiiragi283.ragium.setup.RagiumMenuTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0007H\u0016J&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0018"}, d2={"Lhiiragi283/ragium/common/item/HTPotionBundleItem;", "Lhiiragi283/ragium/common/item/base/HTContainerItem;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "finishUsingItem", "Lnet/minecraft/world/item/ItemStack;", "stack", "level", "Lnet/minecraft/world/level/Level;", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "getUseDuration", "", "entity", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "use", "Lnet/minecraft/world/InteractionResultHolder;", "player", "Lnet/minecraft/world/entity/player/Player;", "usedHand", "Lnet/minecraft/world/InteractionHand;", "ragium"})
public final class HTPotionBundleItem
extends HTContainerItem {
    public HTPotionBundleItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Item.Properties properties2 = properties.stacksTo(1);
        Intrinsics.checkNotNullExpressionValue((Object)properties2, (String)"stacksTo(...)");
        super(properties2);
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        for (HTItemSlot slot : HTContainerItem.Companion.getItemSlots(stack)) {
            if (slot.isEmpty()) continue;
            ItemStack stackIn = (ItemStack)slot.getStack();
            ItemStack itemStack = stackIn.finishUsingItem(level, livingEntity);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"finishUsingItem(...)");
            ItemStack result = itemStack;
            if (!livingEntity.hasInfiniteMaterials()) {
                slot.extract(1, false, HTStorageAccess.INTERNAl);
            }
            if (!Intrinsics.areEqual((Object)result, (Object)stackIn)) {
                LevelExtensionsKt.dropStackAt((Entity)livingEntity, result);
            }
            return stack;
        }
        return stack;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return 32;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return UseAnim.DRINK;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        InteractionResultHolder interactionResultHolder;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        ItemStack itemStack = player.getItemInHand(usedHand);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInHand(...)");
        ItemStack stack = itemStack;
        if (stack.isEmpty()) {
            InteractionResultHolder interactionResultHolder2 = InteractionResultHolder.fail((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder2, (String)"fail(...)");
            return interactionResultHolder2;
        }
        if (player.isShiftKeyDown()) {
            interactionResultHolder = new InteractionResultHolder(RagiumMenuTypes.POTION_BUNDLE.openMenu(player, usedHand, stack), (Object)stack);
        } else {
            InteractionResultHolder interactionResultHolder3 = ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)usedHand);
            interactionResultHolder = interactionResultHolder3;
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder3, (String)"startUsingInstantly(...)");
        }
        return interactionResultHolder;
    }
}

