/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.item.base;

import hiiragi283.ragium.api.extension.TextExtensionsKt;
import hiiragi283.ragium.api.storage.HTMultiCapability;
import hiiragi283.ragium.api.storage.HTStorageAccess;
import hiiragi283.ragium.api.storage.energy.HTEnergyBattery;
import hiiragi283.ragium.api.storage.energy.HTEnergyHandler;
import hiiragi283.ragium.common.util.HTItemHelper;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J.\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0018"}, d2={"Lhiiragi283/ragium/common/item/base/HTEnergyItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "isBarVisible", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "getBarWidth", "", "getBarColor", "appendHoverText", "", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "Companion", "User", "ragium"})
public abstract class HTEnergyItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public HTEnergyItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return Companion.hasHandler(stack);
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        HTEnergyBattery hTEnergyBattery = Companion.getBattery(stack);
        if (hTEnergyBattery == null) {
            return 0;
        }
        HTEnergyBattery battery = hTEnergyBattery;
        return MathKt.roundToInt((float)(13.0f * battery.getStoredLevelAsFloat()));
    }

    public int getBarColor(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return 0xFF003F;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        HTEnergyBattery hTEnergyBattery = Companion.getBattery(stack);
        if (hTEnergyBattery == null) {
            return;
        }
        HTEnergyBattery battery = hTEnergyBattery;
        TextExtensionsKt.addEnergyTooltip(battery, p0 -> tooltipComponents.add((Component)p0));
    }

    @JvmStatic
    @Nullable
    public static final HTEnergyHandler getHandler(@NotNull ItemStack stack) {
        return Companion.getHandler(stack);
    }

    @JvmStatic
    public static final boolean hasHandler(@NotNull ItemStack stack) {
        return Companion.hasHandler(stack);
    }

    @JvmStatic
    @Nullable
    public static final HTEnergyBattery getBattery(@NotNull ItemStack stack) {
        return Companion.getBattery(stack);
    }

    @JvmStatic
    public static final int extractEnergy(@NotNull ItemStack stack, int amount, boolean simulate) {
        return Companion.extractEnergy(stack, amount, simulate);
    }

    @JvmStatic
    public static final boolean canConsumeEnergy(@NotNull ItemStack stack, int amount) {
        return Companion.canConsumeEnergy(stack, amount);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\tH\u0007J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\rH\u0007\u00a8\u0006\u0011"}, d2={"Lhiiragi283/ragium/common/item/base/HTEnergyItem$Companion;", "", "<init>", "()V", "getHandler", "Lhiiragi283/ragium/api/storage/energy/HTEnergyHandler;", "stack", "Lnet/minecraft/world/item/ItemStack;", "hasHandler", "", "getBattery", "Lhiiragi283/ragium/api/storage/energy/HTEnergyBattery;", "extractEnergy", "", "amount", "simulate", "canConsumeEnergy", "ragium"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final HTEnergyHandler getHandler(@NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            IEnergyStorage iEnergyStorage = HTMultiCapability.ENERGY.getCapability(stack);
            return iEnergyStorage instanceof HTEnergyHandler ? (HTEnergyHandler)iEnergyStorage : null;
        }

        @JvmStatic
        public final boolean hasHandler(@NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            return this.getHandler(stack) != null;
        }

        @JvmStatic
        @Nullable
        public final HTEnergyBattery getBattery(@NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            HTEnergyHandler hTEnergyHandler = this.getHandler(stack);
            if (hTEnergyHandler == null) {
                return null;
            }
            HTEnergyHandler handler = hTEnergyHandler;
            return handler.getEnergyHandler(handler.getEnergySideFor());
        }

        @JvmStatic
        public final int extractEnergy(@NotNull ItemStack stack, int amount, boolean simulate) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            HTEnergyBattery hTEnergyBattery = this.getBattery(stack);
            return hTEnergyBattery != null ? hTEnergyBattery.extractEnergy(amount, simulate, HTStorageAccess.INTERNAl) : 0;
        }

        @JvmStatic
        public final boolean canConsumeEnergy(@NotNull ItemStack stack, int amount) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            HTEnergyBattery hTEnergyBattery = this.getBattery(stack);
            if (hTEnergyBattery == null) {
                return false;
            }
            HTEnergyBattery battery = hTEnergyBattery;
            return battery.getAmountAsInt() >= HTItemHelper.getFixedUsage(stack, amount);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0004R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lhiiragi283/ragium/common/item/base/HTEnergyItem$User;", "Lhiiragi283/ragium/common/item/base/HTEnergyItem;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "energyUsage", "", "getEnergyUsage", "()I", "canConsumeEnergy", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "ragium"})
    public static abstract class User
    extends HTEnergyItem {
        public User(@NotNull Item.Properties properties) {
            Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
            super(properties);
        }

        protected abstract int getEnergyUsage();

        protected final boolean canConsumeEnergy(@NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            return Companion.canConsumeEnergy(stack, this.getEnergyUsage());
        }
    }
}

