/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.api.extension;

import hiiragi283.ragium.api.extension.FluidExtensionsKt;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\t\u001a\u000e\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u000b\u001a\u0010\u0010\f\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\r\u001a\u000e\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u000f\u001a\u000e\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0011\u001a\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u001a\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00192\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u001a\u000e\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u001b"}, d2={"intText", "Lnet/minecraft/network/chat/MutableComponent;", "value", "", "longText", "", "floatText", "", "doubleText", "", "boolText", "", "stringText", "", "blockPosText", "Lnet/minecraft/core/BlockPos;", "globalPosText", "Lnet/minecraft/core/GlobalPos;", "addFluidTooltip", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "consumer", "Ljava/util/function/Consumer;", "Lnet/minecraft/network/chat/Component;", "Lnet/neoforged/neoforge/fluids/FluidStack;", "fluidCapacityText", "ragium_api"})
public final class TextExtensionsKt {
    @NotNull
    public static final MutableComponent intText(int value) {
        return TextExtensionsKt.longText(value);
    }

    @NotNull
    public static final MutableComponent longText(long value) {
        MutableComponent mutableComponent = Component.literal((String)NumberFormat.getNumberInstance().format(value));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
        return mutableComponent;
    }

    @NotNull
    public static final MutableComponent floatText(float value) {
        return TextExtensionsKt.doubleText(value);
    }

    @NotNull
    public static final MutableComponent doubleText(double value) {
        MutableComponent mutableComponent = Component.literal((String)NumberFormat.getNumberInstance().format(value));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
        return mutableComponent;
    }

    @NotNull
    public static final MutableComponent boolText(boolean value) {
        return TextExtensionsKt.stringText(value);
    }

    @NotNull
    public static final MutableComponent stringText(@Nullable Object value) {
        MutableComponent mutableComponent = Component.literal((String)String.valueOf(value));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
        return mutableComponent;
    }

    @NotNull
    public static final MutableComponent blockPosText(@NotNull BlockPos value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        MutableComponent mutableComponent = Component.literal((String)("[" + value.getX() + ", " + value.getY() + ", " + value.getZ() + "]"));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
        return mutableComponent;
    }

    @NotNull
    public static final MutableComponent globalPosText(@NotNull GlobalPos value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object[] objectArray = new MutableComponent[]{TextExtensionsKt.stringText(value.dimension().location()), TextExtensionsKt.intText(value.pos().getX()), TextExtensionsKt.intText(value.pos().getY()), TextExtensionsKt.intText(value.pos().getZ())};
        MutableComponent mutableComponent = Component.literal((String)"[").append(ComponentUtils.formatList((Collection)CollectionsKt.listOf((Object[])objectArray), (Component)((Component)Component.literal((String)", ")))).append("]");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"append(...)");
        return mutableComponent;
    }

    public static final void addFluidTooltip(@NotNull ItemStack stack, @NotNull Consumer<Component> consumer) {
        int n;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        IFluidHandlerItem iFluidHandlerItem = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (iFluidHandlerItem == null) {
            return;
        }
        IFluidHandlerItem fluidHandler = iFluidHandlerItem;
        IntRange intRange = FluidExtensionsKt.getTankRange((IFluidHandler)fluidHandler);
        int i = intRange.getFirst();
        if (i <= (n = intRange.getLast())) {
            while (true) {
                FluidStack fluidStack = fluidHandler.getFluidInTank(i);
                Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"getFluidInTank(...)");
                TextExtensionsKt.addFluidTooltip(fluidStack, consumer);
                if (i == n) break;
                ++i;
            }
        }
    }

    public static final void addFluidTooltip(@NotNull FluidStack stack, @NotNull Consumer<Component> consumer) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (stack.isEmpty()) {
            return;
        }
        Object[] objectArray = new Object[]{stack.getHoverName().copy().withStyle(ChatFormatting.AQUA), TextExtensionsKt.intText(stack.getAmount()).withStyle(ChatFormatting.GRAY)};
        consumer.accept((Component)Component.translatable((String)"text.ragium.fluid_name", (Object[])objectArray).withStyle(ChatFormatting.GRAY));
    }

    @NotNull
    public static final MutableComponent fluidCapacityText(int value) {
        Object[] objectArray = new Object[]{TextExtensionsKt.intText(value).withStyle(ChatFormatting.YELLOW)};
        MutableComponent mutableComponent = Component.translatable((String)"text.ragium.fluid_capacity", (Object[])objectArray).withStyle(ChatFormatting.GRAY);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
        return mutableComponent;
    }
}

