/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.api.storage.fluid;

import hiiragi283.ragium.api.storage.fluid.HTFluidFilter;
import hiiragi283.ragium.api.storage.fluid.HTFluidHandler;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lhiiragi283/ragium/api/storage/fluid/HTFilteredFluidHandler;", "Lhiiragi283/ragium/api/storage/fluid/HTFluidHandler;", "delegate", "", "Lnet/neoforged/neoforge/fluids/capability/templates/FluidTank;", "filter", "Lhiiragi283/ragium/api/storage/fluid/HTFluidFilter;", "<init>", "(Ljava/util/List;Lhiiragi283/ragium/api/storage/fluid/HTFluidFilter;)V", "interactWith", "Lnet/minecraft/world/ItemInteractionResult;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "getTanks", "", "getFluidInTank", "Lnet/neoforged/neoforge/fluids/FluidStack;", "tank", "getTankCapacity", "isFluidValid", "", "stack", "fill", "resource", "action", "Lnet/neoforged/neoforge/fluids/capability/IFluidHandler$FluidAction;", "drain", "maxDrain", "ragium_api"})
public final class HTFilteredFluidHandler
implements HTFluidHandler {
    @NotNull
    private final List<FluidTank> delegate;
    @NotNull
    private final HTFluidFilter filter;

    public HTFilteredFluidHandler(@NotNull List<? extends FluidTank> delegate, @NotNull HTFluidFilter filter) {
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        this.delegate = delegate;
        this.filter = filter;
    }

    @Override
    @NotNull
    public ItemInteractionResult interactWith(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Iterator iterator = CollectionsKt.reversed((Iterable)CollectionsKt.toList((Iterable)((Iterable)this.getTankRange()))).iterator();
        while (iterator.hasNext()) {
            int index = ((Number)iterator.next()).intValue();
            FluidTank tank2 = this.delegate.get(index);
            if (!FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)((IFluidHandler)tank2))) continue;
            ItemInteractionResult itemInteractionResult = ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            Intrinsics.checkNotNullExpressionValue((Object)itemInteractionResult, (String)"sidedSuccess(...)");
            return itemInteractionResult;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public int getTanks() {
        return this.delegate.size();
    }

    @NotNull
    public FluidStack getFluidInTank(int tank2) {
        FluidStack fluidStack = this.delegate.get(tank2).getFluid();
        Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"getFluid(...)");
        return fluidStack;
    }

    public int getTankCapacity(int tank2) {
        return this.delegate.get(tank2).getCapacity();
    }

    public boolean isFluidValid(int tank2, @NotNull FluidStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return this.delegate.get(tank2).isFluidValid(stack);
    }

    public int fill(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        if (!this.filter.canFill(this.delegate, resource)) {
            return 0;
        }
        for (FluidTank tank2 : this.delegate) {
            int filled = tank2.fill(resource, action);
            if (filled <= 0) continue;
            return filled;
        }
        return 0;
    }

    @NotNull
    public FluidStack drain(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        if (!this.filter.canDrain(this.delegate, resource)) {
            FluidStack fluidStack = FluidStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"EMPTY");
            return fluidStack;
        }
        for (FluidTank tank2 : this.delegate) {
            FluidStack drained;
            Intrinsics.checkNotNullExpressionValue((Object)tank2.drain(resource, action), (String)"drain(...)");
            if (drained.isEmpty()) continue;
            return drained;
        }
        FluidStack fluidStack = FluidStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"EMPTY");
        return fluidStack;
    }

    @NotNull
    public FluidStack drain(int maxDrain, @NotNull IFluidHandler.FluidAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        if (!this.filter.canDrain(this.delegate, maxDrain)) {
            FluidStack fluidStack = FluidStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"EMPTY");
            return fluidStack;
        }
        for (FluidTank tank2 : this.delegate) {
            FluidStack drained;
            Intrinsics.checkNotNullExpressionValue((Object)tank2.drain(maxDrain, action), (String)"drain(...)");
            if (drained.isEmpty()) continue;
            return drained;
        }
        FluidStack fluidStack = FluidStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"EMPTY");
        return fluidStack;
    }
}

