/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.client;

import com.mojang.logging.LogUtils;
import hiiragi283.ragium.api.RagiumAPI;
import hiiragi283.ragium.api.extension.RegistryExtensionsKt;
import hiiragi283.ragium.api.inventory.HTDefinitionContainerMenu;
import hiiragi283.ragium.api.registry.HTDeferredMenuType;
import hiiragi283.ragium.api.registry.HTFluidContent;
import hiiragi283.ragium.client.HTSimpleFluidExtensions;
import hiiragi283.ragium.client.renderer.HTChargerRenderer;
import hiiragi283.ragium.client.screen.HTBasicMachineScreen;
import hiiragi283.ragium.client.screen.HTEnergyNetworkAccessScreen;
import hiiragi283.ragium.client.screen.HTItemCollectorScreen;
import hiiragi283.ragium.setup.RagiumBlockEntityTypes;
import hiiragi283.ragium.setup.RagiumBlocks;
import hiiragi283.ragium.setup.RagiumFluidContents;
import hiiragi283.ragium.setup.RagiumMenuTypes;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.model.DynamicFluidContainerModel;
import net.neoforged.neoforge.fluids.CauldronFluidContent;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Mod(value="ragium", dist={Dist.CLIENT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0015H\u0002\u00a8\u0006\u0017"}, d2={"Lhiiragi283/ragium/client/RagiumClient;", "", "eventBus", "Lnet/neoforged/bus/api/IEventBus;", "container", "Lnet/neoforged/fml/ModContainer;", "<init>", "(Lnet/neoforged/bus/api/IEventBus;Lnet/neoforged/fml/ModContainer;)V", "registerBlockColor", "", "event", "Lnet/neoforged/neoforge/client/event/RegisterColorHandlersEvent$Block;", "registerItemColor", "Lnet/neoforged/neoforge/client/event/RegisterColorHandlersEvent$Item;", "registerClientExtensions", "Lnet/neoforged/neoforge/client/extensions/common/RegisterClientExtensionsEvent;", "registerScreens", "Lnet/neoforged/neoforge/client/event/RegisterMenuScreensEvent;", "registerEntityRenderer", "Lnet/neoforged/neoforge/client/event/EntityRenderersEvent$RegisterRenderers;", "registerTooltipRenderer", "Lnet/neoforged/neoforge/client/event/RegisterClientTooltipComponentFactoriesEvent;", "Companion", "ragium"})
public final class RagiumClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOGGER;

    public RagiumClient(@NotNull IEventBus eventBus, @NotNull ModContainer container) {
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        eventBus.addListener(this::registerBlockColor);
        eventBus.addListener(this::registerItemColor);
        eventBus.addListener(this::registerClientExtensions);
        eventBus.addListener(this::registerScreens);
        eventBus.addListener(this::registerEntityRenderer);
        eventBus.addListener(this::registerTooltipRenderer);
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    private final void registerBlockColor(RegisterColorHandlersEvent.Block event) {
        Object object = new Block[]{RagiumBlocks.EXP_BERRY_BUSH.get()};
        event.register(RagiumClient::registerBlockColor$lambda$0, (Block[])object);
        object = new Block[]{RagiumBlocks.WATER_COLLECTOR.get()};
        event.register(RagiumClient::registerBlockColor$lambda$1, (Block[])object);
        for (DeferredBlock deferredBlock : RagiumBlocks.CAULDRONS) {
            Block[] blockArray = new Block[]{deferredBlock.get()};
            event.register(RagiumClient::registerBlockColor$lambda$2, blockArray);
        }
        LOGGER.info("Registered BlockColor!");
    }

    private final void registerItemColor(RegisterColorHandlersEvent.Item event) {
        ItemLike[] itemLikeArray = new ItemLike[]{RagiumBlocks.WATER_COLLECTOR};
        event.register(RagiumClient::registerItemColor$lambda$3, itemLikeArray);
        for (DeferredItem deferredItem : RagiumFluidContents.REGISTER.getItemEntries()) {
            ItemLike[] itemLikeArray2 = new ItemLike[]{deferredItem};
            event.register((ItemColor)new DynamicFluidContainerModel.Colors(), itemLikeArray2);
        }
        LOGGER.info("Registered ItemColor!");
    }

    private final void registerClientExtensions(RegisterClientExtensionsEvent event) {
        FluidType[] fluidTypeArray = new FluidType[]{RagiumFluidContents.HONEY.getType()};
        event.registerFluidType((IClientFluidTypeExtensions)new HTSimpleFluidExtensions(RegistryExtensionsKt.vanillaId("block/honey_block_top"), null, null, 6, null), fluidTypeArray);
        RagiumClient.registerClientExtensions$register(event, RagiumFluidContents.EXPERIENCE, new Color(0x66FF33));
        RagiumClient.registerClientExtensions$register(event, RagiumFluidContents.CHOCOLATE, new Color(0x663333));
        RagiumClient.registerClientExtensions$register(event, RagiumFluidContents.MUSHROOM_STEW, new Color(0xCC9966));
        RagiumClient.registerClientExtensions$register(event, RagiumFluidContents.INSTANCE.getCRUDE_OIL(), new Color(0x333333));
        RagiumClient.registerClientExtensions$register(event, RagiumFluidContents.INSTANCE.getLPG(), new Color(0xFFCC99));
        RagiumClient.registerClientExtensions$register(event, RagiumFluidContents.INSTANCE.getNAPHTHA(), new Color(0xFF9900));
        RagiumClient.registerClientExtensions$register(event, RagiumFluidContents.INSTANCE.getLIGHT_FUEL(), new Color(0xFFFF00));
        RagiumClient.registerClientExtensions$register(event, RagiumFluidContents.INSTANCE.getHEAVY_FUEL(), new Color(0xFF6600));
        RagiumClient.registerClientExtensions$register(event, RagiumFluidContents.INSTANCE.getDIESEL(), new Color(0xFF3300));
        RagiumClient.registerClientExtensions$register(event, RagiumFluidContents.INSTANCE.getLUBRICANT(), new Color(0xFF9900));
        RagiumClient.registerClientExtensions$register(event, RagiumFluidContents.INSTANCE.getSAP(), new Color(0x996633));
        RagiumClient.registerClientExtensions$register(event, RagiumFluidContents.CRIMSON_SAP, new Color(0x660000));
        RagiumClient.registerClientExtensions$register(event, RagiumFluidContents.WARPED_SAP, new Color(26214));
        RagiumClient.registerClientExtensions$register(event, RagiumFluidContents.ELDRITCH_GOO, new Color(0x6633CC));
        LOGGER.info("Registered client extensions!");
    }

    private final void registerScreens(RegisterMenuScreensEvent event) {
        RagiumClient.registerScreens$registerBasic(event, RagiumMenuTypes.ALLOY_SMELTER, RagiumAPI.Companion.id("textures/gui/container/alloy_smelter.png"));
        RagiumClient.registerScreens$registerBasic(event, RagiumMenuTypes.BLOCK_BREAKER, RagiumAPI.Companion.id("textures/gui/container/block_breaker.png"));
        RagiumClient.registerScreens$registerBasic(event, RagiumMenuTypes.CRUSHER, RagiumAPI.Companion.id("textures/gui/container/crusher.png"));
        RagiumClient.registerScreens$registerBasic(event, RagiumMenuTypes.EXTRACTOR, RagiumAPI.Companion.id("textures/gui/container/extractor.png"));
        RagiumClient.registerScreens$registerBasic(event, RagiumMenuTypes.FLUID_COLLECTOR, RagiumAPI.Companion.id("textures/gui/container/fluid_collector.png"));
        RagiumClient.registerScreens$registerBasic(event, RagiumMenuTypes.MELTER, RagiumAPI.Companion.id("textures/gui/container/melter.png"));
        event.register((MenuType)RagiumMenuTypes.ITEM_COLLECTOR.get(), HTItemCollectorScreen::new);
        event.register((MenuType)RagiumMenuTypes.ENERGY_NETWORK_ACCESS.get(), HTEnergyNetworkAccessScreen::new);
        LOGGER.info("Registered Screens!");
    }

    private final void registerEntityRenderer(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)RagiumBlockEntityTypes.CHARGER.get(), HTChargerRenderer::new);
        LOGGER.info("Registered BlockEntityRenderers!");
    }

    private final void registerTooltipRenderer(RegisterClientTooltipComponentFactoriesEvent event) {
        LOGGER.info("Registered ClientTooltipComponents!");
    }

    private static final int registerBlockColor$lambda$0(BlockState state, BlockAndTintGetter getter, BlockPos pos, int tint) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (tint != 0) {
            return -1;
        }
        return getter != null && pos != null ? BiomeColors.getAverageFoliageColor((BlockAndTintGetter)getter, (BlockPos)pos) : FoliageColor.getDefaultColor();
    }

    private static final int registerBlockColor$lambda$1(BlockState state, BlockAndTintGetter getter, BlockPos pos, int tint) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (tint != 0) {
            return -1;
        }
        if (getter != null && pos != null) {
            return BiomeColors.getAverageWaterColor((BlockAndTintGetter)getter, (BlockPos)pos);
        }
        return -1;
    }

    private static final int registerBlockColor$lambda$2(BlockState state, BlockAndTintGetter getter, BlockPos pos, int tint) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        CauldronFluidContent cauldronFluidContent = CauldronFluidContent.getForBlock((Block)state.getBlock());
        if (cauldronFluidContent == null) {
            return -1;
        }
        CauldronFluidContent content = cauldronFluidContent;
        return getter != null && pos != null ? IClientFluidTypeExtensions.of((Fluid)content.fluid).getTintColor(state.getFluidState(), getter, pos) : -1;
    }

    private static final int registerItemColor$lambda$3(ItemStack stack, int tint) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return tint == 0 ? 4159204 : -1;
    }

    private static final void registerClientExtensions$register(RegisterClientExtensionsEvent $event, HTFluidContent<?, ?, ?> content, Color color) {
        FluidType[] fluidTypeArray = new FluidType[]{content.getType()};
        $event.registerFluidType((IClientFluidTypeExtensions)new HTSimpleFluidExtensions(color), fluidTypeArray);
    }

    private static final void registerScreens$registerBasic(RegisterMenuScreensEvent $event, HTDeferredMenuType<? extends HTDefinitionContainerMenu> menuType, ResourceLocation texture) {
        $event.register((MenuType)menuType.get(), HTBasicMachineScreen.Companion.create(texture));
    }

    static {
        Logger logger = LogUtils.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u00a8\u0006\u0007"}, d2={"Lhiiragi283/ragium/client/RagiumClient$Companion;", "", "<init>", "()V", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER$annotations", "ragium"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLOGGER$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

