/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.block;

import com.mojang.serialization.MapCodec;
import hiiragi283.ragium.api.extension.LevelExtensionsKt;
import hiiragi283.ragium.setup.RagiumItems;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 /2\u00020\u00012\u00020\u0002:\u0001/B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nJ \u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0014J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J@\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0014J0\u0010%\u001a\u00020&2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010#\u001a\u00020$H\u0014J\u001c\u0010'\u001a\u00020\u00162\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\n0)H\u0014J \u0010+\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020,2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010-\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010.\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u00060"}, d2={"Lhiiragi283/ragium/common/block/HTExpBerriesBushBlock;", "Lnet/minecraft/world/level/block/BushBlock;", "Lnet/minecraft/world/level/block/BonemealableBlock;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "getAge", "", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "isMaxAge", "", "mayPlaceOn", "level", "Lnet/minecraft/world/level/BlockGetter;", "pos", "Lnet/minecraft/core/BlockPos;", "codec", "Lcom/mojang/serialization/MapCodec;", "isRandomlyTicking", "randomTick", "", "Lnet/minecraft/server/level/ServerLevel;", "random", "Lnet/minecraft/util/RandomSource;", "useItemOn", "Lnet/minecraft/world/ItemInteractionResult;", "stack", "Lnet/minecraft/world/item/ItemStack;", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "useWithoutItem", "Lnet/minecraft/world/InteractionResult;", "createBlockStateDefinition", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "isValidBonemealTarget", "Lnet/minecraft/world/level/LevelReader;", "isBonemealSuccess", "performBonemeal", "Companion", "ragium"})
public final class HTExpBerriesBushBlock
extends BushBlock
implements BonemealableBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final IntegerProperty AGE;
    public static final int MAX_AGE = 3;

    public HTExpBerriesBushBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public final int getAge(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Comparable comparable = state.getValue((Property)AGE);
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        return ((Number)((Object)comparable)).intValue();
    }

    public final boolean isMaxAge(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.getAge(state) >= 3;
    }

    protected boolean mayPlaceOn(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return super.mayPlaceOn(state, level, pos) || state.is((Block)this);
    }

    @NotNull
    protected MapCodec<? extends BushBlock> codec() {
        throw new UnsupportedOperationException();
    }

    protected boolean isRandomlyTicking(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return !this.isMaxAge(state);
    }

    protected void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        int age = this.getAge(state);
        if (!this.isMaxAge(state) && CommonHooks.canCropGrow((Level)((Level)level), (BlockPos)pos, (BlockState)state, (random.nextInt(5) == 0 ? 1 : 0) != 0)) {
            Object object = state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
            BlockState newState = (BlockState)object;
            level.setBlock(pos, newState, 2);
            CommonHooks.fireCropGrowPost((Level)((Level)level), (BlockPos)pos, (BlockState)state);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)newState));
        }
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        ItemInteractionResult itemInteractionResult;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        if (!this.isMaxAge(state) && stack.is(Tags.Items.FERTILIZERS)) {
            itemInteractionResult = ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        } else {
            ItemInteractionResult itemInteractionResult2 = super.useItemOn(stack, state, level, pos, player, hand, hitResult);
            itemInteractionResult = itemInteractionResult2;
            Intrinsics.checkNotNullExpressionValue((Object)itemInteractionResult2, (String)"useItemOn(...)");
        }
        return itemInteractionResult;
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        boolean isMaxAge = this.isMaxAge(state);
        if (this.getAge(state) > 1) {
            int count = 1 + level.random.nextInt(2);
            Entity entity = (Entity)player;
            ItemStack itemStack = RagiumItems.EXP_BERRIES.toStack(count + (isMaxAge ? 1 : 0));
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"toStack(...)");
            LevelExtensionsKt.dropStackAt(entity, itemStack);
            level.playSound(null, pos, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS);
            Object object = state.setValue((Property)AGE, (Comparable)Integer.valueOf(1));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
            BlockState newState = (BlockState)object;
            level.setBlock(pos, newState, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)((Entity)player), (BlockState)newState));
            InteractionResult interactionResult = InteractionResult.sidedSuccess((boolean)level.isClientSide);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"sidedSuccess(...)");
            return interactionResult;
        }
        InteractionResult interactionResult = super.useWithoutItem(state, level, pos, player, hitResult);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useWithoutItem(...)");
        return interactionResult;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{AGE};
        builder.add(propertyArray);
    }

    public boolean isValidBonemealTarget(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return !this.isMaxAge(state);
    }

    public boolean isBonemealSuccess(@NotNull Level level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return true;
    }

    public void performBonemeal(@NotNull ServerLevel level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        int age = Math.min(3, this.getAge(state) + 1);
        Object object = state.setValue((Property)AGE, (Comparable)Integer.valueOf(age));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        BlockState newState = (BlockState)object;
        level.setBlock(pos, newState, 2);
    }

    static {
        IntegerProperty integerProperty = BlockStateProperties.AGE_3;
        Intrinsics.checkNotNullExpressionValue((Object)integerProperty, (String)"AGE_3");
        AGE = integerProperty;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lhiiragi283/ragium/common/block/HTExpBerriesBushBlock$Companion;", "", "<init>", "()V", "AGE", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "MAX_AGE", "", "ragium"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

