/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.block;

import hiiragi283.ragium.api.extension.LevelExtensionsKt;
import hiiragi283.ragium.common.block.HTBlockStateProperties;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 32\u00020\u0001:\u00013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH&J\b\u0010\f\u001a\u00020\rH&J8\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0014J@\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0014J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u000fH&J \u0010%\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020&2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010'\u001a\u0004\u0018\u00010\u000f2\u0006\u0010(\u001a\u00020)J\u001c\u0010*\u001a\u00020+2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000f0-H\u0004J\u0010\u0010.\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u000fH\u0004J \u0010/\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0004J\u0018\u00100\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u00101\u001a\u000202H\u0004R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u00064"}, d2={"Lhiiragi283/ragium/common/block/HTFeastBlock;", "Lnet/minecraft/world/level/block/Block;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "hasLeftovers", "", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;Z)V", "getHasLeftovers", "()Z", "getServingsProperty", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "getMaxServings", "", "updateShape", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "direction", "Lnet/minecraft/core/Direction;", "neighborState", "level", "Lnet/minecraft/world/level/LevelAccessor;", "pos", "Lnet/minecraft/core/BlockPos;", "neighborPos", "useItemOn", "Lnet/minecraft/world/ItemInteractionResult;", "stack", "Lnet/minecraft/world/item/ItemStack;", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "getServingItem", "canSurvive", "Lnet/minecraft/world/level/LevelReader;", "getStateForPlacement", "context", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "hasAnalogOutputSignal", "getAnalogOutputSignal", "isPathfindable", "pathComputationType", "Lnet/minecraft/world/level/pathfinder/PathComputationType;", "Companion", "ragium"})
public abstract class HTFeastBlock
extends Block {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hasLeftovers;
    @JvmField
    @NotNull
    public static final DirectionProperty HORIZONTAL = HTBlockStateProperties.HORIZONTAL;

    public HTFeastBlock(@NotNull BlockBehaviour.Properties properties, boolean hasLeftovers) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.hasLeftovers = hasLeftovers;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HORIZONTAL, (Comparable)Direction.NORTH)).setValue((Property)this.getServingsProperty(), (Comparable)Integer.valueOf(this.getMaxServings())));
    }

    public final boolean getHasLeftovers() {
        return this.hasLeftovers;
    }

    @NotNull
    public abstract IntegerProperty getServingsProperty();

    public abstract int getMaxServings();

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        BlockState blockState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        if (direction == Direction.DOWN && !state.canSurvive((LevelReader)level, pos)) {
            BlockState blockState2 = Blocks.AIR.defaultBlockState();
            Intrinsics.checkNotNull((Object)blockState2);
            blockState = blockState2;
        } else {
            BlockState blockState3 = super.updateShape(state, direction, neighborState, level, pos, neighborPos);
            Intrinsics.checkNotNull((Object)blockState3);
            blockState = blockState3;
        }
        return blockState;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        Comparable comparable = state.getValue((Property)this.getServingsProperty());
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        int servings = ((Number)((Object)comparable)).intValue();
        if (servings == 0) {
            level.destroyBlock(pos, true);
            ItemInteractionResult itemInteractionResult = ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            Intrinsics.checkNotNullExpressionValue((Object)itemInteractionResult, (String)"sidedSuccess(...)");
            return itemInteractionResult;
        }
        ItemStack servingStack = this.getServingItem(state);
        ItemStack itemStack = player.getItemInHand(hand);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInHand(...)");
        ItemStack heldStack = itemStack;
        if (servings > 0) {
            boolean bool1 = !servingStack.hasCraftingRemainingItem();
            boolean bool2 = ItemStack.isSameItem((ItemStack)heldStack, (ItemStack)servingStack.getCraftingRemainingItem());
            if (bool1 || bool2) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)this.getServingsProperty(), (Comparable)Integer.valueOf(servings - 1)));
                heldStack.consume(1, (LivingEntity)player);
                LevelExtensionsKt.dropStackAt((Entity)player, servingStack);
                Integer n = (Integer)level.getBlockState(pos).getValue((Property)this.getServingsProperty());
                if (n != null && n == 0 && !this.hasLeftovers) {
                    level.removeBlock(pos, false);
                }
                level.playSound(null, pos, (SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
                ItemInteractionResult itemInteractionResult = ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                Intrinsics.checkNotNullExpressionValue((Object)itemInteractionResult, (String)"sidedSuccess(...)");
                return itemInteractionResult;
            }
        }
        ItemInteractionResult itemInteractionResult = super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        Intrinsics.checkNotNullExpressionValue((Object)itemInteractionResult, (String)"useItemOn(...)");
        return itemInteractionResult;
    }

    @NotNull
    public abstract ItemStack getServingItem(@NotNull BlockState var1);

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return level.getBlockState(pos.below()).isSolid();
    }

    @Nullable
    public final BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (BlockState)this.defaultBlockState().setValue((Property)HORIZONTAL, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected final void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{HORIZONTAL, this.getServingsProperty()};
        builder.add(propertyArray);
    }

    protected final boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return true;
    }

    protected final int getAnalogOutputSignal(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Comparable comparable = state.getValue((Property)this.getServingsProperty());
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        return ((Number)((Object)comparable)).intValue();
    }

    protected final boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType pathComputationType) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)pathComputationType, (String)"pathComputationType");
        return false;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lhiiragi283/ragium/common/block/HTFeastBlock$Companion;", "", "<init>", "()V", "HORIZONTAL", "Lnet/minecraft/world/level/block/state/properties/DirectionProperty;", "ragium"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

