/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.block.entity;

import hiiragi283.ragium.api.RagiumAPI;
import hiiragi283.ragium.api.network.HTNbtCodec;
import hiiragi283.ragium.api.storage.item.HTFilteredItemHandler;
import hiiragi283.ragium.api.storage.item.HTItemFilter;
import hiiragi283.ragium.common.block.entity.HTTickAwareBlockEntity;
import hiiragi283.ragium.common.storage.item.HTItemStackHandler;
import hiiragi283.ragium.setup.RagiumBlockEntityTypes;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J@\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J0\u0010\u001f\u001a\u00020 2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J0\u0010!\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020$H\u0016J \u0010%\u001a\u00020&2\u0006\u0010\u0017\u001a\u00020'2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0006\u0010,\u001a\u00020$J\u0014\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u000100H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010(\u001a\u00020)X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+\u00a8\u00061"}, d2={"Lhiiragi283/ragium/common/block/entity/HTChargerBlockEntity;", "Lhiiragi283/ragium/common/block/entity/HTTickAwareBlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "inventory", "Lhiiragi283/ragium/common/storage/item/HTItemStackHandler;", "stack", "Lnet/minecraft/world/item/ItemStack;", "getStack", "()Lnet/minecraft/world/item/ItemStack;", "writeNbt", "", "writer", "Lhiiragi283/ragium/api/network/HTNbtCodec$Writer;", "readNbt", "reader", "Lhiiragi283/ragium/api/network/HTNbtCodec$Reader;", "onRightClickedWithItem", "Lnet/minecraft/world/ItemInteractionResult;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "onRightClicked", "Lnet/minecraft/world/InteractionResult;", "onRemove", "newState", "movedByPiston", "", "onServerTick", "Lnet/neoforged/neoforge/common/util/TriState;", "Lnet/minecraft/server/level/ServerLevel;", "maxTicks", "", "getMaxTicks", "()I", "canCharge", "getItemHandler", "Lnet/neoforged/neoforge/items/IItemHandler;", "direction", "Lnet/minecraft/core/Direction;", "ragium"})
public final class HTChargerBlockEntity
extends HTTickAwareBlockEntity {
    @NotNull
    private final HTItemStackHandler inventory;
    private final int maxTicks;

    public HTChargerBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(RagiumBlockEntityTypes.CHARGER, pos, state);
        this.inventory = new HTItemStackHandler(1, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ((HTChargerBlockEntity)this.receiver).setChanged();
            }
        }));
        this.maxTicks = 20;
    }

    @NotNull
    public final ItemStack getStack() {
        ItemStack itemStack = this.inventory.getStackInSlot(0);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getStackInSlot(...)");
        return itemStack;
    }

    @Override
    public void writeNbt(@NotNull HTNbtCodec.Writer writer2) {
        Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
        writer2.write("inventory", (INBTSerializable<CompoundTag>)((INBTSerializable)this.inventory));
    }

    @Override
    public void readNbt(@NotNull HTNbtCodec.Reader reader2) {
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        reader2.read("inventory", (INBTSerializable<CompoundTag>)((INBTSerializable)this.inventory));
    }

    @Override
    @NotNull
    public ItemInteractionResult onRightClickedWithItem(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        this.inventory.dropStacksAt((Entity)player);
        this.inventory.setStackInSlot(0, stack.copyWithCount(1));
        stack.shrink(1);
        ItemInteractionResult itemInteractionResult = ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        Intrinsics.checkNotNullExpressionValue((Object)itemInteractionResult, (String)"sidedSuccess(...)");
        return itemInteractionResult;
    }

    @Override
    @NotNull
    public InteractionResult onRightClicked(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        this.inventory.dropStacksAt((Entity)player);
        InteractionResult interactionResult = InteractionResult.sidedSuccess((boolean)level.isClientSide);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"sidedSuccess(...)");
        return interactionResult;
    }

    @Override
    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        super.onRemove(state, level, pos, newState, movedByPiston);
        this.inventory.dropStacksAt(level, pos);
    }

    @Override
    @NotNull
    public TriState onServerTick(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state) {
        int actualReceive;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!this.canProcess()) {
            return TriState.DEFAULT;
        }
        IEnergyStorage network2 = RagiumAPI.Companion.getInstance().getEnergyNetworkManager().getNetworkFromServer(level);
        if (this.inventory.isEmpty()) {
            return TriState.FALSE;
        }
        ItemStack stack = this.getStack();
        IEnergyStorage iEnergyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (iEnergyStorage == null) {
            return TriState.FALSE;
        }
        IEnergyStorage energyStorage = iEnergyStorage;
        int mayReceive = energyStorage.receiveEnergy(1600, true);
        if (mayReceive > 0 && (actualReceive = network2.extractEnergy(mayReceive, true)) > 0) {
            energyStorage.receiveEnergy(actualReceive, false);
            network2.extractEnergy(actualReceive, false);
            return TriState.TRUE;
        }
        return TriState.FALSE;
    }

    @Override
    public int getMaxTicks() {
        return this.maxTicks;
    }

    public final boolean canCharge() {
        if (this.inventory.isEmpty()) {
            return false;
        }
        ItemStack stack = this.getStack();
        IEnergyStorage iEnergyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (iEnergyStorage == null) {
            return false;
        }
        IEnergyStorage energyStorage = iEnergyStorage;
        return energyStorage.receiveEnergy(1600, true) > 0;
    }

    @Override
    @Nullable
    public IItemHandler getItemHandler(@Nullable Direction direction) {
        return new HTFilteredItemHandler(this.inventory, new HTItemFilter(){

            public boolean canInsert(IItemHandler handler, int slot, ItemStack stack) {
                Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                if (slot != 0) {
                    return false;
                }
                IEnergyStorage iEnergyStorage = (IEnergyStorage)handler.getStackInSlot(slot).getCapability(Capabilities.EnergyStorage.ITEM);
                if (iEnergyStorage == null) {
                    return false;
                }
                IEnergyStorage energyStorage = iEnergyStorage;
                return energyStorage.getEnergyStored() < energyStorage.getMaxEnergyStored();
            }

            public boolean canExtract(IItemHandler handler, int slot, int amount) {
                Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
                if (slot != 0) {
                    return false;
                }
                IEnergyStorage iEnergyStorage = (IEnergyStorage)handler.getStackInSlot(slot).getCapability(Capabilities.EnergyStorage.ITEM);
                if (iEnergyStorage == null) {
                    return false;
                }
                IEnergyStorage energyStorage = iEnergyStorage;
                return energyStorage.getEnergyStored() == energyStorage.getMaxEnergyStored();
            }
        });
    }
}

