/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.block.entity;

import hiiragi283.ragium.api.RagiumAPI;
import hiiragi283.ragium.api.network.HTNbtCodec;
import hiiragi283.ragium.api.registry.HTDeferredBlockEntityType;
import hiiragi283.ragium.api.storage.HTStorageIO;
import hiiragi283.ragium.api.storage.item.HTItemHandler;
import hiiragi283.ragium.common.block.entity.HTTickAwareBlockEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J0\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010$\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020&2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J(\u0010$\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020&2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010'\u001a\u00020(H$J\u0010\u0010-\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0014\u0010.\u001a\u0004\u0018\u00010(2\b\u0010/\u001a\u0004\u0018\u000100H\u0016J\u0006\u00101\u001a\u000202R\u0012\u0010\u000b\u001a\u00020\fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u001c\u001a\u00020\u001dX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0012\u0010 \u001a\u00020\u001dX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001fR\u0014\u0010\"\u001a\u00020\u001d8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001fR\"\u0010'\u001a\u0004\u0018\u00010(2\b\u0010)\u001a\u0004\u0018\u00010(@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0010\u0010,\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lhiiragi283/ragium/common/block/entity/HTMachineBlockEntity;", "Lhiiragi283/ragium/common/block/entity/HTTickAwareBlockEntity;", "Lnet/minecraft/world/MenuProvider;", "type", "Lhiiragi283/ragium/api/registry/HTDeferredBlockEntityType;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lhiiragi283/ragium/api/registry/HTDeferredBlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "inventory", "Lhiiragi283/ragium/api/storage/item/HTItemHandler;", "getInventory", "()Lhiiragi283/ragium/api/storage/item/HTItemHandler;", "writeNbt", "", "writer", "Lhiiragi283/ragium/api/network/HTNbtCodec$Writer;", "readNbt", "reader", "Lhiiragi283/ragium/api/network/HTNbtCodec$Reader;", "onRemove", "level", "Lnet/minecraft/world/level/Level;", "newState", "movedByPiston", "", "maxTicks", "", "getMaxTicks", "()I", "energyUsage", "getEnergyUsage", "requiredEnergy", "getRequiredEnergy", "onServerTick", "Lnet/neoforged/neoforge/common/util/TriState;", "Lnet/minecraft/server/level/ServerLevel;", "network", "Lnet/neoforged/neoforge/energy/IEnergyStorage;", "value", "getNetwork", "()Lnet/neoforged/neoforge/energy/IEnergyStorage;", "externalNetwork", "afterLevelInit", "getEnergyStorage", "direction", "Lnet/minecraft/core/Direction;", "getDisplayName", "Lnet/minecraft/network/chat/Component;", "ragium"})
public abstract class HTMachineBlockEntity
extends HTTickAwareBlockEntity
implements MenuProvider {
    private final int maxTicks;
    @Nullable
    private IEnergyStorage network;
    @Nullable
    private IEnergyStorage externalNetwork;

    public HTMachineBlockEntity(@NotNull HTDeferredBlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
        this.maxTicks = 200;
    }

    @NotNull
    protected abstract HTItemHandler getInventory();

    @Override
    public void writeNbt(@NotNull HTNbtCodec.Writer writer2) {
        Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
        writer2.write("inventory", (INBTSerializable<CompoundTag>)((INBTSerializable)this.getInventory()));
    }

    @Override
    public void readNbt(@NotNull HTNbtCodec.Reader reader2) {
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        reader2.read("inventory", (INBTSerializable<CompoundTag>)((INBTSerializable)this.getInventory()));
    }

    @Override
    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        super.onRemove(state, level, pos, newState, movedByPiston);
        this.getInventory().dropStacksAt(level, pos);
    }

    @Override
    public int getMaxTicks() {
        return this.maxTicks;
    }

    protected abstract int getEnergyUsage();

    protected final int getRequiredEnergy() {
        return this.getEnergyUsage() * this.getMaxTicks();
    }

    @Override
    @NotNull
    public TriState onServerTick(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!this.canProcess()) {
            return TriState.DEFAULT;
        }
        this.exportItems(level, pos);
        this.exportFluids(level, pos);
        IEnergyStorage iEnergyStorage = this.network;
        if (iEnergyStorage == null) {
            return TriState.FALSE;
        }
        IEnergyStorage network2 = iEnergyStorage;
        return this.onServerTick(level, pos, state, network2);
    }

    @NotNull
    protected abstract TriState onServerTick(@NotNull ServerLevel var1, @NotNull BlockPos var2, @NotNull BlockState var3, @NotNull IEnergyStorage var4);

    @Nullable
    protected final IEnergyStorage getNetwork() {
        return this.network;
    }

    @Override
    protected void afterLevelInit(@NotNull Level level) {
        IEnergyStorage network2;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        IEnergyStorage iEnergyStorage = RagiumAPI.Companion.getInstance().getEnergyNetworkManager().getNetwork(level);
        if (iEnergyStorage == null) {
            return;
        }
        this.network = network2 = iEnergyStorage;
        this.externalNetwork = HTStorageIO.INPUT.wrapEnergyStorage(network2);
    }

    @Override
    @Nullable
    public IEnergyStorage getEnergyStorage(@Nullable Direction direction) {
        return this.externalNetwork;
    }

    @NotNull
    public final Component getDisplayName() {
        MutableComponent mutableComponent = this.getBlockState().getBlock().getName();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"getName(...)");
        return (Component)mutableComponent;
    }
}

