/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.block.entity.device;

import hiiragi283.ragium.api.RagiumAPI;
import hiiragi283.ragium.api.network.HTNbtCodec;
import hiiragi283.ragium.api.registry.HTDeferredBlockEntityType;
import hiiragi283.ragium.common.block.entity.HTTickAwareBlockEntity;
import hiiragi283.ragium.common.inventory.HTEnergyNetworkAccessMenu;
import hiiragi283.ragium.common.storage.item.HTItemStackHandler;
import hiiragi283.ragium.setup.RagiumBlockEntityTypes;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u00012\u00020\u0002:\u000256B%\b\u0004\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J0\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020$2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010%\u001a\u00020#H\u0002J\b\u0010&\u001a\u00020#H\u0002J\u0014\u0010)\u001a\u0004\u0018\u00010\u000e2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J \u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u000204H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u0004\u0018\u00010\u000eX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u001e\u001a\u00020\u001fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0012\u0010'\u001a\u00020\u001fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010!\u0082\u0001\u000278\u00a8\u00069"}, d2={"Lhiiragi283/ragium/common/block/entity/device/HTEnergyNetworkAccessBlockEntity;", "Lhiiragi283/ragium/common/block/entity/HTTickAwareBlockEntity;", "Lnet/minecraft/world/MenuProvider;", "type", "Lhiiragi283/ragium/api/registry/HTDeferredBlockEntityType;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lhiiragi283/ragium/api/registry/HTDeferredBlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "inventory", "Lhiiragi283/ragium/common/storage/item/HTItemStackHandler;", "network", "Lnet/neoforged/neoforge/energy/IEnergyStorage;", "getNetwork", "()Lnet/neoforged/neoforge/energy/IEnergyStorage;", "writeNbt", "", "writer", "Lhiiragi283/ragium/api/network/HTNbtCodec$Writer;", "readNbt", "reader", "Lhiiragi283/ragium/api/network/HTNbtCodec$Reader;", "onRemove", "level", "Lnet/minecraft/world/level/Level;", "newState", "movedByPiston", "", "maxTicks", "", "getMaxTicks", "()I", "onServerTick", "Lnet/neoforged/neoforge/common/util/TriState;", "Lnet/minecraft/server/level/ServerLevel;", "extractFromItem", "receiveToItem", "transferRate", "getTransferRate", "getEnergyStorage", "direction", "Lnet/minecraft/core/Direction;", "createMenu", "Lhiiragi283/ragium/common/inventory/HTEnergyNetworkAccessMenu;", "containerId", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "player", "Lnet/minecraft/world/entity/player/Player;", "getDisplayName", "Lnet/minecraft/network/chat/Component;", "Creative", "Simple", "Lhiiragi283/ragium/common/block/entity/device/HTEnergyNetworkAccessBlockEntity$Creative;", "Lhiiragi283/ragium/common/block/entity/device/HTEnergyNetworkAccessBlockEntity$Simple;", "ragium"})
public abstract sealed class HTEnergyNetworkAccessBlockEntity
extends HTTickAwareBlockEntity
implements MenuProvider {
    @NotNull
    private final HTItemStackHandler inventory;
    private final int maxTicks;

    private HTEnergyNetworkAccessBlockEntity(HTDeferredBlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        Function0<Unit> function0 = new Function0<Unit>((Object)this){

            public final void invoke() {
                ((HTEnergyNetworkAccessBlockEntity)this.receiver).setChanged();
            }
        };
        this.inventory = new HTItemStackHandler(function0){

            public boolean isItemValid(int slot, ItemStack stack) {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                IEnergyStorage iEnergyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
                if (iEnergyStorage == null) {
                    return false;
                }
                IEnergyStorage energyStorage = iEnergyStorage;
                return switch (slot) {
                    case 0 -> {
                        if (energyStorage.getEnergyStored() > 0 && energyStorage.canExtract()) {
                            yield true;
                        }
                        yield false;
                    }
                    case 1 -> {
                        if (energyStorage.getEnergyStored() < energyStorage.getMaxEnergyStored() && energyStorage.canReceive()) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> false;
                };
            }
        };
        this.maxTicks = 20;
    }

    @Nullable
    protected abstract IEnergyStorage getNetwork();

    @Override
    public void writeNbt(@NotNull HTNbtCodec.Writer writer2) {
        Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
        writer2.write("inventory", (INBTSerializable<CompoundTag>)((INBTSerializable)this.inventory));
    }

    @Override
    public void readNbt(@NotNull HTNbtCodec.Reader reader2) {
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        reader2.read("inventory", (INBTSerializable<CompoundTag>)((INBTSerializable)this.inventory));
    }

    @Override
    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        super.onRemove(state, level, pos, newState, movedByPiston);
        this.inventory.dropStacksAt(level, pos);
    }

    @Override
    public int getMaxTicks() {
        return this.maxTicks;
    }

    @Override
    @NotNull
    public TriState onServerTick(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        TriState extractResult = this.extractFromItem();
        TriState receiveResult = this.receiveToItem();
        return !extractResult.isFalse() || !receiveResult.isFalse() ? TriState.TRUE : TriState.FALSE;
    }

    private final TriState extractFromItem() {
        ItemStack itemStack = this.inventory.getStackInSlot(0);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getStackInSlot(...)");
        ItemStack stackIn = itemStack;
        IEnergyStorage iEnergyStorage = (IEnergyStorage)stackIn.getCapability(Capabilities.EnergyStorage.ITEM);
        if (iEnergyStorage == null) {
            return TriState.FALSE;
        }
        IEnergyStorage energyIn = iEnergyStorage;
        int toExtract = this.getTransferRate();
        if ((toExtract = energyIn.extractEnergy(toExtract, true)) > 0) {
            IEnergyStorage iEnergyStorage2 = this.getNetwork();
            int mayReceive = iEnergyStorage2 != null ? iEnergyStorage2.receiveEnergy(toExtract, true) : 0;
            if ((mayReceive = Math.min(toExtract, mayReceive)) > 0) {
                energyIn.extractEnergy(mayReceive, false);
                IEnergyStorage iEnergyStorage3 = this.getNetwork();
                if (iEnergyStorage3 != null) {
                    iEnergyStorage3.receiveEnergy(mayReceive, false);
                }
                return TriState.TRUE;
            }
            return TriState.DEFAULT;
        }
        return TriState.FALSE;
    }

    private final TriState receiveToItem() {
        ItemStack itemStack = this.inventory.getStackInSlot(1);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getStackInSlot(...)");
        ItemStack stackIn = itemStack;
        IEnergyStorage iEnergyStorage = (IEnergyStorage)stackIn.getCapability(Capabilities.EnergyStorage.ITEM);
        if (iEnergyStorage == null) {
            return TriState.FALSE;
        }
        IEnergyStorage energyIn = iEnergyStorage;
        int toReceive = this.getTransferRate();
        if ((toReceive = energyIn.receiveEnergy(toReceive, true)) > 0) {
            IEnergyStorage iEnergyStorage2 = this.getNetwork();
            int mayExtract = iEnergyStorage2 != null ? iEnergyStorage2.extractEnergy(toReceive, true) : 0;
            if ((mayExtract = Math.min(toReceive, mayExtract)) > 0) {
                energyIn.receiveEnergy(mayExtract, false);
                IEnergyStorage iEnergyStorage3 = this.getNetwork();
                if (iEnergyStorage3 != null) {
                    iEnergyStorage3.extractEnergy(mayExtract, false);
                }
                return TriState.TRUE;
            }
            return TriState.DEFAULT;
        }
        return TriState.FALSE;
    }

    protected abstract int getTransferRate();

    @Override
    @Nullable
    public IEnergyStorage getEnergyStorage(@Nullable Direction direction) {
        return this.getNetwork();
    }

    @NotNull
    public HTEnergyNetworkAccessMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        BlockPos blockPos = this.getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        return new HTEnergyNetworkAccessMenu(containerId, playerInventory, blockPos, this.createDefinition(this.inventory));
    }

    @NotNull
    public Component getDisplayName() {
        MutableComponent mutableComponent = this.getBlockState().getBlock().getName();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"getName(...)");
        return (Component)mutableComponent;
    }

    public /* synthetic */ HTEnergyNetworkAccessBlockEntity(HTDeferredBlockEntityType type, BlockPos pos, BlockState state, DefaultConstructorMarker $constructor_marker) {
        this(type, pos, state);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lhiiragi283/ragium/common/block/entity/device/HTEnergyNetworkAccessBlockEntity$Creative;", "Lhiiragi283/ragium/common/block/entity/device/HTEnergyNetworkAccessBlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "network", "Lnet/neoforged/neoforge/energy/IEnergyStorage;", "getNetwork", "()Lnet/neoforged/neoforge/energy/IEnergyStorage;", "transferRate", "", "getTransferRate", "()I", "ragium"})
    public static final class Creative
    extends HTEnergyNetworkAccessBlockEntity {
        @NotNull
        private final IEnergyStorage network;
        private final int transferRate;

        public Creative(@NotNull BlockPos pos, @NotNull BlockState state) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            super(RagiumBlockEntityTypes.CEU, pos, state, null);
            this.network = new IEnergyStorage(){

                public int receiveEnergy(int toReceive, boolean simulate) {
                    return toReceive;
                }

                public int extractEnergy(int toExtract, boolean simulate) {
                    return toExtract;
                }

                public int getEnergyStored() {
                    return 0;
                }

                public int getMaxEnergyStored() {
                    return Integer.MAX_VALUE;
                }

                public boolean canExtract() {
                    return true;
                }

                public boolean canReceive() {
                    return true;
                }
            };
            this.transferRate = Integer.MAX_VALUE;
        }

        @Override
        @NotNull
        protected IEnergyStorage getNetwork() {
            return this.network;
        }

        @Override
        protected int getTransferRate() {
            return this.transferRate;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lhiiragi283/ragium/common/block/entity/device/HTEnergyNetworkAccessBlockEntity$Simple;", "Lhiiragi283/ragium/common/block/entity/device/HTEnergyNetworkAccessBlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "network", "Lnet/neoforged/neoforge/energy/IEnergyStorage;", "getNetwork", "()Lnet/neoforged/neoforge/energy/IEnergyStorage;", "setNetwork", "(Lnet/neoforged/neoforge/energy/IEnergyStorage;)V", "transferRate", "", "getTransferRate", "()I", "afterLevelInit", "", "level", "Lnet/minecraft/world/level/Level;", "ragium"})
    public static final class Simple
    extends HTEnergyNetworkAccessBlockEntity {
        @Nullable
        private IEnergyStorage network;
        private final int transferRate;

        public Simple(@NotNull BlockPos pos, @NotNull BlockState state) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            super(RagiumBlockEntityTypes.ENI, pos, state, null);
            this.transferRate = 1000;
        }

        @Override
        @Nullable
        protected IEnergyStorage getNetwork() {
            return this.network;
        }

        protected void setNetwork(@Nullable IEnergyStorage iEnergyStorage) {
            this.network = iEnergyStorage;
        }

        @Override
        protected int getTransferRate() {
            return this.transferRate;
        }

        @Override
        protected void afterLevelInit(@NotNull Level level) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            this.setNetwork(RagiumAPI.Companion.getInstance().getEnergyNetworkManager().getNetwork(level));
        }
    }
}

