/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.block.entity.device;

import hiiragi283.ragium.api.RagiumConfig;
import hiiragi283.ragium.api.network.HTNbtCodec;
import hiiragi283.ragium.api.storage.fluid.HTFilteredFluidHandler;
import hiiragi283.ragium.api.storage.fluid.HTFluidFilter;
import hiiragi283.ragium.common.block.entity.HTTickAwareBlockEntity;
import hiiragi283.ragium.common.inventory.HTFluidCollectorMenu;
import hiiragi283.ragium.common.storage.fluid.HTFluidTank;
import hiiragi283.ragium.setup.RagiumBlockEntityTypes;
import hiiragi283.ragium.setup.RagiumFluidContents;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.EmptyItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020&H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006'"}, d2={"Lhiiragi283/ragium/common/block/entity/device/HTExpCollectorBlockEntity;", "Lhiiragi283/ragium/common/block/entity/HTTickAwareBlockEntity;", "Lnet/minecraft/world/MenuProvider;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "tank", "Lhiiragi283/ragium/common/storage/fluid/HTFluidTank;", "writeNbt", "", "writer", "Lhiiragi283/ragium/api/network/HTNbtCodec$Writer;", "readNbt", "reader", "Lhiiragi283/ragium/api/network/HTNbtCodec$Reader;", "onServerTick", "Lnet/neoforged/neoforge/common/util/TriState;", "level", "Lnet/minecraft/server/level/ServerLevel;", "maxTicks", "", "getMaxTicks", "()I", "getFluidHandler", "Lnet/neoforged/neoforge/fluids/capability/IFluidHandler;", "direction", "Lnet/minecraft/core/Direction;", "createMenu", "Lhiiragi283/ragium/common/inventory/HTFluidCollectorMenu;", "containerId", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "player", "Lnet/minecraft/world/entity/player/Player;", "getDisplayName", "Lnet/minecraft/network/chat/Component;", "ragium"})
public final class HTExpCollectorBlockEntity
extends HTTickAwareBlockEntity
implements MenuProvider {
    @NotNull
    private final HTFluidTank tank;
    private final int maxTicks;

    public HTExpCollectorBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(RagiumBlockEntityTypes.EXP_COLLECTOR, pos, state);
        this.tank = new HTFluidTank(Integer.MAX_VALUE, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ((HTExpCollectorBlockEntity)this.receiver).setChanged();
            }
        }));
        this.maxTicks = 20;
    }

    @Override
    public void writeNbt(@NotNull HTNbtCodec.Writer writer2) {
        Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
        writer2.write("tank", (INBTSerializable<CompoundTag>)((INBTSerializable)this.tank));
    }

    @Override
    public void readNbt(@NotNull HTNbtCodec.Reader reader2) {
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        reader2.read("tank", (INBTSerializable<CompoundTag>)((INBTSerializable)this.tank));
    }

    @Override
    @NotNull
    public TriState onServerTick(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!this.canProcess()) {
            return TriState.DEFAULT;
        }
        this.exportFluids(level, pos);
        Object object = RagiumConfig.COMMON.entityCollectorRange.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        int range = ((Number)object).intValue();
        List list = level.getEntitiesOfClass(ExperienceOrb.class, AABB.of((BoundingBox)new BoundingBox(this.getBlockPos().getX() - range, this.getBlockPos().getY() - range, this.getBlockPos().getZ() - range, this.getBlockPos().getX() + range, this.getBlockPos().getY() + range, this.getBlockPos().getZ() + range)));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesOfClass(...)");
        List expOrbs = list;
        if (expOrbs.isEmpty()) {
            return TriState.DEFAULT;
        }
        for (ExperienceOrb entity : expOrbs) {
            int n = entity.value;
            Object object2 = RagiumConfig.COMMON.expCollectorMultiplier.get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            int fluidAmount = n * ((Number)object2).intValue();
            FluidStack stack = RagiumFluidContents.EXPERIENCE.toStack(fluidAmount);
            if (!this.tank.canFill(stack, true)) continue;
            this.tank.fill(stack, IFluidHandler.FluidAction.EXECUTE);
            entity.discard();
        }
        return TriState.TRUE;
    }

    @Override
    public int getMaxTicks() {
        return this.maxTicks;
    }

    @Override
    @Nullable
    public IFluidHandler getFluidHandler(@Nullable Direction direction) {
        return new HTFilteredFluidHandler(CollectionsKt.listOf((Object)((Object)this.tank)), HTFluidFilter.DRAIN_ONLY);
    }

    @NotNull
    public HTFluidCollectorMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        BlockPos blockPos = this.getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        IItemHandler iItemHandler = EmptyItemHandler.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)iItemHandler, (String)"INSTANCE");
        return new HTFluidCollectorMenu(containerId, playerInventory, blockPos, this.createDefinition(iItemHandler));
    }

    @NotNull
    public Component getDisplayName() {
        MutableComponent mutableComponent = this.getBlockState().getBlock().getName();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"getName(...)");
        return (Component)mutableComponent;
    }
}

