/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.block.entity.device;

import hiiragi283.ragium.api.RagiumConfig;
import hiiragi283.ragium.api.network.HTNbtCodec;
import hiiragi283.ragium.api.registry.HTDeferredBlockEntityType;
import hiiragi283.ragium.api.storage.fluid.HTFilteredFluidHandler;
import hiiragi283.ragium.api.storage.fluid.HTFluidFilter;
import hiiragi283.ragium.common.block.entity.HTTickAwareBlockEntity;
import hiiragi283.ragium.common.inventory.HTFluidCollectorMenu;
import hiiragi283.ragium.common.storage.fluid.HTFluidTank;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.EmptyItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u0006H$J\u0018\u0010 \u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u0006H$J\u0012\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u001e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+J\u0006\u0010,\u001a\u00020-R\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u001a\u001a\u00020\u001bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006."}, d2={"Lhiiragi283/ragium/common/block/entity/device/HTFluidCollectorBlockEntity;", "Lhiiragi283/ragium/common/block/entity/HTTickAwareBlockEntity;", "Lnet/minecraft/world/MenuProvider;", "type", "Lhiiragi283/ragium/api/registry/HTDeferredBlockEntityType;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lhiiragi283/ragium/api/registry/HTDeferredBlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "tank", "Lhiiragi283/ragium/common/storage/fluid/HTFluidTank;", "getTank", "()Lhiiragi283/ragium/common/storage/fluid/HTFluidTank;", "writeNbt", "", "writer", "Lhiiragi283/ragium/api/network/HTNbtCodec$Writer;", "readNbt", "reader", "Lhiiragi283/ragium/api/network/HTNbtCodec$Reader;", "onServerTick", "Lnet/neoforged/neoforge/common/util/TriState;", "level", "Lnet/minecraft/server/level/ServerLevel;", "maxTicks", "", "getMaxTicks", "()I", "getGeneratedFluid", "Lnet/neoforged/neoforge/fluids/FluidStack;", "playSound", "getFluidHandler", "Lhiiragi283/ragium/api/storage/fluid/HTFilteredFluidHandler;", "direction", "Lnet/minecraft/core/Direction;", "createMenu", "Lhiiragi283/ragium/common/inventory/HTFluidCollectorMenu;", "containerId", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "player", "Lnet/minecraft/world/entity/player/Player;", "getDisplayName", "Lnet/minecraft/network/chat/Component;", "ragium"})
public abstract class HTFluidCollectorBlockEntity
extends HTTickAwareBlockEntity
implements MenuProvider {
    @NotNull
    private final HTFluidTank tank;
    private final int maxTicks;

    public HTFluidCollectorBlockEntity(@NotNull HTDeferredBlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
        Object object = RagiumConfig.COMMON.machineTankCapacity.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        this.tank = new HTFluidTank(((Number)object).intValue(), (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ((HTFluidCollectorBlockEntity)this.receiver).setChanged();
            }
        }));
        this.maxTicks = 20;
    }

    @NotNull
    protected final HTFluidTank getTank() {
        return this.tank;
    }

    @Override
    public final void writeNbt(@NotNull HTNbtCodec.Writer writer2) {
        Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
        writer2.write("tank", (INBTSerializable<CompoundTag>)((INBTSerializable)this.tank));
    }

    @Override
    public final void readNbt(@NotNull HTNbtCodec.Reader reader2) {
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        reader2.read("tank", (INBTSerializable<CompoundTag>)((INBTSerializable)this.tank));
    }

    @Override
    @NotNull
    public TriState onServerTick(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!this.canProcess()) {
            return TriState.DEFAULT;
        }
        this.exportFluids(level, pos);
        FluidStack stack = this.getGeneratedFluid(level, pos);
        if (stack.isEmpty()) {
            return TriState.DEFAULT;
        }
        if (!this.tank.canFill(stack, false)) {
            return TriState.DEFAULT;
        }
        this.tank.fill(stack, IFluidHandler.FluidAction.EXECUTE);
        this.playSound(level, pos);
        return TriState.TRUE;
    }

    @Override
    public final int getMaxTicks() {
        return this.maxTicks;
    }

    @NotNull
    protected abstract FluidStack getGeneratedFluid(@NotNull ServerLevel var1, @NotNull BlockPos var2);

    protected abstract void playSound(@NotNull ServerLevel var1, @NotNull BlockPos var2);

    @Override
    @NotNull
    public HTFilteredFluidHandler getFluidHandler(@Nullable Direction direction) {
        return new HTFilteredFluidHandler(CollectionsKt.listOf((Object)((Object)this.tank)), HTFluidFilter.DRAIN_ONLY);
    }

    @NotNull
    public final HTFluidCollectorMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        BlockPos blockPos = this.getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        IItemHandler iItemHandler = EmptyItemHandler.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)iItemHandler, (String)"INSTANCE");
        return new HTFluidCollectorMenu(containerId, playerInventory, blockPos, this.createDefinition(iItemHandler));
    }

    @NotNull
    public final Component getDisplayName() {
        MutableComponent mutableComponent = this.getBlockState().getBlock().getName();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"getName(...)");
        return (Component)mutableComponent;
    }
}

