/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.block.entity.device;

import hiiragi283.ragium.api.RagiumConfig;
import hiiragi283.ragium.api.network.HTNbtCodec;
import hiiragi283.ragium.api.storage.item.HTFilteredItemHandler;
import hiiragi283.ragium.api.storage.item.HTItemFilter;
import hiiragi283.ragium.common.block.entity.HTTickAwareBlockEntity;
import hiiragi283.ragium.common.inventory.HTItemCollectorMenu;
import hiiragi283.ragium.common.storage.item.HTItemStackHandler;
import hiiragi283.ragium.setup.RagiumBlockEntityTypes;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J0\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0014\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J \u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020+H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001cX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006,"}, d2={"Lhiiragi283/ragium/common/block/entity/device/HTItemCollectorBlockEntity;", "Lhiiragi283/ragium/common/block/entity/HTTickAwareBlockEntity;", "Lnet/minecraft/world/MenuProvider;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "inventory", "Lhiiragi283/ragium/common/storage/item/HTItemStackHandler;", "writeNbt", "", "writer", "Lhiiragi283/ragium/api/network/HTNbtCodec$Writer;", "readNbt", "reader", "Lhiiragi283/ragium/api/network/HTNbtCodec$Reader;", "onRemove", "level", "Lnet/minecraft/world/level/Level;", "newState", "movedByPiston", "", "onServerTick", "Lnet/neoforged/neoforge/common/util/TriState;", "Lnet/minecraft/server/level/ServerLevel;", "maxTicks", "", "getMaxTicks", "()I", "getItemHandler", "Lnet/neoforged/neoforge/items/IItemHandler;", "direction", "Lnet/minecraft/core/Direction;", "createMenu", "Lhiiragi283/ragium/common/inventory/HTItemCollectorMenu;", "containerId", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "player", "Lnet/minecraft/world/entity/player/Player;", "getDisplayName", "Lnet/minecraft/network/chat/Component;", "ragium"})
public final class HTItemCollectorBlockEntity
extends HTTickAwareBlockEntity
implements MenuProvider {
    @NotNull
    private final HTItemStackHandler inventory;
    private final int maxTicks;

    public HTItemCollectorBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(RagiumBlockEntityTypes.ITEM_COLLECTOR, pos, state);
        this.inventory = new HTItemStackHandler(9, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ((HTItemCollectorBlockEntity)this.receiver).setChanged();
            }
        }));
        this.maxTicks = 20;
    }

    @Override
    public void writeNbt(@NotNull HTNbtCodec.Writer writer2) {
        Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
        writer2.write("inventory", (INBTSerializable<CompoundTag>)((INBTSerializable)this.inventory));
    }

    @Override
    public void readNbt(@NotNull HTNbtCodec.Reader reader2) {
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        reader2.read("inventory", (INBTSerializable<CompoundTag>)((INBTSerializable)this.inventory));
    }

    @Override
    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        super.onRemove(state, level, pos, newState, movedByPiston);
        this.inventory.dropStacksAt(level, pos);
    }

    @Override
    @NotNull
    public TriState onServerTick(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!this.canProcess()) {
            return TriState.DEFAULT;
        }
        this.exportItems(level, pos);
        Object object = RagiumConfig.COMMON.entityCollectorRange.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        int range = ((Number)object).intValue();
        List list = level.getEntitiesOfClass(ItemEntity.class, AABB.of((BoundingBox)new BoundingBox(this.getBlockPos().getX() - range, this.getBlockPos().getY() - range, this.getBlockPos().getZ() - range, this.getBlockPos().getX() + range, this.getBlockPos().getY() + range, this.getBlockPos().getZ() + range)));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesOfClass(...)");
        List itemEntities = list;
        if (itemEntities.isEmpty()) {
            return TriState.DEFAULT;
        }
        for (ItemEntity entity : itemEntities) {
            ItemStack remainStack;
            ItemStack stackIn;
            if (entity.getPersistentData().getBoolean("PreventRemoteMovement") || entity.hasPickUpDelay()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)entity.getItem().copy(), (String)"copy(...)");
            Intrinsics.checkNotNullExpressionValue((Object)ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)stackIn, (boolean)false), (String)"insertItem(...)");
            if (remainStack.isEmpty()) {
                entity.discard();
                continue;
            }
            entity.getItem().setCount(remainStack.getCount());
        }
        return TriState.TRUE;
    }

    @Override
    public int getMaxTicks() {
        return this.maxTicks;
    }

    @Override
    @Nullable
    public IItemHandler getItemHandler(@Nullable Direction direction) {
        return new HTFilteredItemHandler(this.inventory, HTItemFilter.EXTRACT_ONLY);
    }

    @NotNull
    public HTItemCollectorMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        BlockPos blockPos = this.getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        return new HTItemCollectorMenu(containerId, playerInventory, blockPos, this.createDefinition(this.inventory));
    }

    @NotNull
    public Component getDisplayName() {
        MutableComponent mutableComponent = this.getBlockState().getBlock().getName();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"getName(...)");
        return (Component)mutableComponent;
    }
}

