/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.block.entity.device;

import hiiragi283.ragium.api.RagiumConfig;
import hiiragi283.ragium.api.network.HTNbtCodec;
import hiiragi283.ragium.api.storage.fluid.HTFilteredFluidHandler;
import hiiragi283.ragium.api.storage.fluid.HTFluidFilter;
import hiiragi283.ragium.common.block.entity.HTTickAwareBlockEntity;
import hiiragi283.ragium.common.storage.fluid.HTFluidTank;
import hiiragi283.ragium.setup.RagiumBlockEntityTypes;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0016H\u0002J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lhiiragi283/ragium/common/block/entity/device/HTSprinklerBlockEntity;", "Lhiiragi283/ragium/common/block/entity/HTTickAwareBlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "tank", "Lhiiragi283/ragium/common/storage/fluid/HTFluidTank;", "writeNbt", "", "writer", "Lhiiragi283/ragium/api/network/HTNbtCodec$Writer;", "readNbt", "reader", "Lhiiragi283/ragium/api/network/HTNbtCodec$Reader;", "onServerTick", "Lnet/neoforged/neoforge/common/util/TriState;", "level", "Lnet/minecraft/server/level/ServerLevel;", "maxTicks", "", "getMaxTicks", "()I", "glowCrop", "height", "getFluidHandler", "Lnet/neoforged/neoforge/fluids/capability/IFluidHandler;", "direction", "Lnet/minecraft/core/Direction;", "ragium"})
public final class HTSprinklerBlockEntity
extends HTTickAwareBlockEntity {
    @NotNull
    private final HTFluidTank tank;
    private final int maxTicks;

    public HTSprinklerBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(RagiumBlockEntityTypes.SPRINKLER, pos, state);
        Object object = RagiumConfig.COMMON.machineTankCapacity.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        this.tank = new HTFluidTank(((Number)object).intValue(), (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ((HTSprinklerBlockEntity)this.receiver).setChanged();
            }
        }));
        this.maxTicks = 100;
    }

    @Override
    public void writeNbt(@NotNull HTNbtCodec.Writer writer2) {
        Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
        writer2.write("tank", (INBTSerializable<CompoundTag>)((INBTSerializable)this.tank));
    }

    @Override
    public void readNbt(@NotNull HTNbtCodec.Reader reader2) {
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        reader2.read("tank", (INBTSerializable<CompoundTag>)((INBTSerializable)this.tank));
    }

    @Override
    @NotNull
    public TriState onServerTick(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!this.canProcess()) {
            return TriState.DEFAULT;
        }
        for (int height = 0; height < 3; ++height) {
            if (!this.glowCrop(level, pos, height).isTrue()) continue;
            return TriState.TRUE;
        }
        return TriState.DEFAULT;
    }

    @Override
    public int getMaxTicks() {
        return this.maxTicks;
    }

    private final TriState glowCrop(ServerLevel level, BlockPos pos, int height) {
        List<Object> list = BlockPos.betweenClosedStream((int)-4, (int)height, (int)-4, (int)4, (int)height, (int)4).map(arg_0 -> HTSprinklerBlockEntity.glowCrop$lambda$0((Function1)new Function1<Vec3i, BlockPos>((Object)pos){

            public final BlockPos invoke(Vec3i p0) {
                return ((BlockPos)this.receiver).offset(p0);
            }
        }, arg_0)).filter(arg_0 -> HTSprinklerBlockEntity.glowCrop$lambda$2(arg_0 -> HTSprinklerBlockEntity.glowCrop$lambda$1(pos, arg_0), arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        Object object = CollectionsKt.random((Collection)list, (Random)((Random)Random.Default));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"random(...)");
        BlockPos targetPos2 = (BlockPos)object;
        FluidStack fluidStack = this.tank.getFluid();
        Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"getFluid(...)");
        FluidStack stack = fluidStack;
        if (!this.tank.canDrain(50, true)) {
            return TriState.DEFAULT;
        }
        if (BoneMealItem.applyBonemeal((ItemStack)ItemStack.EMPTY, (Level)((Level)level), (BlockPos)targetPos2, null)) {
            this.tank.drain(stack.copyWithAmount(50), IFluidHandler.FluidAction.EXECUTE);
            return TriState.TRUE;
        }
        return TriState.DEFAULT;
    }

    @Override
    @Nullable
    public IFluidHandler getFluidHandler(@Nullable Direction direction) {
        return new HTFilteredFluidHandler(CollectionsKt.listOf((Object)((Object)this.tank)), new HTFluidFilter(){

            public boolean canFill(List<? extends IFluidTank> tanks, FluidStack stack) {
                Intrinsics.checkNotNullParameter(tanks, (String)"tanks");
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                return stack.is(Tags.Fluids.WATER);
            }

            public boolean canDrain(List<? extends IFluidTank> tanks, FluidStack stack) {
                Intrinsics.checkNotNullParameter(tanks, (String)"tanks");
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                return false;
            }

            public boolean canDrain(List<? extends IFluidTank> tanks, int maxDrain) {
                Intrinsics.checkNotNullParameter(tanks, (String)"tanks");
                return false;
            }
        });
    }

    private static final BlockPos glowCrop$lambda$0(Function1 $tmp0, Object p0) {
        return (BlockPos)$tmp0.invoke(p0);
    }

    private static final boolean glowCrop$lambda$1(BlockPos $pos, BlockPos posIn) {
        Intrinsics.checkNotNullParameter((Object)posIn, (String)"posIn");
        return !Intrinsics.areEqual((Object)posIn, (Object)$pos);
    }

    private static final boolean glowCrop$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

