/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.block.entity.machine;

import hiiragi283.ragium.api.RagiumConfig;
import hiiragi283.ragium.api.recipe.HTItemOutput;
import hiiragi283.ragium.api.recipe.HTRecipeCache;
import hiiragi283.ragium.api.recipe.HTUniversalRecipeInput;
import hiiragi283.ragium.api.storage.item.HTFilteredItemHandler;
import hiiragi283.ragium.api.storage.item.HTItemFilter;
import hiiragi283.ragium.api.storage.item.HTItemHandler;
import hiiragi283.ragium.common.block.entity.HTMachineBlockEntity;
import hiiragi283.ragium.common.inventory.HTAlloySmelterMenu;
import hiiragi283.ragium.common.recipe.HTAlloyingRecipe;
import hiiragi283.ragium.common.storage.item.HTItemStackHandler;
import hiiragi283.ragium.setup.RagiumBlockEntityTypes;
import hiiragi283.ragium.setup.RagiumRecipeTypes;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J(\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\rH\u0002J\u0012\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J \u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lhiiragi283/ragium/common/block/entity/machine/HTAlloySmelterBlockEntity;", "Lhiiragi283/ragium/common/block/entity/HTMachineBlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "inventory", "Lhiiragi283/ragium/api/storage/item/HTItemHandler;", "getInventory", "()Lhiiragi283/ragium/api/storage/item/HTItemHandler;", "energyUsage", "", "getEnergyUsage", "()I", "recipeCache", "Lhiiragi283/ragium/api/recipe/HTRecipeCache;", "Lhiiragi283/ragium/api/recipe/HTUniversalRecipeInput;", "Lhiiragi283/ragium/common/recipe/HTAlloyingRecipe;", "onServerTick", "Lnet/neoforged/neoforge/common/util/TriState;", "level", "Lnet/minecraft/server/level/ServerLevel;", "network", "Lnet/neoforged/neoforge/energy/IEnergyStorage;", "consumeItem", "", "input", "recipe", "first", "second", "getItemHandler", "Lhiiragi283/ragium/api/storage/item/HTFilteredItemHandler;", "direction", "Lnet/minecraft/core/Direction;", "createMenu", "Lhiiragi283/ragium/common/inventory/HTAlloySmelterMenu;", "containerId", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "player", "Lnet/minecraft/world/entity/player/Player;", "ragium"})
public final class HTAlloySmelterBlockEntity
extends HTMachineBlockEntity {
    @NotNull
    private final HTItemHandler inventory;
    @NotNull
    private final HTRecipeCache<HTUniversalRecipeInput, HTAlloyingRecipe> recipeCache;

    public HTAlloySmelterBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(RagiumBlockEntityTypes.ALLOY_SMELTER, pos, state);
        this.inventory = new HTItemStackHandler(6, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ((HTAlloySmelterBlockEntity)this.receiver).setChanged();
            }
        }));
        RecipeType<HTAlloyingRecipe> recipeType = RagiumRecipeTypes.ALLOYING.get();
        Intrinsics.checkNotNullExpressionValue(recipeType, (String)"get(...)");
        this.recipeCache = HTRecipeCache.Companion.simple(recipeType);
    }

    @Override
    @NotNull
    protected HTItemHandler getInventory() {
        return this.inventory;
    }

    @Override
    protected int getEnergyUsage() {
        Object object = RagiumConfig.COMMON.advancedMachineEnergyUsage.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    @Override
    @NotNull
    protected TriState onServerTick(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull IEnergyStorage network2) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)network2, (String)"network");
        ItemStack[] itemStackArray = new ItemStack[]{this.getInventory().getStackInSlot(0), this.getInventory().getStackInSlot(1)};
        HTUniversalRecipeInput input = HTUniversalRecipeInput.Companion.fromItems(itemStackArray);
        HTAlloyingRecipe hTAlloyingRecipe = this.recipeCache.getFirstRecipe((HTUniversalRecipeInput)((RecipeInput)input), (Level)level);
        if (hTAlloyingRecipe == null) {
            return TriState.FALSE;
        }
        HTAlloyingRecipe recipe = hTAlloyingRecipe;
        if (network2.extractEnergy(this.getRequiredEnergy(), true) != this.getRequiredEnergy()) {
            return TriState.FALSE;
        }
        for (HTItemOutput output : recipe.getOutputs()) {
            if (ItemHandlerHelper.insertItem((IItemHandler)this.getInventory(), (ItemStack)output.get(), (boolean)true).isEmpty()) continue;
            return TriState.FALSE;
        }
        if (!this.consumeItem(input, recipe, 0, 1) && !this.consumeItem(input, recipe, 1, 0)) {
            return TriState.FALSE;
        }
        for (HTItemOutput output : recipe.getOutputs()) {
            IItemHandler iItemHandler = this.getInventory();
            RandomSource randomSource = level.random;
            Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"random");
            ItemHandlerHelper.insertItem((IItemHandler)iItemHandler, (ItemStack)output.getChancedStack(randomSource), (boolean)false);
        }
        network2.extractEnergy(this.getRequiredEnergy(), false);
        level.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS);
        return TriState.TRUE;
    }

    private final boolean consumeItem(HTUniversalRecipeInput input, HTAlloyingRecipe recipe, int first, int second) {
        boolean bl;
        if (recipe.getIngredients().get(0).test(input.getItem(first)) && recipe.getIngredients().get(1).test(input.getItem(second))) {
            this.getInventory().consumeStackInSlot(first, recipe.getIngredients().get(0).count());
            this.getInventory().consumeStackInSlot(second, recipe.getIngredients().get(1).count());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public HTFilteredItemHandler getItemHandler(@Nullable Direction direction) {
        return new HTFilteredItemHandler(this.getInventory(), new HTItemFilter(){

            public boolean canInsert(IItemHandler handler, int slot, ItemStack stack) {
                Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                return slot <= 1;
            }

            public boolean canExtract(IItemHandler handler, int slot, int amount) {
                Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
                return slot >= 2;
            }
        });
    }

    @NotNull
    public HTAlloySmelterMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        BlockPos blockPos = this.getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        return new HTAlloySmelterMenu(containerId, playerInventory, blockPos, this.createDefinition(this.getInventory()));
    }
}

