/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.block.entity.machine;

import com.mojang.authlib.GameProfile;
import hiiragi283.ragium.api.RagiumConfig;
import hiiragi283.ragium.api.storage.item.HTFilteredItemHandler;
import hiiragi283.ragium.api.storage.item.HTItemFilter;
import hiiragi283.ragium.api.storage.item.HTItemHandler;
import hiiragi283.ragium.common.block.HTHorizontalEntityBlock;
import hiiragi283.ragium.common.block.entity.HTMachineBlockEntity;
import hiiragi283.ragium.common.inventory.HTBlockBreakerMenu;
import hiiragi283.ragium.common.storage.item.HTItemStackHandler;
import hiiragi283.ragium.setup.RagiumBlockEntityTypes;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lhiiragi283/ragium/common/block/entity/machine/HTBlockBreakerBlockEntity;", "Lhiiragi283/ragium/common/block/entity/HTMachineBlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "inventory", "Lhiiragi283/ragium/api/storage/item/HTItemHandler;", "getInventory", "()Lhiiragi283/ragium/api/storage/item/HTItemHandler;", "energyUsage", "", "getEnergyUsage", "()I", "onServerTick", "Lnet/neoforged/neoforge/common/util/TriState;", "level", "Lnet/minecraft/server/level/ServerLevel;", "network", "Lnet/neoforged/neoforge/energy/IEnergyStorage;", "getItemHandler", "Lhiiragi283/ragium/api/storage/item/HTFilteredItemHandler;", "direction", "Lnet/minecraft/core/Direction;", "createMenu", "Lhiiragi283/ragium/common/inventory/HTBlockBreakerMenu;", "containerId", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "player", "Lnet/minecraft/world/entity/player/Player;", "ragium"})
public final class HTBlockBreakerBlockEntity
extends HTMachineBlockEntity {
    @NotNull
    private final HTItemHandler inventory;

    public HTBlockBreakerBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(RagiumBlockEntityTypes.BLOCK_BREAKER, pos, state);
        this.inventory = new HTItemStackHandler(1, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ((HTBlockBreakerBlockEntity)this.receiver).setChanged();
            }
        }));
    }

    @Override
    @NotNull
    protected HTItemHandler getInventory() {
        return this.inventory;
    }

    @Override
    protected int getEnergyUsage() {
        Object object = RagiumConfig.COMMON.basicMachineEnergyUsage.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    @Override
    @NotNull
    protected TriState onServerTick(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull IEnergyStorage network2) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)network2, (String)"network");
        if (network2.extractEnergy(this.getRequiredEnergy(), true) != this.getRequiredEnergy()) {
            return TriState.DEFAULT;
        }
        FakePlayer fakePlayer = FakePlayerFactory.get((ServerLevel)level, (GameProfile)new GameProfile(UUID.randomUUID(), "Fake Player"));
        Intrinsics.checkNotNullExpressionValue((Object)fakePlayer, (String)"get(...)");
        FakePlayer player = fakePlayer;
        Inventory inventory2 = player.getInventory();
        Intrinsics.checkNotNullExpressionValue((Object)inventory2, (String)"getInventory(...)");
        Inventory inventory3 = inventory2;
        ItemStack itemStack = this.getInventory().getStackInSlot(0);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getStackInSlot(...)");
        ItemStack toolStack = itemStack;
        inventory3.items.set(inventory3.selected, (Object)toolStack);
        Comparable comparable = state.getValue((Property)HTHorizontalEntityBlock.HORIZONTAL);
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        Direction front = (Direction)comparable;
        BlockPos blockPos = pos.relative(front);
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"relative(...)");
        BlockPos posTo = blockPos;
        BlockState blockState = level.getBlockState(posTo);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
        BlockState stateTo = blockState;
        if (stateTo.getDestroySpeed((BlockGetter)level, posTo) < 0.0f) {
            return TriState.DEFAULT;
        }
        if (!stateTo.canHarvestBlock((BlockGetter)level, posTo, (Player)player)) {
            return TriState.DEFAULT;
        }
        if (CommonHooks.fireBlockBreak((Level)((Level)level), (GameType)GameType.SURVIVAL, (ServerPlayer)((ServerPlayer)player), (BlockPos)posTo, (BlockState)stateTo).isCanceled()) {
            return TriState.DEFAULT;
        }
        Block block = stateTo.getBlock();
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
        Block blockTo = block;
        BlockState blockState2 = blockTo.playerWillDestroy((Level)level, posTo, stateTo, (Player)player);
        Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"playerWillDestroy(...)");
        BlockState newStateTo = blockState2;
        ItemStack itemStack2 = toolStack.copy();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"copy(...)");
        ItemStack toolStack1 = itemStack2;
        boolean canHarvest = newStateTo.canHarvestBlock((BlockGetter)level, posTo, (Player)player);
        toolStack.mineBlock((Level)level, newStateTo, posTo, (Player)player);
        boolean removed = newStateTo.onDestroyedByPlayer((Level)level, posTo, (Player)player, canHarvest, level.getFluidState(posTo));
        if (removed) {
            newStateTo.getBlock().destroy((LevelAccessor)level, posTo, newStateTo);
        }
        if (canHarvest && removed) {
            blockTo.playerDestroy((Level)level, (Player)player, posTo, newStateTo, level.getBlockEntity(posTo), toolStack1);
        }
        if (toolStack.isEmpty() && !toolStack1.isEmpty()) {
            EventHooks.onPlayerDestroyItem((Player)((Player)player), (ItemStack)toolStack1, (InteractionHand)InteractionHand.MAIN_HAND);
        }
        network2.extractEnergy(this.getRequiredEnergy(), false);
        return TriState.DEFAULT;
    }

    @Override
    @NotNull
    public HTFilteredItemHandler getItemHandler(@Nullable Direction direction) {
        return new HTFilteredItemHandler(this.getInventory(), HTItemFilter.INSERT_ONLY);
    }

    @NotNull
    public HTBlockBreakerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        BlockPos blockPos = this.getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        return new HTBlockBreakerMenu(containerId, playerInventory, blockPos, this.createDefinition(this.getInventory()));
    }
}

