/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.block.entity.machine;

import hiiragi283.ragium.api.RagiumConfig;
import hiiragi283.ragium.api.network.HTNbtCodec;
import hiiragi283.ragium.api.recipe.HTRecipeCache;
import hiiragi283.ragium.api.recipe.HTUniversalRecipeInput;
import hiiragi283.ragium.api.storage.fluid.HTFilteredFluidHandler;
import hiiragi283.ragium.api.storage.fluid.HTFluidFilter;
import hiiragi283.ragium.api.storage.item.HTFilteredItemHandler;
import hiiragi283.ragium.api.storage.item.HTItemFilter;
import hiiragi283.ragium.api.storage.item.HTItemHandler;
import hiiragi283.ragium.common.block.entity.HTMachineBlockEntity;
import hiiragi283.ragium.common.inventory.HTMelterMenu;
import hiiragi283.ragium.common.recipe.HTMeltingRecipe;
import hiiragi283.ragium.common.storage.fluid.HTFluidTank;
import hiiragi283.ragium.common.storage.item.HTItemStackHandler;
import hiiragi283.ragium.setup.RagiumBlockEntityTypes;
import hiiragi283.ragium.setup.RagiumRecipeTypes;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J(\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"H\u0014J\u0012\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J\u0012\u0010'\u001a\u00020(2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J \u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lhiiragi283/ragium/common/block/entity/machine/HTMelterBlockEntity;", "Lhiiragi283/ragium/common/block/entity/HTMachineBlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "inventory", "Lhiiragi283/ragium/api/storage/item/HTItemHandler;", "getInventory", "()Lhiiragi283/ragium/api/storage/item/HTItemHandler;", "tank", "Lhiiragi283/ragium/common/storage/fluid/HTFluidTank;", "energyUsage", "", "getEnergyUsage", "()I", "writeNbt", "", "writer", "Lhiiragi283/ragium/api/network/HTNbtCodec$Writer;", "readNbt", "reader", "Lhiiragi283/ragium/api/network/HTNbtCodec$Reader;", "recipeCache", "Lhiiragi283/ragium/api/recipe/HTRecipeCache;", "Lhiiragi283/ragium/api/recipe/HTUniversalRecipeInput;", "Lhiiragi283/ragium/common/recipe/HTMeltingRecipe;", "onServerTick", "Lnet/neoforged/neoforge/common/util/TriState;", "level", "Lnet/minecraft/server/level/ServerLevel;", "network", "Lnet/neoforged/neoforge/energy/IEnergyStorage;", "getItemHandler", "Lhiiragi283/ragium/api/storage/item/HTFilteredItemHandler;", "direction", "Lnet/minecraft/core/Direction;", "getFluidHandler", "Lhiiragi283/ragium/api/storage/fluid/HTFilteredFluidHandler;", "createMenu", "Lhiiragi283/ragium/common/inventory/HTMelterMenu;", "containerId", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "player", "Lnet/minecraft/world/entity/player/Player;", "ragium"})
public final class HTMelterBlockEntity
extends HTMachineBlockEntity {
    @NotNull
    private final HTItemHandler inventory;
    @NotNull
    private final HTFluidTank tank;
    @NotNull
    private final HTRecipeCache<HTUniversalRecipeInput, HTMeltingRecipe> recipeCache;

    public HTMelterBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(RagiumBlockEntityTypes.MELTER, pos, state);
        this.inventory = new HTItemStackHandler(1, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ((HTMelterBlockEntity)this.receiver).setChanged();
            }
        }));
        Object object = RagiumConfig.COMMON.machineTankCapacity.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        this.tank = new HTFluidTank(((Number)object).intValue(), (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ((HTMelterBlockEntity)this.receiver).setChanged();
            }
        }));
        RecipeType<HTMeltingRecipe> recipeType = RagiumRecipeTypes.MELTING.get();
        Intrinsics.checkNotNullExpressionValue(recipeType, (String)"get(...)");
        this.recipeCache = HTRecipeCache.Companion.simple(recipeType);
    }

    @Override
    @NotNull
    protected HTItemHandler getInventory() {
        return this.inventory;
    }

    @Override
    protected int getEnergyUsage() {
        Object object = RagiumConfig.COMMON.advancedMachineEnergyUsage.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    @Override
    public void writeNbt(@NotNull HTNbtCodec.Writer writer2) {
        Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
        super.writeNbt(writer2);
        writer2.write("tank", (INBTSerializable<CompoundTag>)((INBTSerializable)this.tank));
    }

    @Override
    public void readNbt(@NotNull HTNbtCodec.Reader reader2) {
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        super.readNbt(reader2);
        reader2.read("tank", (INBTSerializable<CompoundTag>)((INBTSerializable)this.tank));
    }

    @Override
    @NotNull
    protected TriState onServerTick(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull IEnergyStorage network2) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)network2, (String)"network");
        ItemStack[] itemStackArray = new ItemStack[]{this.getInventory().getStackInSlot(0)};
        HTUniversalRecipeInput input = HTUniversalRecipeInput.Companion.fromItems(itemStackArray);
        HTMeltingRecipe hTMeltingRecipe = this.recipeCache.getFirstRecipe((HTUniversalRecipeInput)((RecipeInput)input), (Level)level);
        if (hTMeltingRecipe == null) {
            return TriState.FALSE;
        }
        HTMeltingRecipe recipe = hTMeltingRecipe;
        if (network2.extractEnergy(this.getRequiredEnergy(), true) != this.getRequiredEnergy()) {
            return TriState.DEFAULT;
        }
        if (!this.tank.canFill(recipe.getOutput().get(), true)) {
            return TriState.FALSE;
        }
        this.tank.fill(recipe.getOutput().get(), IFluidHandler.FluidAction.EXECUTE);
        this.getInventory().consumeStackInSlot(0, recipe.getIngredient().count());
        network2.extractEnergy(this.getRequiredEnergy(), false);
        level.playSound(null, pos, SoundEvents.BUCKET_FILL_LAVA, SoundSource.BLOCKS);
        return TriState.TRUE;
    }

    @Override
    @NotNull
    public HTFilteredItemHandler getItemHandler(@Nullable Direction direction) {
        return new HTFilteredItemHandler(this.getInventory(), HTItemFilter.INSERT_ONLY);
    }

    @Override
    @NotNull
    public HTFilteredFluidHandler getFluidHandler(@Nullable Direction direction) {
        return new HTFilteredFluidHandler(CollectionsKt.listOf((Object)((Object)this.tank)), HTFluidFilter.DRAIN_ONLY);
    }

    @NotNull
    public HTMelterMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        BlockPos blockPos = this.getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        return new HTMelterMenu(containerId, playerInventory, blockPos, this.createDefinition(this.getInventory()));
    }
}

