/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.item;

import hiiragi283.ragium.api.extension.LevelExtensionsKt;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lhiiragi283/ragium/common/item/HTRagiTicketItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "usedHand", "Lnet/minecraft/world/InteractionHand;", "ragium"})
public final class HTRagiTicketItem
extends Item {
    public HTRagiTicketItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        ItemStack itemStack = player.getItemInHand(usedHand);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInHand(...)");
        ItemStack stack = itemStack;
        if (level instanceof ServerLevel) {
            LootTable lootTable = ((ServerLevel)level).getServer().reloadableRegistries().getLootTable(BuiltInLootTables.FISHING);
            Intrinsics.checkNotNullExpressionValue((Object)lootTable, (String)"getLootTable(...)");
            LootTable lootTable2 = lootTable;
            LootParams lootParams = new LootParams.Builder((ServerLevel)level).withLuck(player.getLuck()).create(LootContextParamSets.EMPTY);
            Intrinsics.checkNotNullExpressionValue((Object)lootParams, (String)"create(...)");
            LootParams params = lootParams;
            ObjectArrayList objectArrayList = lootTable2.getRandomItems(params);
            Intrinsics.checkNotNullExpressionValue((Object)objectArrayList, (String)"getRandomItems(...)");
            List lootItems = (List)objectArrayList;
            if (lootItems.isEmpty()) {
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.pass((Object)stack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
                return interactionResultHolder;
            }
            for (ItemStack stackIn : lootItems) {
                LevelExtensionsKt.dropStackAt((Entity)player, stackIn);
            }
            stack.consume(1, (LivingEntity)player);
            level.playSound(null, player.blockPosition(), SoundEvents.ENDER_DRAGON_DEATH, SoundSource.PLAYERS);
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"sidedSuccess(...)");
        return interactionResultHolder;
    }
}

