/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.item;

import hiiragi283.ragium.api.RagiumConfig;
import hiiragi283.ragium.api.extension.EnchantmentExtensionsKt;
import hiiragi283.ragium.api.extension.RegistryExtensionsKt;
import hiiragi283.ragium.api.extension.TextExtensionsKt;
import hiiragi283.ragium.api.tag.RagiumEnchantmentTags;
import hiiragi283.ragium.setup.RagiumComponentTypes;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0004J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0004J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J.\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\u001f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0016\u00a8\u0006#"}, d2={"Lhiiragi283/ragium/common/item/HTRangedItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "isActive", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "toggleActive", "", "getRange", "", "level", "Lnet/minecraft/world/level/Level;", "use", "Lnet/minecraft/world/InteractionResultHolder;", "player", "Lnet/minecraft/world/entity/player/Player;", "usedHand", "Lnet/minecraft/world/InteractionHand;", "appendHoverText", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltips", "", "Lnet/minecraft/network/chat/Component;", "flag", "Lnet/minecraft/world/item/TooltipFlag;", "isFoil", "supportsEnchantment", "enchantment", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/item/enchantment/Enchantment;", "ragium"})
public abstract class HTRangedItem
extends Item {
    public HTRangedItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties.stacksTo(1));
    }

    protected final boolean isActive(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Object object = stack.getOrDefault(RagiumComponentTypes.IS_ACTIVE, (Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrDefault(...)");
        return (Boolean)object;
    }

    protected final void toggleActive(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        stack.update(RagiumComponentTypes.IS_ACTIVE, (Object)false, HTRangedItem::toggleActive$lambda$0);
    }

    protected final int getRange(@NotNull ItemStack stack, @Nullable Level level) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        HolderLookup.RegistryLookup<Enchantment> registryLookup = level;
        if (registryLookup == null || (registryLookup = registryLookup.registryAccess()) == null || (registryLookup = RegistryExtensionsKt.enchLookup((HolderLookup.Provider)registryLookup)) == null) {
            return 0;
        }
        HolderLookup.RegistryLookup<Enchantment> enchLookup = registryLookup;
        ItemEnchantments itemEnchantments = stack.getAllEnchantments(enchLookup);
        Intrinsics.checkNotNullExpressionValue((Object)itemEnchantments, (String)"getAllEnchantments(...)");
        int enchLevel = EnchantmentExtensionsKt.getHighestLevel(itemEnchantments, RagiumEnchantmentTags.RANGE);
        return ((Number)RagiumConfig.COMMON.entityCollectorRange.get()).intValue() * (enchLevel + 1);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        if (!level.isClientSide && player.isShiftKeyDown()) {
            ItemStack itemStack = player.getItemInHand(usedHand);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInHand(...)");
            ItemStack stack = itemStack;
            this.toggleActive(stack);
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.consume((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
            return interactionResultHolder;
        }
        InteractionResultHolder interactionResultHolder = super.use(level, player, usedHand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"use(...)");
        return interactionResultHolder;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltips, @NotNull TooltipFlag flag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltips, (String)"tooltips");
        Intrinsics.checkNotNullParameter((Object)flag, (String)"flag");
        Object[] objectArray = new Object[]{TextExtensionsKt.intText(this.getRange(stack, context.level())).withStyle(ChatFormatting.WHITE)};
        MutableComponent mutableComponent = Component.translatable((String)"text.ragium.effect_range", (Object[])objectArray).withStyle(ChatFormatting.GRAY);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
        tooltips.add((Component)mutableComponent);
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return this.isActive(stack);
    }

    public boolean supportsEnchantment(@NotNull ItemStack stack, @NotNull Holder<Enchantment> enchantment) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(enchantment, (String)"enchantment");
        return super.supportsEnchantment(stack, enchantment) || enchantment.is(RagiumEnchantmentTags.RANGE);
    }

    private static final Boolean toggleActive$lambda$0(boolean value) {
        return !value;
    }
}

