/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.item;

import com.mojang.serialization.DataResult;
import hiiragi283.ragium.api.RagiumAPI;
import hiiragi283.ragium.api.extension.LevelExtensionsKt;
import hiiragi283.ragium.api.extension.PlayerExtensionsKt;
import hiiragi283.ragium.api.extension.TextExtensionsKt;
import hiiragi283.ragium.api.util.RagiumTranslationKeys;
import hiiragi283.ragium.setup.RagiumBlocks;
import hiiragi283.ragium.setup.RagiumComponentTypes;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty0;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u0010H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\f\u001a\u00020\u000bH\u0016J&\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0&2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010'\u001a\u00020(H\u0016J.\u0010)\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a8\u00061"}, d2={"Lhiiragi283/ragium/common/item/HTTeleportTicketItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "useOn", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "finishUsingItem", "Lnet/minecraft/world/item/ItemStack;", "stack", "level", "Lnet/minecraft/world/level/Level;", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "tryToTeleport", "", "player", "Lnet/minecraft/world/entity/player/Player;", "canTeleportTo", "Lcom/mojang/serialization/DataResult;", "", "serverLevel", "Lnet/minecraft/server/level/ServerLevel;", "globalPos", "Lnet/minecraft/core/GlobalPos;", "toTransition", "Lnet/minecraft/world/level/portal/DimensionTransition;", "target", "Lnet/minecraft/world/entity/Entity;", "getUseDuration", "", "entity", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "use", "Lnet/minecraft/world/InteractionResultHolder;", "usedHand", "Lnet/minecraft/world/InteractionHand;", "appendHoverText", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltips", "", "Lnet/minecraft/network/chat/Component;", "flag", "Lnet/minecraft/world/item/TooltipFlag;", "isFoil", "ragium"})
@SourceDebugExtension(value={"SMAP\nHTTeleportTicketItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HTTeleportTicketItem.kt\nhiiragi283/ragium/common/item/HTTeleportTicketItem\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n1#2:145\n*E\n"})
public final class HTTeleportTicketItem
extends Item {
    public HTTeleportTicketItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Level level = context.getLevel();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
        Level level2 = level;
        BlockPos blockPos = context.getClickedPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getClickedPos(...)");
        BlockPos pos = blockPos;
        if (level2.getBlockState(pos).is((Holder)RagiumBlocks.TELEPORT_ANCHOR)) {
            context.getItemInHand().set(RagiumComponentTypes.TELEPORT_POS, (Object)new GlobalPos(level2.dimension(), pos.above()));
            InteractionResult interactionResult = InteractionResult.sidedSuccess((boolean)level2.isClientSide);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"sidedSuccess(...)");
            return interactionResult;
        }
        InteractionResult interactionResult = super.useOn(context);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useOn(...)");
        return interactionResult;
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        if (level.isClientSide) {
            return stack;
        }
        if (livingEntity instanceof Player) {
            SoundEvent soundEvent;
            if (this.tryToTeleport((Player)livingEntity, stack)) {
                stack.consume(1, livingEntity);
                if (livingEntity instanceof ServerPlayer) {
                    CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)livingEntity, stack);
                }
                SoundEvent soundEvent2 = SoundEvents.PLAYER_TELEPORT;
                Intrinsics.checkNotNull((Object)soundEvent2);
                soundEvent = soundEvent2;
            } else {
                SoundEvent soundEvent3 = SoundEvents.VILLAGER_NO;
                soundEvent = soundEvent3;
                Intrinsics.checkNotNullExpressionValue((Object)soundEvent3, (String)"VILLAGER_NO");
            }
            SoundEvent sound = soundEvent;
            level.playSound(null, ((Player)livingEntity).getX(), ((Player)livingEntity).getY(), ((Player)livingEntity).getZ(), sound, SoundSource.PLAYERS);
        }
        return stack;
    }

    private final boolean tryToTeleport(Player player, ItemStack stack) {
        GlobalPos globalPos = (GlobalPos)stack.get(RagiumComponentTypes.TELEPORT_POS);
        if (globalPos == null) {
            return false;
        }
        GlobalPos globalPos2 = globalPos;
        MinecraftServer minecraftServer = RagiumAPI.Companion.getInstance().getCurrentServer();
        if (minecraftServer == null || (minecraftServer = minecraftServer.getLevel(globalPos2.dimension())) == null) {
            return false;
        }
        MinecraftServer targetLevel = minecraftServer;
        Boolean bl = this.canTeleportTo((ServerLevel)targetLevel, globalPos2).ifError(arg_0 -> HTTeleportTicketItem.tryToTeleport$lambda$1(arg_0 -> HTTeleportTicketItem.tryToTeleport$lambda$0(player, arg_0), arg_0)).map(arg_0 -> HTTeleportTicketItem.tryToTeleport$lambda$3(arg_0 -> HTTeleportTicketItem.tryToTeleport$lambda$2(player, this, (ServerLevel)targetLevel, globalPos2, stack, arg_0), arg_0)).result().orElse(false);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"orElse(...)");
        return bl;
    }

    private final DataResult<Unit> canTeleportTo(ServerLevel serverLevel, GlobalPos globalPos) {
        if (!serverLevel.isLoaded(globalPos.pos())) {
            DataResult dataResult = DataResult.error(() -> HTTeleportTicketItem.canTeleportTo$lambda$4((KProperty0)new PropertyReference0Impl(RagiumTranslationKeys.INSTANCE){

                public Object get() {
                    return "text.ragium.missing_pos";
                }
            }));
            Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"error(...)");
            return dataResult;
        }
        if (!serverLevel.getBlockState(globalPos.pos().below()).is((Holder)RagiumBlocks.TELEPORT_ANCHOR)) {
            DataResult dataResult = DataResult.error(() -> HTTeleportTicketItem.canTeleportTo$lambda$5((KProperty0)new PropertyReference0Impl(RagiumTranslationKeys.INSTANCE){

                public Object get() {
                    return "text.ragium.missing_anchor";
                }
            }));
            Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"error(...)");
            return dataResult;
        }
        DataResult dataResult = DataResult.success((Object)Unit.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"success(...)");
        return dataResult;
    }

    private final DimensionTransition toTransition(ServerLevel serverLevel, GlobalPos globalPos, Entity target) {
        BlockPos blockPos = globalPos.pos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"pos(...)");
        return new DimensionTransition(serverLevel, LevelExtensionsKt.toCenterVec3(blockPos), target.getDeltaMovement(), target.getYRot(), target.getXRot(), DimensionTransition.DO_NOTHING);
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return 40;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return UseAnim.BOW;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        InteractionResultHolder interactionResultHolder = ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)usedHand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"startUsingInstantly(...)");
        return interactionResultHolder;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltips, @NotNull TooltipFlag flag) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(tooltips, (String)"tooltips");
            Intrinsics.checkNotNullParameter((Object)flag, (String)"flag");
            GlobalPos globalPos = (GlobalPos)stack.get(RagiumComponentTypes.TELEPORT_POS);
            if (globalPos == null) break block1;
            GlobalPos p0 = globalPos;
            boolean bl = false;
            MutableComponent mutableComponent = TextExtensionsKt.globalPosText(p0);
            globalPos = mutableComponent;
            if (mutableComponent != null) {
                p0 = (Component)globalPos;
                boolean bl2 = false;
                tooltips.add((Component)p0);
            }
        }
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return super.isFoil(stack) || stack.has(RagiumComponentTypes.TELEPORT_POS);
    }

    private static final Unit tryToTeleport$lambda$0(Player $player, DataResult.Error it) {
        $player.displayClientMessage((Component)Component.translatable((String)it.message()).withStyle(ChatFormatting.RED), true);
        return Unit.INSTANCE;
    }

    private static final void tryToTeleport$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Boolean tryToTeleport$lambda$2(Player $player, HTTeleportTicketItem this$0, ServerLevel $targetLevel, GlobalPos $globalPos, ItemStack $stack, Unit it) {
        ServerPlayer serverPlayer = PlayerExtensionsKt.asServerPlayer($player);
        if (serverPlayer == null) {
            return false;
        }
        ServerPlayer serverPlayer2 = serverPlayer;
        if (serverPlayer2.connection.isAcceptingMessages()) {
            serverPlayer2.changeDimension(this$0.toTransition($targetLevel, $globalPos, (Entity)$player));
            serverPlayer2.resetFallDistance();
            serverPlayer2.resetCurrentImpulseContext();
            CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer2, $stack);
            return true;
        }
        return false;
    }

    private static final Boolean tryToTeleport$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String canTeleportTo$lambda$4(KProperty0 $tmp0) {
        return (String)((Function0)$tmp0).invoke();
    }

    private static final String canTeleportTo$lambda$5(KProperty0 $tmp0) {
        return (String)((Function0)$tmp0).invoke();
    }
}

