/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.storage.energy;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import hiiragi283.ragium.api.RagiumAPI;
import hiiragi283.ragium.api.RagiumConfig;
import hiiragi283.ragium.api.util.HTSavedDataType;
import hiiragi283.ragium.common.storage.energy.HTEnergyNetwork;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty1;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\b\u0000\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0001\u001eB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u001a\u001a\u00020\u0004H\u0016J\b\u0010\u001b\u001a\u00020\u0004H\u0016J\b\u0010\u001c\u001a\u00020\u0017H\u0016J\b\u0010\u001d\u001a\u00020\u0017H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\f\u00a8\u0006\u001f"}, d2={"Lhiiragi283/ragium/common/storage/energy/HTEnergyNetwork;", "Lnet/minecraft/world/level/saveddata/SavedData;", "Lnet/neoforged/neoforge/energy/IEnergyStorage;", "amount", "", "capacity", "<init>", "(II)V", "()V", "getAmount", "()I", "setAmount", "(I)V", "getCapacity", "setCapacity", "save", "Lnet/minecraft/nbt/CompoundTag;", "tag", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "receiveEnergy", "toReceive", "simulate", "", "extractEnergy", "toExtract", "getEnergyStored", "getMaxEnergyStored", "canExtract", "canReceive", "Companion", "ragium"})
@SourceDebugExtension(value={"SMAP\nHTEnergyNetwork.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HTEnergyNetwork.kt\nhiiragi283/ragium/common/storage/energy/HTEnergyNetwork\n+ 2 NbtExtensions.kt\nhiiragi283/ragium/api/extension/NbtExtensionsKt\n*L\n1#1,84:1\n7#2:85\n*S KotlinDebug\n*F\n+ 1 HTEnergyNetwork.kt\nhiiragi283/ragium/common/storage/energy/HTEnergyNetwork\n*L\n49#1:85\n*E\n"})
public final class HTEnergyNetwork
extends SavedData
implements IEnergyStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int amount;
    private int capacity;
    @JvmField
    @NotNull
    public static final Codec<HTEnergyNetwork> CODEC;
    @JvmField
    @NotNull
    public static final HTSavedDataType<HTEnergyNetwork> DATA_FACTORY;

    public HTEnergyNetwork(int amount, int capacity) {
        this.amount = amount;
        this.capacity = capacity;
        this.amount = Math.min(this.amount, this.capacity);
    }

    public final int getAmount() {
        return this.amount;
    }

    public final void setAmount(int n) {
        this.amount = n;
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public final void setCapacity(int n) {
        this.capacity = n;
    }

    public HTEnergyNetwork() {
        this(0, HTEnergyNetwork.Companion.getInitialCapacity());
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        CompoundTag compoundTag;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        boolean $i$f$buildNbt = false;
        CompoundTag $this$save_u24lambda_u240 = compoundTag = new CompoundTag();
        boolean bl = false;
        $this$save_u24lambda_u240.putInt("energy_stored", this.amount);
        $this$save_u24lambda_u240.putInt("energy_capacity", this.capacity);
        return compoundTag;
    }

    public int receiveEnergy(int toReceive, boolean simulate) {
        if (!this.canReceive() || toReceive <= 0) {
            return 0;
        }
        int received = Mth.clamp((int)(this.getMaxEnergyStored() - this.getEnergyStored()), (int)0, (int)toReceive);
        if (!simulate) {
            this.amount += received;
            this.setDirty();
        }
        return received;
    }

    public int extractEnergy(int toExtract, boolean simulate) {
        if (!this.canExtract() || toExtract <= 0) {
            return 0;
        }
        int extracted = Math.min(this.getEnergyStored(), toExtract);
        if (!simulate) {
            this.amount -= extracted;
            this.setDirty();
        }
        return extracted;
    }

    public int getEnergyStored() {
        return this.amount;
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    private static final Integer CODEC$lambda$3$lambda$1(KMutableProperty1 $tmp0, HTEnergyNetwork p0) {
        return (Integer)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Integer CODEC$lambda$3$lambda$2(KMutableProperty1 $tmp0, HTEnergyNetwork p0) {
        return (Integer)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final App CODEC$lambda$3(RecordCodecBuilder.Instance instance) {
        return instance.group((App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("energy_stored", (Object)0).forGetter(arg_0 -> HTEnergyNetwork.CODEC$lambda$3$lambda$1((KMutableProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("energy_capacity", (Object)HTEnergyNetwork.Companion.getInitialCapacity()).forGetter(arg_0 -> HTEnergyNetwork.CODEC$lambda$3$lambda$2((KMutableProperty1)Companion.CODEC.1.2.INSTANCE, arg_0))).apply((Applicative)instance, HTEnergyNetwork::new);
    }

    @JvmStatic
    private static final int getInitialCapacity() {
        return HTEnergyNetwork.Companion.getInitialCapacity();
    }

    static {
        Codec codec = RecordCodecBuilder.create(HTEnergyNetwork::CODEC$lambda$3);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
        CODEC = codec;
        DATA_FACTORY = HTSavedDataType.Companion.create(RagiumAPI.Companion.id("network"), CODEC, HTEnergyNetwork::new);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0003R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lhiiragi283/ragium/common/storage/energy/HTEnergyNetwork$Companion;", "", "<init>", "()V", "getInitialCapacity", "", "CODEC", "Lcom/mojang/serialization/Codec;", "Lhiiragi283/ragium/common/storage/energy/HTEnergyNetwork;", "DATA_FACTORY", "Lhiiragi283/ragium/api/util/HTSavedDataType;", "ragium"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private final int getInitialCapacity() {
            Object object = RagiumConfig.COMMON.defaultNetworkCapacity.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return ((Number)object).intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

