/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.storage.energy;

import hiiragi283.ragium.api.RagiumAPI;
import hiiragi283.ragium.api.extension.SavedDataExtensionsKt;
import hiiragi283.ragium.api.storage.energy.HTEnergyNetworkManager;
import hiiragi283.ragium.common.storage.energy.HTEnergyNetwork;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\n\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0016J\u0018\u0010\f\u001a\u0004\u0018\u00010\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0016H\u0002R(\u0010\u0004\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0003\u00a8\u0006\u0017"}, d2={"Lhiiragi283/ragium/common/storage/energy/HTEnergyNetworkManagerImpl;", "Lhiiragi283/ragium/api/storage/energy/HTEnergyNetworkManager;", "<init>", "()V", "networkMap", "", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/level/Level;", "Lnet/neoforged/neoforge/energy/IEnergyStorage;", "getNetworkMap$annotations", "getNetwork", "level", "getNetworkFromKey", "key", "getNetworkFromServer", "Lnet/minecraft/server/level/ServerLevel;", "createCache", "onServerStarted", "", "event", "Lnet/neoforged/neoforge/event/server/ServerStartedEvent;", "onServerStopped", "Lnet/neoforged/neoforge/event/server/ServerStoppedEvent;", "ragium"})
@SourceDebugExtension(value={"SMAP\nHTEnergyNetworkManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HTEnergyNetworkManagerImpl.kt\nhiiragi283/ragium/common/storage/energy/HTEnergyNetworkManagerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public final class HTEnergyNetworkManagerImpl
implements HTEnergyNetworkManager {
    @NotNull
    public static final HTEnergyNetworkManagerImpl INSTANCE = new HTEnergyNetworkManagerImpl();
    @NotNull
    private static final Map<ResourceKey<Level>, IEnergyStorage> networkMap;

    private HTEnergyNetworkManagerImpl() {
    }

    @JvmStatic
    private static /* synthetic */ void getNetworkMap$annotations() {
    }

    @Override
    @Nullable
    public IEnergyStorage getNetwork(@Nullable Level level) {
        IEnergyStorage iEnergyStorage;
        if (level instanceof ServerLevel) {
            iEnergyStorage = this.getNetworkFromServer((ServerLevel)level);
        } else {
            Level level2 = level;
            if (level2 != null && (level2 = level2.dimension()) != null) {
                Level p0 = level2;
                boolean bl = false;
                iEnergyStorage = this.getNetworkFromKey((ResourceKey<Level>)p0);
            } else {
                iEnergyStorage = null;
            }
        }
        return iEnergyStorage;
    }

    @Override
    @Nullable
    public IEnergyStorage getNetworkFromKey(@NotNull ResourceKey<Level> key) {
        IEnergyStorage iEnergyStorage;
        ServerLevel serverLevel;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        IEnergyStorage cached = networkMap.get(key);
        if (cached != null) {
            return cached;
        }
        MinecraftServer minecraftServer = RagiumAPI.Companion.getInstance().getCurrentServer();
        if (minecraftServer != null && (serverLevel = minecraftServer.getLevel(key)) != null) {
            ServerLevel p0 = serverLevel;
            boolean bl = false;
            iEnergyStorage = this.createCache(p0);
        } else {
            iEnergyStorage = null;
        }
        return iEnergyStorage;
    }

    @Override
    @NotNull
    public IEnergyStorage getNetworkFromServer(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        ResourceKey resourceKey = level.dimension();
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"dimension(...)");
        ResourceKey key = resourceKey;
        IEnergyStorage cached = networkMap.get(key);
        if (cached != null) {
            return cached;
        }
        return this.createCache(level);
    }

    private final IEnergyStorage createCache(ServerLevel level) {
        HTEnergyNetwork network2 = SavedDataExtensionsKt.getServerSavedData(level, HTEnergyNetwork.DATA_FACTORY);
        networkMap.compute((ResourceKey<Level>)level.dimension(), (arg_0, arg_1) -> HTEnergyNetworkManagerImpl.createCache$lambda$2((arg_0, arg_1) -> HTEnergyNetworkManagerImpl.createCache$lambda$1(network2, arg_0, arg_1), arg_0, arg_1));
        ResourceKey resourceKey = level.dimension();
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"dimension(...)");
        networkMap.put((ResourceKey<Level>)resourceKey, network2);
        return network2;
    }

    private final void onServerStarted(ServerStartedEvent event) {
        for (Object t : event.getServer().getAllLevels()) {
            Intrinsics.checkNotNullExpressionValue(t, (String)"next(...)");
            ServerLevel level = (ServerLevel)t;
            ResourceKey resourceKey = level.dimension();
            Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"dimension(...)");
            networkMap.put((ResourceKey<Level>)resourceKey, SavedDataExtensionsKt.getServerSavedData(level, HTEnergyNetwork.DATA_FACTORY));
        }
    }

    private final void onServerStopped(ServerStoppedEvent event) {
        networkMap.clear();
    }

    private static final IEnergyStorage createCache$lambda$1(HTEnergyNetwork $network, ResourceKey key, IEnergyStorage old) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        IEnergyStorage iEnergyStorage = old;
        if (iEnergyStorage == null) {
            iEnergyStorage = $network;
        }
        return iEnergyStorage;
    }

    private static final IEnergyStorage createCache$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        return (IEnergyStorage)$tmp0.invoke(p0, p1);
    }

    static {
        NeoForge.EVENT_BUS.addListener(INSTANCE::onServerStarted);
        NeoForge.EVENT_BUS.addListener(INSTANCE::onServerStopped);
        networkMap = new LinkedHashMap();
    }
}

