/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.internal;

import com.mojang.logging.LogUtils;
import hiiragi283.ragium.api.RagiumConfig;
import hiiragi283.ragium.api.advancements.HTBlockInteractionTrigger;
import hiiragi283.ragium.api.extension.LevelExtensionsKt;
import hiiragi283.ragium.api.recipe.HTBlockInteractingRecipe;
import hiiragi283.ragium.api.recipe.HTCauldronDroppingRecipe;
import hiiragi283.ragium.api.recipe.HTInteractRecipeInput;
import hiiragi283.ragium.api.tag.RagiumItemTags;
import hiiragi283.ragium.setup.RagiumComponentTypes;
import hiiragi283.ragium.setup.RagiumItems;
import hiiragi283.ragium.setup.RagiumRecipeTypes;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.neoforged.neoforge.event.entity.EntityStruckByLightningEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@EventBusSubscriber(modid="ragium")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u001aH\u0007R\u0016\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u00a8\u0006\u001b"}, d2={"Lhiiragi283/ragium/internal/RagiumRuntimeEvents;", "", "<init>", "()V", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER$annotations", "onClickedEntity", "", "event", "Lnet/neoforged/neoforge/event/entity/player/PlayerInteractEvent$EntityInteract;", "onClickedBlock", "Lnet/neoforged/neoforge/event/entity/player/PlayerInteractEvent$RightClickBlock;", "onUseItem", "Lnet/neoforged/neoforge/event/entity/player/PlayerInteractEvent$RightClickItem;", "onFinishUsingItem", "Lnet/neoforged/neoforge/event/entity/living/LivingEntityUseItemEvent$Finish;", "onEntityStruck", "Lnet/neoforged/neoforge/event/entity/EntityStruckByLightningEvent;", "onEntityTick", "Lnet/neoforged/neoforge/event/tick/EntityTickEvent$Post;", "onLoadLootTable", "Lnet/neoforged/neoforge/event/LootTableLoadEvent;", "itemTooltips", "Lnet/neoforged/neoforge/event/entity/player/ItemTooltipEvent;", "gatherComponents", "Lnet/neoforged/neoforge/client/event/RenderTooltipEvent$GatherComponents;", "ragium"})
public final class RagiumRuntimeEvents {
    @NotNull
    public static final RagiumRuntimeEvents INSTANCE = new RagiumRuntimeEvents();
    @NotNull
    private static final Logger LOGGER;

    private RagiumRuntimeEvents() {
    }

    @JvmStatic
    private static /* synthetic */ void getLOGGER$annotations() {
    }

    @SubscribeEvent
    public final void onClickedEntity(@NotNull PlayerInteractEvent.EntityInteract event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.isCanceled()) {
            return;
        }
        ItemStack itemStack = event.getItemStack();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemStack(...)");
        ItemStack stack = itemStack;
        if (stack.is(Items.GLASS_BOTTLE)) {
            Entity entity = event.getTarget();
            Bee bee = entity instanceof Bee ? (Bee)entity : null;
            if (bee == null) {
                return;
            }
            Bee target = bee;
            if (target.isAlive()) {
                Player player = event.getEntity();
                Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
                Player player2 = player;
                target.level().playSound(player2, (Entity)target, SoundEvents.BOTTLE_FILL, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!player2.level().isClientSide) {
                    target.discard();
                    stack.shrink(1);
                    LevelExtensionsKt.dropStackAt$default((Entity)player2, (ItemLike)RagiumItems.BOTTLED_BEE, 0, 4, null);
                }
                event.setCancellationResult(InteractionResult.sidedSuccess((boolean)player2.level().isClientSide));
                return;
            }
        }
    }

    @SubscribeEvent
    public final void onClickedBlock(@NotNull PlayerInteractEvent.RightClickBlock event) {
        HTBlockInteractingRecipe hTBlockInteractingRecipe;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.isCanceled()) {
            return;
        }
        InteractionHand interactionHand = event.getHand();
        Intrinsics.checkNotNullExpressionValue((Object)interactionHand, (String)"getHand(...)");
        InteractionHand hand = interactionHand;
        ItemStack itemStack = event.getItemStack();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemStack(...)");
        ItemStack stack = itemStack;
        BlockHitResult blockHitResult = event.getHitVec();
        Intrinsics.checkNotNullExpressionValue((Object)blockHitResult, (String)"getHitVec(...)");
        BlockHitResult hitResult = blockHitResult;
        Level level = event.getLevel();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
        Level level2 = level;
        BlockState blockState = level2.getBlockState(hitResult.getBlockPos());
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
        BlockState state = blockState;
        BlockPos blockPos = hitResult.getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        HTInteractRecipeInput input = new HTInteractRecipeInput(blockPos, stack);
        Optional optional = level2.getRecipeManager().getRecipeFor(RagiumRecipeTypes.BLOCK_INTERACTING.get(), (RecipeInput)input, level2);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getRecipeFor(...)");
        RecipeHolder recipeHolder = (RecipeHolder)OptionalsKt.getOrNull((Optional)optional);
        if (recipeHolder == null || (hTBlockInteractingRecipe = (HTBlockInteractingRecipe)recipeHolder.value()) == null) {
            return;
        }
        HTBlockInteractingRecipe firstRecipe = hTBlockInteractingRecipe;
        Player player = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
        Player player2 = player;
        if (player2 instanceof ServerPlayer) {
            HTBlockInteractionTrigger.INSTANCE.trigger((ServerPlayer)player2, state);
        }
        firstRecipe.applyActions(new UseOnContext(level2, player2, hand, stack, hitResult));
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level2.isClientSide));
    }

    @SubscribeEvent
    public final void onUseItem(@NotNull PlayerInteractEvent.RightClickItem event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.isCanceled()) {
            return;
        }
        ItemStack itemStack = event.getItemStack();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemStack(...)");
        ItemStack stack = itemStack;
        if (stack.isEmpty()) {
            return;
        }
        Player player = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
        Player player2 = player;
        Level level = player2.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        Level level2 = level;
        if (stack.is((Holder)RagiumItems.ENDER_BUNDLE)) {
            level2.playSound(null, player2.blockPosition(), SoundEvents.ENDER_CHEST_OPEN, SoundSource.BLOCKS);
            player2.openMenu((MenuProvider)new SimpleMenuProvider(RagiumRuntimeEvents::onUseItem$lambda$0, (Component)Component.translatable((String)"container.enderchest")));
            player2.awardStat(Stats.OPEN_ENDERCHEST);
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level2.isClientSide));
            return;
        }
        if (stack.is((Holder)RagiumItems.TRADER_CATALOG)) {
            event.setCancellationResult(new WanderingTrader(EntityType.WANDERING_TRADER, level2).interact(player2, InteractionHand.MAIN_HAND));
            return;
        }
        if (stack.is((Holder)RagiumItems.EXP_BERRIES)) {
            player2.giveExperiencePoints(8);
            stack.consume(1, (LivingEntity)player2);
            level2.playSound(null, player2.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS);
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level2.isClientSide));
            return;
        }
        if (stack.is((Holder)RagiumItems.BOTTLED_BEE)) {
            InteractionResult interactionResult = Items.BEE_SPAWN_EGG.use(event.getLevel(), player2, event.getHand()).getResult();
            Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"getResult(...)");
            InteractionResult result = interactionResult;
            if (result.indicateItemUse()) {
                Entity entity = (Entity)player2;
                Item item = Items.GLASS_BOTTLE;
                Intrinsics.checkNotNullExpressionValue((Object)item, (String)"GLASS_BOTTLE");
                LevelExtensionsKt.dropStackAt$default(entity, (ItemLike)item, 0, 4, null);
            }
            event.setCancellationResult(result);
            return;
        }
    }

    @SubscribeEvent
    public final void onFinishUsingItem(@NotNull LivingEntityUseItemEvent.Finish event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ItemStack itemStack = event.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
        ItemStack stack = itemStack;
        if (stack.isEmpty()) {
            return;
        }
        ItemStack itemStack2 = event.getResultStack();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getResultStack(...)");
        ItemStack result = itemStack2;
        LivingEntity livingEntity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)livingEntity, (String)"getEntity(...)");
        LivingEntity user = livingEntity;
        Level level = user.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        Level level2 = level;
        if (stack.is((Holder)RagiumItems.AMBROSIA)) {
            if (result.isEmpty()) {
                event.setResultStack(stack.copy());
            } else {
                result.grow(1);
            }
            return;
        }
        if (stack.is((Holder)RagiumItems.ICE_CREAM)) {
            if (!level2.isClientSide) {
                user.extinguishFire();
            }
            return;
        }
    }

    @SubscribeEvent
    public final void onEntityStruck(@NotNull EntityStruckByLightningEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.isCanceled()) {
            return;
        }
        if (event.getLightning().getCause() != null) {
            return;
        }
        Entity entity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getEntity(...)");
        Entity target = entity;
        LOGGER.info("Entity: " + target.getType() + " is struck!");
        if (target.getPersistentData().getBoolean("AlreadyStruck")) {
            LOGGER.info("Already struck entity found!");
            event.setCanceled(true);
            return;
        }
        ItemEntity itemEntity = target instanceof ItemEntity ? (ItemEntity)target : null;
        if (itemEntity == null) {
            return;
        }
        ItemEntity itemEntity2 = itemEntity;
        ItemStack itemStack = itemEntity2.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
        ItemStack stackIn = itemStack;
        if (stackIn.is(Tags.Items.INGOTS)) {
            itemEntity2.setItem(RagiumItems.RAGI_ALLOY_INGOT.toStack(stackIn.getCount()));
            itemEntity2.getPersistentData().putBoolean("AlreadyStruck", true);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public final void onEntityTick(@NotNull EntityTickEvent.Post event) {
        HTCauldronDroppingRecipe firstRecipe;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity = event.getEntity();
        ItemEntity itemEntity = entity instanceof ItemEntity ? (ItemEntity)entity : null;
        if (itemEntity == null) {
            return;
        }
        ItemEntity itemEntity2 = itemEntity;
        BlockState blockState = itemEntity2.getInBlockState();
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getInBlockState(...)");
        BlockState stateIn = blockState;
        if (stateIn.is(Blocks.CAULDRON) || !stateIn.is(BlockTags.CAULDRONS)) {
            return;
        }
        if (itemEntity2.getPersistentData().getBoolean("IgnoreCauldronDrop")) {
            return;
        }
        Level level = itemEntity2.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        Level level2 = level;
        BlockPos blockPos = itemEntity2.blockPosition();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
        BlockPos pos = blockPos;
        ItemStack itemStack = itemEntity2.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
        ItemStack stack = itemStack;
        int remainCount = stack.getCount() - 1;
        HTInteractRecipeInput input = new HTInteractRecipeInput(pos, stack);
        Optional optional = level2.getRecipeManager().getRecipeFor(RagiumRecipeTypes.CAULDRON_DROPPING.get(), (RecipeInput)input, level2);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getRecipeFor(...)");
        RecipeHolder recipeHolder = (RecipeHolder)OptionalsKt.getOrNull((Optional)optional);
        HTCauldronDroppingRecipe hTCauldronDroppingRecipe = firstRecipe = recipeHolder != null ? (HTCauldronDroppingRecipe)recipeHolder.value() : null;
        if (firstRecipe != null) {
            itemEntity2.setItem(firstRecipe.assemble(input, (HolderLookup.Provider)level2.registryAccess()).copy());
            level2.setBlockAndUpdate(pos, Blocks.CAULDRON.defaultBlockState());
            if (remainCount > 0) {
                Entity entity2 = (Entity)itemEntity2;
                ItemStack itemStack2 = stack.copyWithCount(remainCount);
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"copyWithCount(...)");
                LevelExtensionsKt.dropStackAt(entity2, itemStack2);
            }
        } else {
            itemEntity2.getPersistentData().putBoolean("IgnoreCauldronDrop", true);
        }
    }

    @SubscribeEvent
    public final void onLoadLootTable(@NotNull LootTableLoadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LootTable lootTable = event.getTable();
        Intrinsics.checkNotNullExpressionValue((Object)lootTable, (String)"getTable(...)");
        LootTable loot = lootTable;
        EntityType entityType = EntityType.ELDER_GUARDIAN;
        Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"ELDER_GUARDIAN");
        RagiumRuntimeEvents.onLoadLootTable$modify(loot, entityType, (Function1<? super LootTable, Unit>)((Function1)RagiumRuntimeEvents::onLoadLootTable$lambda$2));
        EntityType entityType2 = EntityType.WANDERING_TRADER;
        Intrinsics.checkNotNullExpressionValue((Object)entityType2, (String)"WANDERING_TRADER");
        RagiumRuntimeEvents.onLoadLootTable$modify(loot, entityType2, (Function1<? super LootTable, Unit>)((Function1)RagiumRuntimeEvents::onLoadLootTable$lambda$3));
    }

    @SubscribeEvent
    public final void itemTooltips(@NotNull ItemTooltipEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ItemStack itemStack = event.getItemStack();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemStack(...)");
        ItemStack stack = itemStack;
        if (stack.is(RagiumItemTags.WIP)) {
            event.getToolTip().add(Component.translatable((String)"text.ragium.work_in_progress").withStyle(ChatFormatting.DARK_RED));
        }
    }

    @SubscribeEvent
    public final void gatherComponents(@NotNull RenderTooltipEvent.GatherComponents event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ItemStack itemStack = event.getItemStack();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemStack(...)");
        ItemStack stack = itemStack;
        SimpleFluidContent simpleFluidContent = (SimpleFluidContent)stack.get(RagiumComponentTypes.FLUID_CONTENT);
        if (simpleFluidContent == null) {
            return;
        }
        SimpleFluidContent content = simpleFluidContent;
        if (content.isEmpty()) {
            return;
        }
    }

    private static final AbstractContainerMenu onUseItem$lambda$0(int containerId, Inventory inventory2, Player playerIn) {
        Intrinsics.checkNotNullParameter((Object)inventory2, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)playerIn, (String)"playerIn");
        return (AbstractContainerMenu)ChestMenu.threeRows((int)containerId, (Inventory)inventory2, (Container)((Container)playerIn.getEnderChestInventory()));
    }

    private static final void onLoadLootTable$modify(LootTable loot, EntityType<?> entityType, Function1<? super LootTable, Unit> function) {
        if (Intrinsics.areEqual((Object)loot.getLootTableId(), (Object)entityType.getDefaultLootTable().location())) {
            function.invoke((Object)loot);
        }
    }

    private static final void onLoadLootTable$modify$1(LootTable loot, Block block, Function1<? super LootTable, Unit> function) {
        if (Intrinsics.areEqual((Object)loot.getLootTableId(), (Object)block.getLootTable().location())) {
            function.invoke((Object)loot);
        }
    }

    private static final Unit onLoadLootTable$lambda$2(LootTable $this$modify) {
        Intrinsics.checkNotNullParameter((Object)$this$modify, (String)"$this$modify");
        $this$modify.addPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RagiumItems.ELDER_HEART))).build());
        LOGGER.info("Modified loot table for Elder Guardian!");
        return Unit.INSTANCE;
    }

    private static final Unit onLoadLootTable$lambda$3(LootTable $this$modify) {
        Intrinsics.checkNotNullParameter((Object)$this$modify, (String)"$this$modify");
        if (((Boolean)RagiumConfig.COMMON.dropTraderCatalog.get()).booleanValue()) {
            $this$modify.addPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RagiumItems.TRADER_CATALOG))).build());
        }
        LOGGER.info("Modified loot table for Wandering Trader!");
        return Unit.INSTANCE;
    }

    static {
        Logger logger = LogUtils.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
    }
}

